/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model;

import ai2.org.apache.poi.util.LittleEndian;
import java.util.Arrays;

public class Xst {
    private int _cch;
    private char[] _rgtchar;

    public Xst() {
        this._cch = 0;
        this._rgtchar = new char[0];
    }

    public Xst(byte[] byArray, int n) {
        int n2 = n;
        this._cch = LittleEndian.getUShort(byArray, n2);
        n2 += 2;
        this._rgtchar = new char[this._cch];
        for (int i = 0; i < this._cch; ++i) {
            this._rgtchar[i] = (char)LittleEndian.getShort(byArray, n2);
            n2 += 2;
        }
    }

    public Xst(String string) {
        this._cch = string.length();
        this._rgtchar = string.toCharArray();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Xst xst = (Xst)object;
        if (this._cch != xst._cch) {
            return false;
        }
        return Arrays.equals(this._rgtchar, xst._rgtchar);
    }

    public String getAsJavaString() {
        return new String(this._rgtchar);
    }

    public int getCch() {
        return this._cch;
    }

    public char[] getRgtchar() {
        return this._rgtchar;
    }

    public int getSize() {
        return 2 + this._rgtchar.length * 2;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this._cch;
        n = 31 * n + Arrays.hashCode(this._rgtchar);
        return n;
    }

    public void serialize(byte[] byArray, int n) {
        int n2 = n;
        LittleEndian.putUShort(byArray, n2, this._cch);
        n2 += 2;
        for (char c : this._rgtchar) {
            LittleEndian.putShort(byArray, n2, (short)c);
            n2 += 2;
        }
    }

    public String toString() {
        return "Xst [" + this._cch + "; " + Arrays.toString(this._rgtchar) + "]";
    }
}

