/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model;

import ai2.org.apache.poi.hwpf.model.CharIndexTranslator;
import ai2.org.apache.poi.hwpf.model.GenericPropertyNode;
import ai2.org.apache.poi.hwpf.model.PieceDescriptor;
import ai2.org.apache.poi.hwpf.model.PlexOfCps;
import ai2.org.apache.poi.hwpf.model.TextPiece;
import ai2.org.apache.poi.hwpf.model.io.HWPFOutputStream;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Internal
public class TextPieceTable
implements CharIndexTranslator {
    private static final POILogger logger = POILogFactory.getLogger(TextPieceTable.class);
    int _cpMin;
    protected ArrayList<TextPiece> _textPieces = new ArrayList();
    protected ArrayList<TextPiece> _textPiecesFCOrder = new ArrayList();

    public TextPieceTable() {
    }

    public TextPieceTable(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        int n4;
        PlexOfCps plexOfCps = new PlexOfCps(byArray2, n, n2, PieceDescriptor.getSizeInBytes());
        int n5 = plexOfCps.length();
        PieceDescriptor[] pieceDescriptorArray = new PieceDescriptor[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            GenericPropertyNode genericPropertyNode = plexOfCps.getProperty(n4);
            pieceDescriptorArray[n4] = new PieceDescriptor(genericPropertyNode.getBytes(), 0);
        }
        this._cpMin = pieceDescriptorArray[0].getFilePosition() - n3;
        for (n4 = 0; n4 < pieceDescriptorArray.length; ++n4) {
            int n6 = pieceDescriptorArray[n4].getFilePosition() - n3;
            if (n6 >= this._cpMin) continue;
            this._cpMin = n6;
        }
        for (n4 = 0; n4 < pieceDescriptorArray.length; ++n4) {
            int n7 = pieceDescriptorArray[n4].getFilePosition();
            GenericPropertyNode genericPropertyNode = plexOfCps.getProperty(n4);
            int n8 = genericPropertyNode.getStart();
            int n9 = genericPropertyNode.getEnd();
            boolean bl = pieceDescriptorArray[n4].isUnicode();
            int n10 = 1;
            if (bl) {
                n10 = 2;
            }
            int n11 = n9 - n8;
            int n12 = n11 * n10;
            byte[] byArray3 = new byte[n12];
            System.arraycopy(byArray, n7, byArray3, 0, n12);
            TextPiece textPiece = new TextPiece(n8, n9, byArray3, pieceDescriptorArray[n4]);
            this._textPieces.add(textPiece);
        }
        Collections.sort(this._textPieces);
        this._textPiecesFCOrder = new ArrayList<TextPiece>(this._textPieces);
        Collections.sort(this._textPiecesFCOrder, new FCComparator());
    }

    public void add(TextPiece textPiece) {
        this._textPieces.add(textPiece);
        this._textPiecesFCOrder.add(textPiece);
        Collections.sort(this._textPieces);
        Collections.sort(this._textPiecesFCOrder, new FCComparator());
    }

    public int adjustForInsert(int n, int n2) {
        int n3 = this._textPieces.size();
        TextPiece textPiece = this._textPieces.get(n);
        textPiece.setEnd(textPiece.getEnd() + n2);
        for (int i = n + 1; i < n3; ++i) {
            textPiece = this._textPieces.get(i);
            textPiece.setStart(textPiece.getStart() + n2);
            textPiece.setEnd(textPiece.getEnd() + n2);
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TextPieceTable)) {
            return false;
        }
        TextPieceTable textPieceTable = (TextPieceTable)object;
        int n = textPieceTable._textPieces.size();
        if (n == this._textPieces.size()) {
            for (int i = 0; i < n; ++i) {
                if (textPieceTable._textPieces.get(i).equals(this._textPieces.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int getByteIndex(int n) {
        int n2 = 0;
        for (TextPiece textPiece : this._textPieces) {
            if (n >= textPiece.getEnd()) {
                n2 = textPiece.getPieceDescriptor().getFilePosition() + (textPiece.getEnd() - textPiece.getStart()) * (textPiece.isUnicode() ? 2 : 1);
                if (n != textPiece.getEnd()) continue;
                break;
            }
            if (n >= textPiece.getEnd()) continue;
            int n3 = n - textPiece.getStart();
            n2 = textPiece.getPieceDescriptor().getFilePosition() + n3 * (textPiece.isUnicode() ? 2 : 1);
            break;
        }
        return n2;
    }

    @Override
    @Deprecated
    public int getCharIndex(int n) {
        return this.getCharIndex(n, 0);
    }

    @Override
    @Deprecated
    public int getCharIndex(int n, int n2) {
        int n3 = 0;
        int n4 = this.lookIndexForward(n);
        for (TextPiece textPiece : this._textPieces) {
            int n5 = textPiece.getPieceDescriptor().getFilePosition();
            int n6 = textPiece.bytesLength();
            int n7 = n5 + n6;
            int n8 = n4 < n5 || n4 > n7 ? n6 : (n4 > n5 && n4 < n7 ? n4 - n5 : n6 - (n7 - n4));
            n3 = textPiece.isUnicode() ? (n3 += n8 / 2) : (n3 += n8);
            if (n4 < n5 || n4 > n7 || n3 < n2) continue;
            break;
        }
        return n3;
    }

    @Override
    public int[][] getCharIndexRanges(int n, int n2) {
        LinkedList<int[]> linkedList = new LinkedList<int[]>();
        for (TextPiece textPiece : this._textPiecesFCOrder) {
            int n3 = textPiece.getPieceDescriptor().getFilePosition();
            int n4 = textPiece.getPieceDescriptor().getFilePosition() + textPiece.bytesLength();
            if (n > n4) continue;
            if (n2 < n3) break;
            int n5 = Math.max(n3, n);
            int n6 = Math.min(n4, n2);
            int n7 = n6 - n5;
            if (n5 > n6) continue;
            int n8 = textPiece.isUnicode() ? 2 : 1;
            int n9 = textPiece.getStart() + (n5 - n3) / n8;
            int n10 = n9 + n7 / n8;
            linkedList.add(new int[]{n9, n10});
        }
        return (int[][])linkedList.toArray((T[])new int[linkedList.size()][]);
    }

    public int getCpMin() {
        return this._cpMin;
    }

    public StringBuilder getText() {
        long l = System.currentTimeMillis();
        StringBuilder stringBuilder = new StringBuilder();
        for (TextPiece textPiece : this._textPieces) {
            String string = textPiece.getStringBuilder().toString();
            int n = string.length();
            if (n != textPiece.getEnd() - textPiece.getStart()) {
                logger.log(5, "Text piece has boundaries [", textPiece.getStart(), "; ", textPiece.getEnd(), ") but length ", textPiece.getEnd() - textPiece.getStart());
            }
            stringBuilder.replace(textPiece.getStart(), textPiece.getStart() + n, string);
        }
        logger.log(1, "Document text were rebuilded in ", System.currentTimeMillis() - l, " ms (", stringBuilder.length(), " chars)");
        return stringBuilder;
    }

    public List<TextPiece> getTextPieces() {
        return this._textPieces;
    }

    public int hashCode() {
        return this._textPieces.size();
    }

    @Override
    public boolean isIndexInTable(int n) {
        for (TextPiece textPiece : this._textPiecesFCOrder) {
            int n2 = textPiece.getPieceDescriptor().getFilePosition();
            if (n > n2 + textPiece.bytesLength()) continue;
            return n2 <= n;
        }
        return false;
    }

    boolean isIndexInTable(int n, int n2) {
        for (TextPiece textPiece : this._textPiecesFCOrder) {
            int n3;
            int n4 = textPiece.getPieceDescriptor().getFilePosition();
            if (n >= n4 + textPiece.bytesLength()) continue;
            int n5 = Math.max(n, n4);
            return n5 < (n3 = Math.min(n2, n4 + textPiece.bytesLength()));
        }
        return false;
    }

    @Override
    public int lookIndexBackward(int n) {
        int n2 = n;
        int n3 = 0;
        for (TextPiece textPiece : this._textPiecesFCOrder) {
            int n4 = textPiece.getPieceDescriptor().getFilePosition();
            if (n2 > n4 + textPiece.bytesLength()) {
                n3 = n4 + textPiece.bytesLength();
                continue;
            }
            if (n4 <= n2) break;
            n2 = n3;
            break;
        }
        return n2;
    }

    @Override
    public int lookIndexForward(int n) {
        if (this._textPiecesFCOrder.isEmpty()) {
            throw new IllegalStateException("Text pieces table is empty");
        }
        if (this._textPiecesFCOrder.get(0).getPieceDescriptor().getFilePosition() > n) {
            return this._textPiecesFCOrder.get(0).getPieceDescriptor().getFilePosition();
        }
        if (this._textPiecesFCOrder.get(this._textPiecesFCOrder.size() - 1).getPieceDescriptor().getFilePosition() <= n) {
            return n;
        }
        int n2 = 0;
        int n3 = this._textPiecesFCOrder.size() - 1;
        while (n2 <= n3) {
            int n4 = n2 + n3 >>> 1;
            TextPiece textPiece = this._textPiecesFCOrder.get(n4);
            int n5 = textPiece.getPieceDescriptor().getFilePosition();
            if (n5 < n) {
                n2 = n4 + 1;
                continue;
            }
            if (n5 > n) {
                n3 = n4 - 1;
                continue;
            }
            return textPiece.getPieceDescriptor().getFilePosition();
        }
        assert (n2 == n3);
        assert (this._textPiecesFCOrder.get(n2).getPieceDescriptor().getFilePosition() < n);
        assert (this._textPiecesFCOrder.get(n2 + 1).getPieceDescriptor().getFilePosition() > n);
        return this._textPiecesFCOrder.get(n2 + 1).getPieceDescriptor().getFilePosition();
    }

    public byte[] writeTo(HWPFOutputStream hWPFOutputStream) throws IOException {
        PlexOfCps plexOfCps = new PlexOfCps(PieceDescriptor.getSizeInBytes());
        int n = this._textPieces.size();
        for (int i = 0; i < n; ++i) {
            TextPiece textPiece = this._textPieces.get(i);
            PieceDescriptor pieceDescriptor = textPiece.getPieceDescriptor();
            int n2 = hWPFOutputStream.getOffset();
            int n3 = n2 % 512;
            if (n3 != 0) {
                n3 = 512 - n3;
                byte[] byArray = new byte[n3];
                hWPFOutputStream.write(byArray);
            }
            pieceDescriptor.setFilePosition(hWPFOutputStream.getOffset());
            hWPFOutputStream.write(textPiece.getRawBytes());
            int n4 = textPiece.getStart();
            int n5 = textPiece.getEnd();
            plexOfCps.addProperty(new GenericPropertyNode(n4, n5, pieceDescriptor.toByteArray()));
        }
        return plexOfCps.toByteArray();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FCComparator
    implements Comparator<TextPiece> {
        private FCComparator() {
        }

        @Override
        public int compare(TextPiece textPiece, TextPiece textPiece2) {
            if (textPiece.getPieceDescriptor().fc > textPiece2.getPieceDescriptor().fc) {
                return 1;
            }
            if (textPiece.getPieceDescriptor().fc < textPiece2.getPieceDescriptor().fc) {
                return -1;
            }
            return 0;
        }
    }
}

