/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model;

import ai2.org.apache.poi.hwpf.model.HDFType;
import ai2.org.apache.poi.hwpf.model.Stshif;
import ai2.org.apache.poi.hwpf.model.StyleDescription;
import ai2.org.apache.poi.hwpf.model.io.HWPFOutputStream;
import ai2.org.apache.poi.hwpf.sprm.CharacterSprmUncompressor;
import ai2.org.apache.poi.hwpf.sprm.ParagraphSprmUncompressor;
import ai2.org.apache.poi.hwpf.usermodel.CharacterProperties;
import ai2.org.apache.poi.hwpf.usermodel.ParagraphProperties;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;

@Internal
public final class StyleSheet
implements HDFType {
    public static final int NIL_STYLE = 4095;
    @Deprecated
    private static final ParagraphProperties NIL_PAP = new ParagraphProperties();
    @Deprecated
    private static final CharacterProperties NIL_CHP = new CharacterProperties();
    private static final byte[] NIL_CHPX = new byte[0];
    private static final byte[] NIL_PAPX = new byte[]{0, 0};
    private int _cbStshi;
    private Stshif _stshif;
    StyleDescription[] _styleDescriptions;

    public StyleSheet(byte[] byArray, int n) {
        int n2;
        int n3 = n;
        this._cbStshi = LittleEndian.getShort(byArray, n);
        this._stshif = new Stshif(byArray, n += 2);
        n += Stshif.getSize();
        n = n3 + 2 + this._cbStshi;
        this._styleDescriptions = new StyleDescription[this._stshif.getCstd()];
        for (n2 = 0; n2 < this._stshif.getCstd(); ++n2) {
            short s = LittleEndian.getShort(byArray, n);
            n += 2;
            if (s > 0) {
                StyleDescription styleDescription;
                this._styleDescriptions[n2] = styleDescription = new StyleDescription(byArray, this._stshif.getCbSTDBaseInFile(), n, true);
            }
            n += s;
        }
        for (n2 = 0; n2 < this._styleDescriptions.length; ++n2) {
            if (this._styleDescriptions[n2] == null) continue;
            this.createPap(n2);
            this.createChp(n2);
        }
    }

    public void writeTo(HWPFOutputStream hWPFOutputStream) throws IOException {
        int n = 0;
        this._cbStshi = 18;
        byte[] byArray = new byte[this._cbStshi + 2];
        LittleEndian.putUShort(byArray, n, (short)this._cbStshi);
        this._stshif.setCstd(this._styleDescriptions.length);
        this._stshif.serialize(byArray, n += 2);
        hWPFOutputStream.write(byArray);
        byte[] byArray2 = new byte[2];
        for (int i = 0; i < this._styleDescriptions.length; ++i) {
            if (this._styleDescriptions[i] != null) {
                byte[] byArray3 = this._styleDescriptions[i].toByteArray();
                LittleEndian.putShort(byArray2, 0, (short)(byArray3.length + byArray3.length % 2));
                hWPFOutputStream.write(byArray2);
                hWPFOutputStream.write(byArray3);
                if (byArray3.length % 2 != 1) continue;
                hWPFOutputStream.write(0);
                continue;
            }
            byArray2[0] = 0;
            byArray2[1] = 0;
            hWPFOutputStream.write(byArray2);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof StyleSheet)) {
            return false;
        }
        StyleSheet styleSheet = (StyleSheet)object;
        if (!styleSheet._stshif.equals(this._stshif) || styleSheet._cbStshi != this._cbStshi || styleSheet._styleDescriptions.length != this._styleDescriptions.length) {
            return false;
        }
        for (int i = 0; i < this._styleDescriptions.length; ++i) {
            StyleDescription styleDescription = this._styleDescriptions[i];
            StyleDescription styleDescription2 = styleSheet._styleDescriptions[i];
            if (styleDescription == null && styleDescription2 == null || styleDescription != null && styleDescription2 != null && styleDescription2.equals(styleDescription)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    @Deprecated
    private void createPap(int n) {
        StyleDescription styleDescription = this._styleDescriptions[n];
        ParagraphProperties paragraphProperties = styleDescription.getPAP();
        byte[] byArray = styleDescription.getPAPX();
        int n2 = styleDescription.getBaseStyle();
        if (paragraphProperties == null && byArray != null) {
            ParagraphProperties paragraphProperties2 = new ParagraphProperties();
            if (n2 != 4095 && (paragraphProperties2 = this._styleDescriptions[n2].getPAP()) == null) {
                if (n2 == n) {
                    throw new IllegalStateException("Pap style " + n + " claimed to have itself as its parent, which isn't allowed");
                }
                this.createPap(n2);
                paragraphProperties2 = this._styleDescriptions[n2].getPAP();
            }
            if (paragraphProperties2 == null) {
                paragraphProperties2 = new ParagraphProperties();
            }
            paragraphProperties = ParagraphSprmUncompressor.uncompressPAP(paragraphProperties2, byArray, 2);
            styleDescription.setPAP(paragraphProperties);
        }
    }

    @Deprecated
    private void createChp(int n) {
        StyleDescription styleDescription = this._styleDescriptions[n];
        CharacterProperties characterProperties = styleDescription.getCHP();
        byte[] byArray = styleDescription.getCHPX();
        int n2 = styleDescription.getBaseStyle();
        if (n2 == n) {
            n2 = 4095;
        }
        if (characterProperties == null && byArray != null) {
            CharacterProperties characterProperties2 = new CharacterProperties();
            if (n2 != 4095) {
                characterProperties2 = this._styleDescriptions[n2].getCHP();
                if (characterProperties2 == null) {
                    this.createChp(n2);
                    characterProperties2 = this._styleDescriptions[n2].getCHP();
                }
                if (characterProperties2 == null) {
                    characterProperties2 = new CharacterProperties();
                }
            }
            characterProperties = CharacterSprmUncompressor.uncompressCHP(characterProperties2, byArray, 0);
            styleDescription.setCHP(characterProperties);
        }
    }

    public int numStyles() {
        return this._styleDescriptions.length;
    }

    public StyleDescription getStyleDescription(int n) {
        return this._styleDescriptions[n];
    }

    @Deprecated
    public CharacterProperties getCharacterStyle(int n) {
        if (n == 4095) {
            return NIL_CHP;
        }
        if (n >= this._styleDescriptions.length) {
            return NIL_CHP;
        }
        return this._styleDescriptions[n] != null ? this._styleDescriptions[n].getCHP() : NIL_CHP;
    }

    @Deprecated
    public ParagraphProperties getParagraphStyle(int n) {
        if (n == 4095) {
            return NIL_PAP;
        }
        if (n >= this._styleDescriptions.length) {
            return NIL_PAP;
        }
        if (this._styleDescriptions[n] == null) {
            return NIL_PAP;
        }
        if (this._styleDescriptions[n].getPAP() == null) {
            return NIL_PAP;
        }
        return this._styleDescriptions[n].getPAP();
    }

    public byte[] getCHPX(int n) {
        if (n == 4095) {
            return NIL_CHPX;
        }
        if (n >= this._styleDescriptions.length) {
            return NIL_CHPX;
        }
        if (this._styleDescriptions[n] == null) {
            return NIL_CHPX;
        }
        if (this._styleDescriptions[n].getCHPX() == null) {
            return NIL_CHPX;
        }
        return this._styleDescriptions[n].getCHPX();
    }

    public byte[] getPAPX(int n) {
        if (n == 4095) {
            return NIL_PAPX;
        }
        if (n >= this._styleDescriptions.length) {
            return NIL_PAPX;
        }
        if (this._styleDescriptions[n] == null) {
            return NIL_PAPX;
        }
        if (this._styleDescriptions[n].getPAPX() == null) {
            return NIL_PAPX;
        }
        return this._styleDescriptions[n].getPAPX();
    }
}

