/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model;

import ai2.org.apache.poi.hwpf.model.GenericPropertyNode;
import ai2.org.apache.poi.hwpf.model.PlexOfCps;
import ai2.org.apache.poi.hwpf.model.PropertyNode;
import ai2.org.apache.poi.hwpf.model.SEPX;
import ai2.org.apache.poi.hwpf.model.SectionDescriptor;
import ai2.org.apache.poi.hwpf.model.TextPiece;
import ai2.org.apache.poi.hwpf.model.TextPieceTable;
import ai2.org.apache.poi.hwpf.model.io.HWPFFileSystem;
import ai2.org.apache.poi.hwpf.model.io.HWPFOutputStream;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Internal
public class SectionTable {
    private static final POILogger _logger = POILogFactory.getLogger(SectionTable.class);
    private static final int SED_SIZE = 12;
    protected List<SEPX> _sections = new ArrayList<SEPX>();
    protected List<TextPiece> _text;

    public SectionTable() {
    }

    public SectionTable(byte[] byArray, byte[] byArray2, int n, int n2, int n3, TextPieceTable textPieceTable, int n4) {
        int n5;
        int n6;
        int n7;
        PlexOfCps plexOfCps = new PlexOfCps(byArray2, n, n2, 12);
        this._text = textPieceTable.getTextPieces();
        int n8 = plexOfCps.length();
        for (n7 = 0; n7 < n8; ++n7) {
            GenericPropertyNode genericPropertyNode = plexOfCps.getProperty(n7);
            SectionDescriptor sectionDescriptor = new SectionDescriptor(genericPropertyNode.getBytes(), 0);
            n6 = sectionDescriptor.getFc();
            int n9 = genericPropertyNode.getStart();
            int n10 = genericPropertyNode.getEnd();
            if (n6 == -1) {
                this._sections.add(new SEPX(sectionDescriptor, n9, n10, new byte[0]));
                continue;
            }
            n5 = LittleEndian.getShort(byArray, n6);
            byte[] byArray3 = new byte[n5];
            System.arraycopy(byArray, n6 += 2, byArray3, 0, byArray3.length);
            this._sections.add(new SEPX(sectionDescriptor, n9, n10, byArray3));
        }
        n7 = n4;
        boolean bl = false;
        boolean bl2 = false;
        for (n6 = 0; n6 < this._sections.size(); ++n6) {
            SEPX sEPX = this._sections.get(n6);
            if (sEPX.getEnd() == n7) {
                bl = true;
                continue;
            }
            if (sEPX.getEnd() != n7 && sEPX.getEnd() != n7 - 1) continue;
            bl2 = true;
        }
        if (!bl && bl2) {
            _logger.log(5, new Object[]{"Your document seemed to be mostly unicode, but the section definition was in bytes! Trying anyway, but things may well go wrong!"});
            for (n6 = 0; n6 < this._sections.size(); ++n6) {
                SEPX sEPX = this._sections.get(n6);
                GenericPropertyNode genericPropertyNode = plexOfCps.getProperty(n6);
                n5 = genericPropertyNode.getStart();
                int n11 = genericPropertyNode.getEnd();
                sEPX.setStart(n5);
                sEPX.setEnd(n11);
            }
        }
        Collections.sort(this._sections, PropertyNode.StartComparator.instance);
    }

    public void adjustForInsert(int n, int n2) {
        int n3 = this._sections.size();
        SEPX sEPX = this._sections.get(n);
        sEPX.setEnd(sEPX.getEnd() + n2);
        for (int i = n + 1; i < n3; ++i) {
            sEPX = this._sections.get(i);
            sEPX.setStart(sEPX.getStart() + n2);
            sEPX.setEnd(sEPX.getEnd() + n2);
        }
    }

    public List<SEPX> getSections() {
        return this._sections;
    }

    @Deprecated
    public void writeTo(HWPFFileSystem hWPFFileSystem, int n) throws IOException {
        HWPFOutputStream hWPFOutputStream = hWPFFileSystem.getStream("WordDocument");
        HWPFOutputStream hWPFOutputStream2 = hWPFFileSystem.getStream("1Table");
        this.writeTo(hWPFOutputStream, hWPFOutputStream2);
    }

    public void writeTo(HWPFOutputStream hWPFOutputStream, HWPFOutputStream hWPFOutputStream2) throws IOException {
        int n = hWPFOutputStream.getOffset();
        int n2 = this._sections.size();
        PlexOfCps plexOfCps = new PlexOfCps(12);
        for (int i = 0; i < n2; ++i) {
            SEPX sEPX = this._sections.get(i);
            byte[] byArray = sEPX.getGrpprl();
            byte[] byArray2 = new byte[2];
            LittleEndian.putShort(byArray2, (short)byArray.length);
            hWPFOutputStream.write(byArray2);
            hWPFOutputStream.write(byArray);
            SectionDescriptor sectionDescriptor = sEPX.getSectionDescriptor();
            sectionDescriptor.setFc(n);
            GenericPropertyNode genericPropertyNode = new GenericPropertyNode(sEPX.getStart(), sEPX.getEnd(), sectionDescriptor.toByteArray());
            plexOfCps.addProperty(genericPropertyNode);
            n = hWPFOutputStream.getOffset();
        }
        hWPFOutputStream2.write(plexOfCps.toByteArray());
    }
}

