/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model;

import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;

@Internal
public final class SectionDescriptor {
    private short fn;
    private int fcSepx;
    private short fnMpr;
    private int fcMpr;

    public SectionDescriptor() {
    }

    public SectionDescriptor(byte[] byArray, int n) {
        this.fn = LittleEndian.getShort(byArray, n);
        this.fcSepx = LittleEndian.getInt(byArray, n += 2);
        this.fnMpr = LittleEndian.getShort(byArray, n += 4);
        this.fcMpr = LittleEndian.getInt(byArray, n += 2);
    }

    public int getFc() {
        return this.fcSepx;
    }

    public void setFc(int n) {
        this.fcSepx = n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SectionDescriptor)) {
            return false;
        }
        SectionDescriptor sectionDescriptor = (SectionDescriptor)object;
        return sectionDescriptor.fn == this.fn && sectionDescriptor.fnMpr == this.fnMpr;
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    public byte[] toByteArray() {
        int n = 0;
        byte[] byArray = new byte[12];
        LittleEndian.putShort(byArray, n, this.fn);
        LittleEndian.putInt(byArray, n += 2, this.fcSepx);
        LittleEndian.putShort(byArray, n += 4, this.fnMpr);
        LittleEndian.putInt(byArray, n += 2, this.fcMpr);
        return byArray;
    }

    public String toString() {
        return "[SED] (fn: " + this.fn + "; fcSepx: " + this.fcSepx + "; fnMpr: " + this.fnMpr + "; fcMpr: " + this.fcMpr + ")";
    }
}

