/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model;

import ai2.org.apache.poi.hwpf.model.SavedByEntry;
import ai2.org.apache.poi.hwpf.model.SttbUtils;
import ai2.org.apache.poi.hwpf.model.io.HWPFOutputStream;
import ai2.org.apache.poi.util.Internal;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Internal
public final class SavedByTable {
    private SavedByEntry[] entries;

    public SavedByTable(byte[] byArray, int n, int n2) {
        String[] stringArray = SttbUtils.readSttbSavedBy(byArray, n);
        int n3 = stringArray.length / 2;
        this.entries = new SavedByEntry[n3];
        for (int i = 0; i < n3; ++i) {
            this.entries[i] = new SavedByEntry(stringArray[i * 2], stringArray[i * 2 + 1]);
        }
    }

    public List<SavedByEntry> getEntries() {
        return Collections.unmodifiableList(Arrays.asList(this.entries));
    }

    public void writeTo(HWPFOutputStream hWPFOutputStream) throws IOException {
        String[] stringArray = new String[this.entries.length * 2];
        int n = 0;
        for (SavedByEntry savedByEntry : this.entries) {
            stringArray[n++] = savedByEntry.getUserName();
            stringArray[n++] = savedByEntry.getSaveLocation();
        }
        SttbUtils.writeSttbSavedBy(stringArray, hWPFOutputStream);
    }
}

