/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model;

import ai2.org.apache.poi.hwpf.model.PropertyModifier;
import ai2.org.apache.poi.util.BitField;
import ai2.org.apache.poi.util.BitFieldFactory;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;

@Internal
public final class PieceDescriptor {
    short descriptor;
    private static BitField fNoParaLast = BitFieldFactory.getInstance(1);
    private static BitField fPaphNil = BitFieldFactory.getInstance(2);
    private static BitField fCopied = BitFieldFactory.getInstance(4);
    int fc;
    PropertyModifier prm;
    boolean unicode;

    public PieceDescriptor(byte[] byArray, int n) {
        this.descriptor = LittleEndian.getShort(byArray, n);
        this.fc = LittleEndian.getInt(byArray, n += 2);
        this.prm = new PropertyModifier(LittleEndian.getShort(byArray, n += 4));
        if ((this.fc & 0x40000000) == 0) {
            this.unicode = true;
        } else {
            this.unicode = false;
            this.fc &= 0xBFFFFFFF;
            this.fc /= 2;
        }
    }

    public int getFilePosition() {
        return this.fc;
    }

    public void setFilePosition(int n) {
        this.fc = n;
    }

    public boolean isUnicode() {
        return this.unicode;
    }

    public PropertyModifier getPrm() {
        return this.prm;
    }

    protected byte[] toByteArray() {
        int n = this.fc;
        if (!this.unicode) {
            n *= 2;
            n |= 0x40000000;
        }
        int n2 = 0;
        byte[] byArray = new byte[8];
        LittleEndian.putShort(byArray, n2, this.descriptor);
        LittleEndian.putInt(byArray, n2 += 2, n);
        LittleEndian.putShort(byArray, n2 += 4, this.prm.getValue());
        return byArray;
    }

    public static int getSizeInBytes() {
        return 8;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.descriptor;
        n = 31 * n + (this.prm == null ? 0 : this.prm.hashCode());
        n = 31 * n + (this.unicode ? 1231 : 1237);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PieceDescriptor pieceDescriptor = (PieceDescriptor)object;
        if (this.descriptor != pieceDescriptor.descriptor) {
            return false;
        }
        if (this.prm == null ? pieceDescriptor.prm != null : !this.prm.equals(pieceDescriptor.prm)) {
            return false;
        }
        return this.unicode == pieceDescriptor.unicode;
    }

    public String toString() {
        return "PieceDescriptor (pos: " + this.getFilePosition() + "; " + (this.isUnicode() ? "unicode" : "non-unicode") + "; prm: " + this.getPrm() + ")";
    }
}

