/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model;

import ai2.org.apache.poi.ddf.DefaultEscherRecordFactory;
import ai2.org.apache.poi.ddf.EscherBSERecord;
import ai2.org.apache.poi.ddf.EscherBlipRecord;
import ai2.org.apache.poi.ddf.EscherRecord;
import ai2.org.apache.poi.hwpf.HWPFDocument;
import ai2.org.apache.poi.hwpf.model.EscherRecordHolder;
import ai2.org.apache.poi.hwpf.model.FSPATable;
import ai2.org.apache.poi.hwpf.usermodel.CharacterRun;
import ai2.org.apache.poi.hwpf.usermodel.Picture;
import ai2.org.apache.poi.hwpf.usermodel.Range;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Internal
public final class PicturesTable {
    private static final POILogger logger = POILogFactory.getLogger(PicturesTable.class);
    static final int TYPE_IMAGE = 8;
    static final int TYPE_IMAGE_WORD2000 = 0;
    static final int TYPE_IMAGE_PASTED_FROM_CLIPBOARD = 10;
    static final int TYPE_IMAGE_PASTED_FROM_CLIPBOARD_WORD2000 = 2;
    static final int TYPE_HORIZONTAL_LINE = 14;
    static final int BLOCK_TYPE_OFFSET = 14;
    static final int MM_MODE_TYPE_OFFSET = 6;
    private HWPFDocument _document;
    private byte[] _dataStream;
    private byte[] _mainStream;
    @Deprecated
    private FSPATable _fspa;
    @Deprecated
    private EscherRecordHolder _dgg;

    @Deprecated
    public PicturesTable(HWPFDocument hWPFDocument, byte[] byArray, byte[] byArray2, FSPATable fSPATable, EscherRecordHolder escherRecordHolder) {
        this._document = hWPFDocument;
        this._dataStream = byArray;
        this._mainStream = byArray2;
        this._fspa = fSPATable;
        this._dgg = escherRecordHolder;
    }

    public PicturesTable(HWPFDocument hWPFDocument, byte[] byArray, byte[] byArray2) {
        this._document = hWPFDocument;
        this._dataStream = byArray;
        this._mainStream = byArray2;
    }

    public boolean hasPicture(CharacterRun characterRun) {
        if (characterRun == null) {
            return false;
        }
        if (characterRun.isSpecialCharacter() && !characterRun.isObj() && !characterRun.isOle2() && !characterRun.isData() && ("\u0001".equals(characterRun.text()) || "\u0001\u0015".equals(characterRun.text()))) {
            return this.isBlockContainsImage(characterRun.getPicOffset());
        }
        return false;
    }

    public boolean hasEscherPicture(CharacterRun characterRun) {
        return characterRun.isSpecialCharacter() && !characterRun.isObj() && !characterRun.isOle2() && !characterRun.isData() && characterRun.text().startsWith("\b");
    }

    public boolean hasHorizontalLine(CharacterRun characterRun) {
        if (characterRun.isSpecialCharacter() && "\u0001".equals(characterRun.text())) {
            return this.isBlockContainsHorizontalLine(characterRun.getPicOffset());
        }
        return false;
    }

    private boolean isPictureRecognized(short s, short s2) {
        return s == 8 || s == 10 || s == 0 && s2 == 100 || s == 2 && s2 == 100;
    }

    private static short getBlockType(byte[] byArray, int n) {
        return LittleEndian.getShort(byArray, n + 14);
    }

    private static short getMmMode(byte[] byArray, int n) {
        return LittleEndian.getShort(byArray, n + 6);
    }

    public Picture extractPicture(CharacterRun characterRun, boolean bl) {
        if (this.hasPicture(characterRun)) {
            return new Picture(characterRun.getPicOffset(), this._dataStream, bl);
        }
        return null;
    }

    private void searchForPictures(List<EscherRecord> list, List<Picture> list2) {
        for (EscherRecord escherRecord : list) {
            if (escherRecord instanceof EscherBSERecord) {
                EscherBSERecord escherBSERecord = (EscherBSERecord)escherRecord;
                EscherBlipRecord escherBlipRecord = escherBSERecord.getBlipRecord();
                if (escherBlipRecord != null) {
                    list2.add(new Picture(escherBlipRecord));
                } else if (escherBSERecord.getOffset() > 0) {
                    try {
                        DefaultEscherRecordFactory defaultEscherRecordFactory = new DefaultEscherRecordFactory();
                        EscherRecord escherRecord2 = defaultEscherRecordFactory.createRecord(this._mainStream, escherBSERecord.getOffset());
                        if (escherRecord2 instanceof EscherBlipRecord) {
                            escherRecord2.fillFields(this._mainStream, escherBSERecord.getOffset(), defaultEscherRecordFactory);
                            escherBlipRecord = (EscherBlipRecord)escherRecord2;
                            list2.add(new Picture(escherBlipRecord));
                        }
                    }
                    catch (Exception exception) {
                        logger.log(5, "Unable to load picture from BLIB record at offset #", escherBSERecord.getOffset(), exception);
                    }
                }
            }
            this.searchForPictures(escherRecord.getChildRecords(), list2);
        }
    }

    public List<Picture> getAllPictures() {
        ArrayList<Picture> arrayList = new ArrayList<Picture>();
        Range range = this._document.getOverallRange();
        for (int i = 0; i < range.numCharacterRuns(); ++i) {
            Picture picture;
            CharacterRun characterRun = range.getCharacterRun(i);
            if (characterRun == null || (picture = this.extractPicture(characterRun, false)) == null) continue;
            arrayList.add(picture);
        }
        this.searchForPictures(this._dgg.getEscherRecords(), arrayList);
        return arrayList;
    }

    private boolean isBlockContainsImage(int n) {
        return this.isPictureRecognized(PicturesTable.getBlockType(this._dataStream, n), PicturesTable.getMmMode(this._dataStream, n));
    }

    private boolean isBlockContainsHorizontalLine(int n) {
        return PicturesTable.getBlockType(this._dataStream, n) == 14 && PicturesTable.getMmMode(this._dataStream, n) == 100;
    }
}

