/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model;

import ai2.org.apache.poi.util.BitField;
import ai2.org.apache.poi.util.BitFieldFactory;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.OutputStream;

@Internal
public final class ParagraphHeight {
    private short infoField;
    private BitField fSpare = BitFieldFactory.getInstance(1);
    private BitField fUnk = BitFieldFactory.getInstance(2);
    private BitField fDiffLines = BitFieldFactory.getInstance(4);
    private BitField clMac = BitFieldFactory.getInstance(65280);
    private short reserved;
    private int dxaCol;
    private int dymLineOrHeight;

    public ParagraphHeight(byte[] byArray, int n) {
        this.infoField = LittleEndian.getShort(byArray, n);
        this.reserved = LittleEndian.getShort(byArray, n += 2);
        this.dxaCol = LittleEndian.getInt(byArray, n += 2);
        this.dymLineOrHeight = LittleEndian.getInt(byArray, n += 4);
    }

    public ParagraphHeight() {
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.toByteArray());
    }

    protected byte[] toByteArray() {
        byte[] byArray = new byte[12];
        int n = 0;
        LittleEndian.putShort(byArray, n, this.infoField);
        LittleEndian.putShort(byArray, n += 2, this.reserved);
        LittleEndian.putInt(byArray, n += 2, this.dxaCol);
        LittleEndian.putInt(byArray, n += 4, this.dymLineOrHeight);
        return byArray;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ParagraphHeight)) {
            return false;
        }
        ParagraphHeight paragraphHeight = (ParagraphHeight)object;
        return this.infoField == paragraphHeight.infoField && this.reserved == paragraphHeight.reserved && this.dxaCol == paragraphHeight.dxaCol && this.dymLineOrHeight == paragraphHeight.dymLineOrHeight;
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }
}

