/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model;

import ai2.org.apache.poi.hwpf.model.CharIndexTranslator;
import ai2.org.apache.poi.hwpf.model.ComplexFileTable;
import ai2.org.apache.poi.hwpf.model.GenericPropertyNode;
import ai2.org.apache.poi.hwpf.model.PAPFormattedDiskPage;
import ai2.org.apache.poi.hwpf.model.PAPX;
import ai2.org.apache.poi.hwpf.model.PlexOfCps;
import ai2.org.apache.poi.hwpf.model.PropertyModifier;
import ai2.org.apache.poi.hwpf.model.PropertyNode;
import ai2.org.apache.poi.hwpf.model.TextPiece;
import ai2.org.apache.poi.hwpf.model.TextPieceTable;
import ai2.org.apache.poi.hwpf.model.io.HWPFFileSystem;
import ai2.org.apache.poi.hwpf.model.io.HWPFOutputStream;
import ai2.org.apache.poi.hwpf.sprm.SprmBuffer;
import ai2.org.apache.poi.hwpf.sprm.SprmIterator;
import ai2.org.apache.poi.hwpf.sprm.SprmOperation;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Internal
public class PAPBinTable {
    private static final POILogger logger = POILogFactory.getLogger(PAPBinTable.class);
    protected ArrayList<PAPX> _paragraphs = new ArrayList();

    public PAPBinTable() {
    }

    public PAPBinTable(byte[] byArray, byte[] byArray2, byte[] byArray3, int n, int n2, int n3, TextPieceTable textPieceTable) {
        this(byArray, byArray2, byArray3, n, n2, textPieceTable);
    }

    public PAPBinTable(byte[] byArray, byte[] byArray2, byte[] byArray3, int n, int n2, CharIndexTranslator charIndexTranslator) {
        long l = System.currentTimeMillis();
        PlexOfCps plexOfCps = new PlexOfCps(byArray2, n, n2, 4);
        int n3 = plexOfCps.length();
        for (int i = 0; i < n3; ++i) {
            GenericPropertyNode genericPropertyNode = plexOfCps.getProperty(i);
            int n4 = LittleEndian.getInt(genericPropertyNode.getBytes());
            int n5 = 512 * n4;
            PAPFormattedDiskPage pAPFormattedDiskPage = new PAPFormattedDiskPage(byArray, byArray3, n5, charIndexTranslator);
            for (PAPX pAPX : pAPFormattedDiskPage.getPAPXs()) {
                if (pAPX == null) continue;
                this._paragraphs.add(pAPX);
            }
        }
        logger.log(1, "PAPX tables loaded in ", System.currentTimeMillis() - l, " ms (", this._paragraphs.size(), " elements)");
        if (this._paragraphs.isEmpty()) {
            logger.log(5, new Object[]{"PAPX FKPs are empty"});
            this._paragraphs.add(new PAPX(0, 0, new SprmBuffer(2)));
        }
    }

    public void rebuild(StringBuilder stringBuilder, ComplexFileTable complexFileTable) {
        PAPBinTable.rebuild(stringBuilder, complexFileTable, this._paragraphs);
    }

    static void rebuild(StringBuilder stringBuilder, ComplexFileTable complexFileTable, List<PAPX> list) {
        int n;
        Cloneable cloneable;
        Object object;
        long l = System.currentTimeMillis();
        if (complexFileTable != null) {
            object = complexFileTable.getGrpprls();
            for (TextPiece textPiece : complexFileTable.getTextPieceTable().getTextPieces()) {
                Object object2;
                cloneable = textPiece.getPieceDescriptor().getPrm();
                if (!((PropertyModifier)cloneable).isComplex()) continue;
                short s = ((PropertyModifier)cloneable).getIgrpprl();
                if (s < 0 || s >= ((SprmBuffer[])object).length) {
                    logger.log(5, new Object[]{textPiece + "'s PRM references to unknown grpprl"});
                    continue;
                }
                n = 0;
                SprmBuffer sprmBuffer = object[s];
                Object object3 = sprmBuffer.iterator();
                while (((SprmIterator)object3).hasNext()) {
                    object2 = ((SprmIterator)object3).next();
                    if (((SprmOperation)object2).getType() != 1) continue;
                    n = 1;
                    break;
                }
                if (n == 0) continue;
                object3 = new SprmBuffer(2);
                ((SprmBuffer)object3).append(sprmBuffer.toByteArray());
                object2 = new PAPX(textPiece.getStart(), textPiece.getEnd(), (SprmBuffer)object3);
                list.add((PAPX)object2);
            }
            logger.log(1, "Merged (?) with PAPX from complex file table in ", System.currentTimeMillis() - l, " ms (", list.size(), " elements in total)");
            l = System.currentTimeMillis();
        }
        object = new ArrayList<PAPX>(list);
        Collections.sort(object, PropertyNode.EndComparator.instance);
        logger.log(1, "PAPX sorted by end position in ", System.currentTimeMillis() - l, " ms");
        l = System.currentTimeMillis();
        final IdentityHashMap identityHashMap = new IdentityHashMap();
        int n2 = 0;
        for (PAPX pAPX : list) {
            identityHashMap.put(pAPX, n2++);
        }
        Comparator<PAPX> comparator = new Comparator<PAPX>(){

            @Override
            public int compare(PAPX pAPX, PAPX pAPX2) {
                Integer n = (Integer)identityHashMap.get(pAPX);
                Integer n2 = (Integer)identityHashMap.get(pAPX2);
                return n.compareTo(n2);
            }
        };
        logger.log(1, "PAPX's order map created in ", System.currentTimeMillis() - l, " ms");
        l = System.currentTimeMillis();
        cloneable = new LinkedList<Object>();
        int n3 = 0;
        n = 0;
        for (int i = 0; i < stringBuilder.length(); ++i) {
            Cloneable cloneable2;
            Object object4;
            char c = stringBuilder.charAt(i);
            if (c != '\r' && c != '\u0007' && c != '\f') continue;
            int n4 = n3;
            int n5 = i + 1;
            boolean bl = false;
            LinkedList<PAPX> linkedList = new LinkedList<PAPX>();
            for (int j = n; j < object.size(); ++j) {
                bl = false;
                object4 = (PAPX)object.get(j);
                assert (n4 == 0 || j + 1 == object.size() || ((PropertyNode)object4).getEnd() > n4);
                if (((PropertyNode)object4).getEnd() - 1 > i) {
                    n = j;
                    bl = true;
                    break;
                }
                linkedList.add((PAPX)object4);
            }
            if (!bl) {
                n = object.size() - 1;
            }
            if (linkedList.size() == 0) {
                logger.log(5, "Paragraph [", n4, "; ", n5, ") has no PAPX. Creating new one.");
                cloneable2 = new PAPX(n4, n5, new SprmBuffer(2));
                cloneable.add(cloneable2);
                n3 = n5;
                continue;
            }
            if (linkedList.size() == 1 && (cloneable2 = (PAPX)linkedList.get(0)).getStart() == n4 && cloneable2.getEnd() == n5) {
                cloneable.add(cloneable2);
                n3 = n5;
                continue;
            }
            Collections.sort(linkedList, comparator);
            cloneable2 = null;
            for (PAPX pAPX : linkedList) {
                if (pAPX.getGrpprl() == null || pAPX.getGrpprl().length == 0) continue;
                if (cloneable2 == null) {
                    try {
                        cloneable2 = (SprmBuffer)pAPX.getSprmBuf().clone();
                        continue;
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        throw new Error(cloneNotSupportedException);
                    }
                }
                ((SprmBuffer)cloneable2).append(pAPX.getGrpprl(), 2);
            }
            object4 = new PAPX(n4, n5, (SprmBuffer)cloneable2);
            cloneable.add(object4);
            n3 = n5;
        }
        list.clear();
        list.addAll((Collection<PAPX>)((Object)cloneable));
        logger.log(1, "PAPX rebuilded from document text in ", System.currentTimeMillis() - l, " ms (", list.size(), " elements)");
        l = System.currentTimeMillis();
    }

    public void insert(int n, int n2, SprmBuffer sprmBuffer) {
        PAPX pAPX = new PAPX(0, 0, sprmBuffer);
        pAPX.setStart(n2);
        pAPX.setEnd(n2);
        if (n == this._paragraphs.size()) {
            this._paragraphs.add(pAPX);
        } else {
            PAPX pAPX2 = this._paragraphs.get(n);
            if (pAPX2 != null && pAPX2.getStart() < n2) {
                SprmBuffer sprmBuffer2 = null;
                try {
                    sprmBuffer2 = (SprmBuffer)pAPX2.getSprmBuf().clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    cloneNotSupportedException.printStackTrace();
                }
                PAPX pAPX3 = new PAPX(0, 0, sprmBuffer2);
                pAPX3.setStart(n2);
                pAPX3.setEnd(pAPX2.getEnd());
                pAPX2.setEnd(n2);
                this._paragraphs.add(n + 1, pAPX);
                this._paragraphs.add(n + 2, pAPX3);
            } else {
                this._paragraphs.add(n, pAPX);
            }
        }
    }

    public void adjustForDelete(int n, int n2, int n3) {
        int n4;
        int n5 = this._paragraphs.size();
        int n6 = n2 + n3;
        int n7 = n;
        PAPX pAPX = this._paragraphs.get(n7);
        while (pAPX.getEnd() < n6) {
            pAPX = this._paragraphs.get(++n7);
        }
        if (n == n7) {
            pAPX = this._paragraphs.get(n7);
            pAPX.setEnd(pAPX.getEnd() - n6 + n2);
        } else {
            pAPX = this._paragraphs.get(n);
            pAPX.setEnd(n2);
            for (n4 = n + 1; n4 < n7; ++n4) {
                pAPX = this._paragraphs.get(n4);
                pAPX.setStart(n2);
                pAPX.setEnd(n2);
            }
            pAPX = this._paragraphs.get(n7);
            pAPX.setEnd(pAPX.getEnd() - n6 + n2);
        }
        for (n4 = n7 + 1; n4 < n5; ++n4) {
            pAPX = this._paragraphs.get(n4);
            pAPX.setStart(pAPX.getStart() - n3);
            pAPX.setEnd(pAPX.getEnd() - n3);
        }
    }

    public void adjustForInsert(int n, int n2) {
        int n3 = this._paragraphs.size();
        PAPX pAPX = this._paragraphs.get(n);
        pAPX.setEnd(pAPX.getEnd() + n2);
        for (int i = n + 1; i < n3; ++i) {
            pAPX = this._paragraphs.get(i);
            pAPX.setStart(pAPX.getStart() + n2);
            pAPX.setEnd(pAPX.getEnd() + n2);
        }
    }

    public ArrayList<PAPX> getParagraphs() {
        return this._paragraphs;
    }

    @Deprecated
    public void writeTo(HWPFFileSystem hWPFFileSystem, CharIndexTranslator charIndexTranslator) throws IOException {
        HWPFOutputStream hWPFOutputStream = hWPFFileSystem.getStream("WordDocument");
        HWPFOutputStream hWPFOutputStream2 = hWPFFileSystem.getStream("1Table");
        this.writeTo(hWPFOutputStream, hWPFOutputStream2, charIndexTranslator);
    }

    public void writeTo(HWPFOutputStream hWPFOutputStream, HWPFOutputStream hWPFOutputStream2, CharIndexTranslator charIndexTranslator) throws IOException {
        PlexOfCps plexOfCps = new PlexOfCps(4);
        int n = hWPFOutputStream.getOffset();
        int n2 = n % 512;
        if (n2 != 0) {
            byte[] byArray = new byte[512 - n2];
            hWPFOutputStream.write(byArray);
        }
        n = hWPFOutputStream.getOffset();
        int n3 = n / 512;
        int n4 = charIndexTranslator.getByteIndex(this._paragraphs.get(this._paragraphs.size() - 1).getEnd());
        ArrayList<PAPX> arrayList = this._paragraphs;
        do {
            PAPX pAPX = arrayList.get(0);
            int n5 = charIndexTranslator.getByteIndex(pAPX.getStart());
            PAPFormattedDiskPage pAPFormattedDiskPage = new PAPFormattedDiskPage();
            pAPFormattedDiskPage.fill(arrayList);
            byte[] byArray = pAPFormattedDiskPage.toByteArray(hWPFOutputStream2, charIndexTranslator);
            hWPFOutputStream.write(byArray);
            arrayList = pAPFormattedDiskPage.getOverflow();
            int n6 = n4;
            if (arrayList != null) {
                n6 = charIndexTranslator.getByteIndex(arrayList.get(0).getStart());
            }
            byte[] byArray2 = new byte[4];
            LittleEndian.putInt(byArray2, n3++);
            plexOfCps.addProperty(new GenericPropertyNode(n5, n6, byArray2));
        } while (arrayList != null);
        hWPFOutputStream2.write(plexOfCps.toByteArray());
    }
}

