/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model;

import ai2.org.apache.poi.hwpf.model.FileInformationBlock;
import ai2.org.apache.poi.hwpf.model.FootnoteReferenceDescriptor;
import ai2.org.apache.poi.hwpf.model.GenericPropertyNode;
import ai2.org.apache.poi.hwpf.model.NoteType;
import ai2.org.apache.poi.hwpf.model.PlexOfCps;
import ai2.org.apache.poi.hwpf.model.io.HWPFOutputStream;
import ai2.org.apache.poi.util.Internal;
import java.io.IOException;

@Internal
public class NotesTables {
    private PlexOfCps descriptors = new PlexOfCps(FootnoteReferenceDescriptor.getSize());
    private final NoteType noteType;
    private PlexOfCps textPositions = new PlexOfCps(0);

    public NotesTables(NoteType noteType) {
        this.noteType = noteType;
        this.textPositions.addProperty(new GenericPropertyNode(0, 1, new byte[0]));
    }

    public NotesTables(NoteType noteType, byte[] byArray, FileInformationBlock fileInformationBlock) {
        this.noteType = noteType;
        this.read(byArray, fileInformationBlock);
    }

    public GenericPropertyNode getDescriptor(int n) {
        return this.descriptors.getProperty(n);
    }

    public int getDescriptorsCount() {
        return this.descriptors.length();
    }

    public GenericPropertyNode getTextPosition(int n) {
        return this.textPositions.getProperty(n);
    }

    private void read(byte[] byArray, FileInformationBlock fileInformationBlock) {
        int n = fileInformationBlock.getNotesDescriptorsOffset(this.noteType);
        int n2 = fileInformationBlock.getNotesDescriptorsSize(this.noteType);
        if (n != 0 && n2 != 0) {
            this.descriptors = new PlexOfCps(byArray, n, n2, FootnoteReferenceDescriptor.getSize());
        }
        int n3 = fileInformationBlock.getNotesTextPositionsOffset(this.noteType);
        int n4 = fileInformationBlock.getNotesTextPositionsSize(this.noteType);
        if (n3 != 0 && n4 != 0) {
            this.textPositions = new PlexOfCps(byArray, n3, n4, 0);
        }
    }

    public void writeRef(FileInformationBlock fileInformationBlock, HWPFOutputStream hWPFOutputStream) throws IOException {
        if (this.descriptors == null || this.descriptors.length() == 0) {
            fileInformationBlock.setNotesDescriptorsOffset(this.noteType, hWPFOutputStream.getOffset());
            fileInformationBlock.setNotesDescriptorsSize(this.noteType, 0);
            return;
        }
        int n = hWPFOutputStream.getOffset();
        hWPFOutputStream.write(this.descriptors.toByteArray());
        int n2 = hWPFOutputStream.getOffset();
        fileInformationBlock.setNotesDescriptorsOffset(this.noteType, n);
        fileInformationBlock.setNotesDescriptorsSize(this.noteType, n2 - n);
    }

    public void writeTxt(FileInformationBlock fileInformationBlock, HWPFOutputStream hWPFOutputStream) throws IOException {
        if (this.textPositions == null || this.textPositions.length() == 0) {
            fileInformationBlock.setNotesTextPositionsOffset(this.noteType, hWPFOutputStream.getOffset());
            fileInformationBlock.setNotesTextPositionsSize(this.noteType, 0);
            return;
        }
        int n = hWPFOutputStream.getOffset();
        hWPFOutputStream.write(this.textPositions.toByteArray());
        int n2 = hWPFOutputStream.getOffset();
        fileInformationBlock.setNotesTextPositionsOffset(this.noteType, n);
        fileInformationBlock.setNotesTextPositionsSize(this.noteType, n2 - n);
    }
}

