/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model;

import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.util.Arrays;

public class NilPICFAndBinData {
    private static final POILogger log = POILogFactory.getLogger(NilPICFAndBinData.class);
    private byte[] _binData;

    public NilPICFAndBinData(byte[] byArray, int n) {
        this.fillFields(byArray, n);
    }

    public void fillFields(byte[] byArray, int n) {
        int n2 = LittleEndian.getInt(byArray, n);
        int n3 = LittleEndian.getUShort(byArray, n + 4);
        if (n3 != 68 && log.check(5)) {
            log.log(5, "NilPICFAndBinData at offset ", n, " cbHeader 0x" + Integer.toHexString(n3) + " != 0x44");
        }
        int n4 = n2 - n3;
        this._binData = Arrays.copyOfRange(byArray, n + n3, n + n3 + n4);
    }

    public byte[] getBinData() {
        return this._binData;
    }

    public byte[] serialize() {
        byte[] byArray = new byte[this._binData.length + 68];
        LittleEndian.putInt(byArray, 0, this._binData.length + 68);
        System.arraycopy(this._binData, 0, byArray, 68, this._binData.length);
        return byArray;
    }

    public int serialize(byte[] byArray, int n) {
        LittleEndian.putInt(byArray, n, this._binData.length + 68);
        System.arraycopy(this._binData, 0, byArray, n + 68, this._binData.length);
        return 68 + this._binData.length;
    }
}

