/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model;

import ai2.org.apache.poi.hwpf.model.LVLF;
import ai2.org.apache.poi.hwpf.model.Xst;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.util.Arrays;

@Internal
public final class ListLevel {
    private static final POILogger logger = POILogFactory.getLogger(ListLevel.class);
    private byte[] _grpprlChpx;
    private byte[] _grpprlPapx;
    private LVLF _lvlf;
    private Xst _xst = new Xst();

    ListLevel() {
    }

    @Deprecated
    public ListLevel(byte[] byArray, int n) {
        this.read(byArray, n);
    }

    public ListLevel(int n, boolean bl) {
        this._lvlf = new LVLF();
        this.setStartAt(1);
        this._grpprlPapx = new byte[0];
        this._grpprlChpx = new byte[0];
        if (bl) {
            this._lvlf.getRgbxchNums()[0] = 1;
            this._xst = new Xst("" + (char)n + ".");
        } else {
            this._xst = new Xst("\u2022");
        }
    }

    public ListLevel(int n, int n2, int n3, byte[] byArray, byte[] byArray2, String string) {
        this._lvlf = new LVLF();
        this.setStartAt(n);
        this._lvlf.setNfc((byte)n2);
        this._lvlf.setJc((byte)n3);
        this._grpprlChpx = byArray;
        this._grpprlPapx = byArray2;
        this._xst = new Xst(string);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ListLevel)) {
            return false;
        }
        ListLevel listLevel = (ListLevel)object;
        return listLevel._lvlf.equals(this._lvlf) && Arrays.equals(listLevel._grpprlChpx, this._grpprlChpx) && Arrays.equals(listLevel._grpprlPapx, this._grpprlPapx) && listLevel._xst.equals(this._xst);
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    public int getAlignment() {
        return this._lvlf.getJc();
    }

    public byte[] getGrpprlChpx() {
        return this._grpprlChpx;
    }

    public byte[] getGrpprlPapx() {
        return this._grpprlPapx;
    }

    public byte[] getLevelProperties() {
        return this._grpprlPapx;
    }

    public int getNumberFormat() {
        return this._lvlf.getNfc();
    }

    public String getNumberText() {
        return this._xst.getAsJavaString();
    }

    public int getSizeInBytes() {
        return LVLF.getSize() + this._lvlf.getCbGrpprlChpx() + this._lvlf.getCbGrpprlPapx() + this._xst.getSize();
    }

    public int getStartAt() {
        return this._lvlf.getIStartAt();
    }

    public byte getTypeOfCharFollowingTheNumber() {
        return this._lvlf.getIxchFollow();
    }

    public short getRestart() {
        return this._lvlf.isFNoRestart() ? this._lvlf.getIlvlRestartLim() : (short)-1;
    }

    public boolean isLegalNumbering() {
        return this._lvlf.isFLegal();
    }

    public byte[] getLevelNumberingPlaceholderOffsets() {
        return this._lvlf.getRgbxchNums();
    }

    int read(byte[] byArray, int n) {
        int n2 = n;
        this._lvlf = new LVLF(byArray, n2);
        this._grpprlPapx = new byte[this._lvlf.getCbGrpprlPapx()];
        System.arraycopy(byArray, n2 += LVLF.getSize(), this._grpprlPapx, 0, this._lvlf.getCbGrpprlPapx());
        this._grpprlChpx = new byte[this._lvlf.getCbGrpprlChpx()];
        System.arraycopy(byArray, n2 += this._lvlf.getCbGrpprlPapx(), this._grpprlChpx, 0, this._lvlf.getCbGrpprlChpx());
        this._xst = new Xst(byArray, n2 += this._lvlf.getCbGrpprlChpx());
        n2 += this._xst.getSize();
        if (this._lvlf.getNfc() == 23 && this._xst.getCch() != 1) {
            logger.log(5, "LVL at offset ", n, " has nfc == 0x17 (bullets), but cch != 1 (", this._xst.getCch(), ")");
        }
        return n2 - n;
    }

    public void setAlignment(int n) {
        this._lvlf.setJc((byte)n);
    }

    public void setLevelProperties(byte[] byArray) {
        this._grpprlPapx = byArray;
    }

    public void setNumberFormat(int n) {
        this._lvlf.setNfc((byte)n);
    }

    public void setNumberProperties(byte[] byArray) {
        this._grpprlChpx = byArray;
    }

    public void setStartAt(int n) {
        this._lvlf.setIStartAt(n);
    }

    public void setTypeOfCharFollowingTheNumber(byte by) {
        this._lvlf.setIxchFollow(by);
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.getSizeInBytes()];
        int n = 0;
        this._lvlf.setCbGrpprlChpx((short)this._grpprlChpx.length);
        this._lvlf.setCbGrpprlPapx((short)this._grpprlPapx.length);
        this._lvlf.serialize(byArray, n);
        System.arraycopy(this._grpprlPapx, 0, byArray, n += LVLF.getSize(), this._grpprlPapx.length);
        System.arraycopy(this._grpprlChpx, 0, byArray, n += this._grpprlPapx.length, this._grpprlChpx.length);
        this._xst.serialize(byArray, n += this._grpprlChpx.length);
        n += this._xst.getSize();
        return byArray;
    }

    public String toString() {
        return "LVL: " + ("\n" + this._lvlf).replaceAll("\n", "\n    ") + "\n" + "PAPX's grpprl: " + Arrays.toString(this._grpprlPapx) + "\n" + "CHPX's grpprl: " + Arrays.toString(this._grpprlChpx) + "\n" + "xst: " + this._xst + "\n";
    }
}

