/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model;

import ai2.org.apache.poi.hwpf.model.Ffn;
import ai2.org.apache.poi.hwpf.model.io.HWPFFileSystem;
import ai2.org.apache.poi.hwpf.model.io.HWPFOutputStream;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.io.IOException;

@Internal
public final class FontTable {
    private static final POILogger _logger = POILogFactory.getLogger(FontTable.class);
    private short _stringCount;
    private short _extraDataSz;
    private int lcbSttbfffn;
    private int fcSttbfffn;
    private Ffn[] _fontNames = null;

    public FontTable(byte[] byArray, int n, int n2) {
        this.lcbSttbfffn = n2;
        this.fcSttbfffn = n;
        this._stringCount = LittleEndian.getShort(byArray, n);
        this._extraDataSz = LittleEndian.getShort(byArray, n += 2);
        n += 2;
        this._fontNames = new Ffn[this._stringCount];
        for (int i = 0; i < this._stringCount; ++i) {
            this._fontNames[i] = new Ffn(byArray, n);
            n += this._fontNames[i].getSize();
        }
    }

    public short getStringCount() {
        return this._stringCount;
    }

    public short getExtraDataSz() {
        return this._extraDataSz;
    }

    public Ffn[] getFontNames() {
        return this._fontNames;
    }

    public int getSize() {
        return this.lcbSttbfffn;
    }

    public String getMainFont(int n) {
        if (n >= this._stringCount) {
            _logger.log(3, new Object[]{"Mismatch in chpFtc with stringCount"});
            return null;
        }
        return this._fontNames[n].getMainFontName();
    }

    public String getAltFont(int n) {
        if (n >= this._stringCount) {
            _logger.log(3, new Object[]{"Mismatch in chpFtc with stringCount"});
            return null;
        }
        return this._fontNames[n].getAltFontName();
    }

    public void setStringCount(short s) {
        this._stringCount = s;
    }

    @Deprecated
    public void writeTo(HWPFFileSystem hWPFFileSystem) throws IOException {
        HWPFOutputStream hWPFOutputStream = hWPFFileSystem.getStream("1Table");
        this.writeTo(hWPFOutputStream);
    }

    public void writeTo(HWPFOutputStream hWPFOutputStream) throws IOException {
        byte[] byArray = new byte[2];
        LittleEndian.putShort(byArray, this._stringCount);
        hWPFOutputStream.write(byArray);
        LittleEndian.putShort(byArray, this._extraDataSz);
        hWPFOutputStream.write(byArray);
        for (int i = 0; i < this._fontNames.length; ++i) {
            hWPFOutputStream.write(this._fontNames[i].toByteArray());
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof FontTable)) {
            return false;
        }
        FontTable fontTable = (FontTable)object;
        if (fontTable._stringCount != this._stringCount || fontTable._extraDataSz != this._extraDataSz || fontTable._fontNames.length != this._fontNames.length) {
            return false;
        }
        for (int i = 0; i < fontTable._fontNames.length; ++i) {
            if (fontTable._fontNames[i].equals(this._fontNames[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }
}

