/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model;

import ai2.org.apache.poi.hwpf.model.FieldsDocumentPart;
import ai2.org.apache.poi.hwpf.model.FileInformationBlock;
import ai2.org.apache.poi.hwpf.model.GenericPropertyNode;
import ai2.org.apache.poi.hwpf.model.PlexOfCps;
import ai2.org.apache.poi.hwpf.model.PlexOfField;
import ai2.org.apache.poi.hwpf.model.io.HWPFOutputStream;
import ai2.org.apache.poi.util.Internal;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Internal
public class FieldsTables {
    private static final int FLD_SIZE = 2;
    @Deprecated
    public static final int PLCFFLDATN = 0;
    @Deprecated
    public static final int PLCFFLDEDN = 1;
    @Deprecated
    public static final int PLCFFLDFTN = 2;
    @Deprecated
    public static final int PLCFFLDHDR = 3;
    @Deprecated
    public static final int PLCFFLDHDRTXBX = 4;
    @Deprecated
    public static final int PLCFFLDMOM = 5;
    @Deprecated
    public static final int PLCFFLDTXBX = 6;
    private Map<FieldsDocumentPart, PlexOfCps> _tables = new HashMap<FieldsDocumentPart, PlexOfCps>(FieldsDocumentPart.values().length);

    private static ArrayList<PlexOfField> toArrayList(PlexOfCps plexOfCps) {
        if (plexOfCps == null) {
            return new ArrayList<PlexOfField>();
        }
        ArrayList<PlexOfField> arrayList = new ArrayList<PlexOfField>(plexOfCps.length());
        for (int i = 0; i < plexOfCps.length(); ++i) {
            GenericPropertyNode genericPropertyNode = plexOfCps.getProperty(i);
            PlexOfField plexOfField = new PlexOfField(genericPropertyNode);
            arrayList.add(plexOfField);
        }
        return arrayList;
    }

    public FieldsTables(byte[] byArray, FileInformationBlock fileInformationBlock) {
        for (FieldsDocumentPart fieldsDocumentPart : FieldsDocumentPart.values()) {
            PlexOfCps plexOfCps = this.readPLCF(byArray, fileInformationBlock, fieldsDocumentPart);
            this._tables.put(fieldsDocumentPart, plexOfCps);
        }
    }

    public ArrayList<PlexOfField> getFieldsPLCF(FieldsDocumentPart fieldsDocumentPart) {
        return FieldsTables.toArrayList(this._tables.get((Object)fieldsDocumentPart));
    }

    @Deprecated
    public ArrayList<PlexOfField> getFieldsPLCF(int n) {
        return this.getFieldsPLCF(FieldsDocumentPart.values()[n]);
    }

    private PlexOfCps readPLCF(byte[] byArray, FileInformationBlock fileInformationBlock, FieldsDocumentPart fieldsDocumentPart) {
        int n = fileInformationBlock.getFieldsPlcfOffset(fieldsDocumentPart);
        int n2 = fileInformationBlock.getFieldsPlcfLength(fieldsDocumentPart);
        if (n <= 0 || n2 <= 0) {
            return null;
        }
        return new PlexOfCps(byArray, n, n2, 2);
    }

    private int savePlex(FileInformationBlock fileInformationBlock, FieldsDocumentPart fieldsDocumentPart, PlexOfCps plexOfCps, HWPFOutputStream hWPFOutputStream) throws IOException {
        if (plexOfCps == null || plexOfCps.length() == 0) {
            fileInformationBlock.setFieldsPlcfOffset(fieldsDocumentPart, hWPFOutputStream.getOffset());
            fileInformationBlock.setFieldsPlcfLength(fieldsDocumentPart, 0);
            return 0;
        }
        byte[] byArray = plexOfCps.toByteArray();
        int n = hWPFOutputStream.getOffset();
        int n2 = byArray.length;
        hWPFOutputStream.write(byArray);
        fileInformationBlock.setFieldsPlcfOffset(fieldsDocumentPart, n);
        fileInformationBlock.setFieldsPlcfLength(fieldsDocumentPart, n2);
        return n2;
    }

    public void write(FileInformationBlock fileInformationBlock, HWPFOutputStream hWPFOutputStream) throws IOException {
        for (FieldsDocumentPart fieldsDocumentPart : FieldsDocumentPart.values()) {
            PlexOfCps plexOfCps = this._tables.get((Object)fieldsDocumentPart);
            this.savePlex(fileInformationBlock, fieldsDocumentPart, plexOfCps, hWPFOutputStream);
        }
    }
}

