/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model;

import ai2.org.apache.poi.util.BitField;
import ai2.org.apache.poi.util.BitFieldFactory;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;
import java.util.Arrays;

@Internal
public final class Ffn {
    private int _cbFfnM1;
    private byte _info;
    private static BitField _prq = BitFieldFactory.getInstance(3);
    private static BitField _fTrueType = BitFieldFactory.getInstance(4);
    private static BitField _ff = BitFieldFactory.getInstance(112);
    private short _wWeight;
    private byte _chs;
    private byte _ixchSzAlt;
    private byte[] _panose = new byte[10];
    private byte[] _fontSig = new byte[24];
    private char[] _xszFfn;
    private int _xszFfnLength;

    public Ffn(byte[] byArray, int n) {
        int n2 = n;
        this._cbFfnM1 = LittleEndian.getUnsignedByte(byArray, n);
        this._info = byArray[++n];
        this._wWeight = LittleEndian.getShort(byArray, ++n);
        this._chs = byArray[n += 2];
        this._ixchSzAlt = byArray[++n];
        System.arraycopy(byArray, ++n, this._panose, 0, this._panose.length);
        System.arraycopy(byArray, n += this._panose.length, this._fontSig, 0, this._fontSig.length);
        n2 = (n += this._fontSig.length) - n2;
        this._xszFfnLength = (this.getSize() - n2) / 2;
        this._xszFfn = new char[this._xszFfnLength];
        for (int i = 0; i < this._xszFfnLength; ++i) {
            this._xszFfn[i] = (char)LittleEndian.getShort(byArray, n);
            n += 2;
        }
    }

    public int get_cbFfnM1() {
        return this._cbFfnM1;
    }

    public short getWeight() {
        return this._wWeight;
    }

    public byte getChs() {
        return this._chs;
    }

    public byte[] getPanose() {
        return this._panose;
    }

    public byte[] getFontSig() {
        return this._fontSig;
    }

    public int getSize() {
        return this._cbFfnM1 + 1;
    }

    public String getMainFontName() {
        int n;
        for (n = 0; n < this._xszFfnLength && this._xszFfn[n] != '\u0000'; ++n) {
        }
        return new String(this._xszFfn, 0, n);
    }

    public String getAltFontName() {
        int n;
        for (n = this._ixchSzAlt; n < this._xszFfnLength && this._xszFfn[n] != '\u0000'; ++n) {
        }
        return new String(this._xszFfn, (int)this._ixchSzAlt, n);
    }

    public void set_cbFfnM1(int n) {
        this._cbFfnM1 = n;
    }

    public byte[] toByteArray() {
        int n = 0;
        byte[] byArray = new byte[this.getSize()];
        byArray[n] = (byte)this._cbFfnM1;
        byArray[++n] = this._info;
        LittleEndian.putShort(byArray, ++n, this._wWeight);
        byArray[n += 2] = this._chs;
        byArray[++n] = this._ixchSzAlt;
        System.arraycopy(this._panose, 0, byArray, ++n, this._panose.length);
        System.arraycopy(this._fontSig, 0, byArray, n += this._panose.length, this._fontSig.length);
        n += this._fontSig.length;
        for (int i = 0; i < this._xszFfn.length; ++i) {
            LittleEndian.putShort(byArray, n, (short)this._xszFfn[i]);
            n += 2;
        }
        return byArray;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Ffn)) {
            return false;
        }
        Ffn ffn = (Ffn)object;
        return ffn._cbFfnM1 == this._cbFfnM1 && ffn._info == this._info && ffn._wWeight == this._wWeight && ffn._chs == this._chs && ffn._ixchSzAlt == this._ixchSzAlt && Arrays.equals(ffn._panose, this._panose) && Arrays.equals(ffn._fontSig, this._fontSig) && Arrays.equals(ffn._xszFfn, this._xszFfn);
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }
}

