/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model;

import ai2.org.apache.poi.hwpf.model.UnhandledDataStructure;
import ai2.org.apache.poi.hwpf.model.io.HWPFOutputStream;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Internal
public final class FIBFieldHandler {
    public static final int STSHFORIG = 0;
    public static final int STSHF = 1;
    public static final int PLCFFNDREF = 2;
    public static final int PLCFFNDTXT = 3;
    public static final int PLCFANDREF = 4;
    public static final int PLCFANDTXT = 5;
    public static final int PLCFSED = 6;
    public static final int PLCFPAD = 7;
    public static final int PLCFPHE = 8;
    public static final int STTBGLSY = 9;
    public static final int PLCFGLSY = 10;
    public static final int PLCFHDD = 11;
    public static final int PLCFBTECHPX = 12;
    public static final int PLCFBTEPAPX = 13;
    public static final int PLCFSEA = 14;
    public static final int STTBFFFN = 15;
    public static final int PLCFFLDMOM = 16;
    public static final int PLCFFLDHDR = 17;
    public static final int PLCFFLDFTN = 18;
    public static final int PLCFFLDATN = 19;
    public static final int PLCFFLDMCR = 20;
    public static final int STTBFBKMK = 21;
    public static final int PLCFBKF = 22;
    public static final int PLCFBKL = 23;
    public static final int CMDS = 24;
    public static final int PLCMCR = 25;
    public static final int STTBFMCR = 26;
    public static final int PRDRVR = 27;
    public static final int PRENVPORT = 28;
    public static final int PRENVLAND = 29;
    public static final int WSS = 30;
    public static final int DOP = 31;
    public static final int STTBFASSOC = 32;
    public static final int CLX = 33;
    public static final int PLCFPGDFTN = 34;
    public static final int AUTOSAVESOURCE = 35;
    public static final int GRPXSTATNOWNERS = 36;
    public static final int STTBFATNBKMK = 37;
    public static final int PLCFDOAMOM = 38;
    public static final int PLCDOAHDR = 39;
    public static final int PLCSPAMOM = 40;
    public static final int PLCSPAHDR = 41;
    public static final int PLCFATNBKF = 42;
    public static final int PLCFATNBKL = 43;
    public static final int PMS = 44;
    public static final int FORMFLDSTTBS = 45;
    public static final int PLCFENDREF = 46;
    public static final int PLCFENDTXT = 47;
    public static final int PLCFFLDEDN = 48;
    public static final int PLCFPGDEDN = 49;
    public static final int DGGINFO = 50;
    public static final int STTBFRMARK = 51;
    public static final int STTBCAPTION = 52;
    public static final int STTBAUTOCAPTION = 53;
    public static final int PLCFWKB = 54;
    public static final int PLCFSPL = 55;
    public static final int PLCFTXBXTXT = 56;
    public static final int PLCFFLDTXBX = 57;
    public static final int PLCFHDRTXBXTXT = 58;
    public static final int PLCFFLDHDRTXBX = 59;
    public static final int STWUSER = 60;
    public static final int STTBTTMBD = 61;
    public static final int UNUSED = 62;
    public static final int PGDMOTHER = 63;
    public static final int BKDMOTHER = 64;
    public static final int PGDFTN = 65;
    public static final int BKDFTN = 66;
    public static final int PGDEDN = 67;
    public static final int BKDEDN = 68;
    public static final int STTBFINTFLD = 69;
    public static final int ROUTESLIP = 70;
    public static final int STTBSAVEDBY = 71;
    public static final int STTBFNM = 72;
    public static final int PLFLST = 73;
    @Deprecated
    public static final int PLCFLST = 73;
    public static final int PLFLFO = 74;
    public static final int PLCFTXBXBKD = 75;
    public static final int PLCFTXBXHDRBKD = 76;
    public static final int DOCUNDO = 77;
    public static final int RGBUSE = 78;
    public static final int USP = 79;
    public static final int USKF = 80;
    public static final int PLCUPCRGBUSE = 81;
    public static final int PLCUPCUSP = 82;
    public static final int STTBGLSYSTYLE = 83;
    public static final int PLGOSL = 84;
    public static final int PLCOCX = 85;
    public static final int PLCFBTELVC = 86;
    public static final int MODIFIED = 87;
    public static final int PLCFLVC = 88;
    public static final int PLCASUMY = 89;
    public static final int PLCFGRAM = 90;
    public static final int STTBLISTNAMES = 91;
    public static final int STTBFUSSR = 92;
    private static POILogger log = POILogFactory.getLogger(FIBFieldHandler.class);
    private static final int FIELD_SIZE = 8;
    private Map<Integer, UnhandledDataStructure> _unknownMap = new HashMap<Integer, UnhandledDataStructure>();
    private int[] _fields;

    FIBFieldHandler(byte[] byArray, int n, int n2, byte[] byArray2, HashSet<Integer> hashSet, boolean bl) {
        this._fields = new int[n2 * 2];
        for (int i = 0; i < n2; ++i) {
            int n3 = i * 8 + n;
            int n4 = LittleEndian.getInt(byArray, n3);
            int n5 = LittleEndian.getInt(byArray, n3 += 4);
            if (hashSet.contains(i) ^ bl && n5 > 0) {
                if (n4 + n5 > byArray2.length) {
                    if (log.check(5)) {
                        log.log(5, new Object[]{"Unhandled data structure points to outside the buffer. offset = " + n4 + ", length = " + n5 + ", buffer length = " + byArray2.length});
                    }
                } else {
                    UnhandledDataStructure unhandledDataStructure = new UnhandledDataStructure(byArray2, n4, n5);
                    this._unknownMap.put(i, unhandledDataStructure);
                }
            }
            this._fields[i * 2] = n4;
            this._fields[i * 2 + 1] = n5;
        }
    }

    public void clearFields() {
        Arrays.fill(this._fields, 0);
    }

    public int getFieldOffset(int n) {
        return this._fields[n * 2];
    }

    public int getFieldSize(int n) {
        return this._fields[n * 2 + 1];
    }

    public void setFieldOffset(int n, int n2) {
        this._fields[n * 2] = n2;
    }

    public void setFieldSize(int n, int n2) {
        this._fields[n * 2 + 1] = n2;
    }

    public int sizeInBytes() {
        return this._fields.length * 4;
    }

    public int getFieldsCount() {
        return this._fields.length / 2;
    }

    void writeTo(byte[] byArray, int n, HWPFOutputStream hWPFOutputStream) throws IOException {
        for (int i = 0; i < this._fields.length / 2; ++i) {
            UnhandledDataStructure unhandledDataStructure = this._unknownMap.get(i);
            if (unhandledDataStructure != null) {
                this._fields[i * 2] = hWPFOutputStream.getOffset();
                LittleEndian.putInt(byArray, n, hWPFOutputStream.getOffset());
                byte[] byArray2 = unhandledDataStructure.getBuf();
                hWPFOutputStream.write(byArray2);
                this._fields[i * 2 + 1] = byArray2.length;
                LittleEndian.putInt(byArray, n += 4, byArray2.length);
                n += 4;
                continue;
            }
            LittleEndian.putInt(byArray, n, this._fields[i * 2]);
            LittleEndian.putInt(byArray, n += 4, this._fields[i * 2 + 1]);
            n += 4;
        }
    }

    private static String leftPad(String string, int n, char c) {
        if (string.length() >= n) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n - string.length(); ++i) {
            stringBuilder.append(c);
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[FIBFieldHandler]:\n");
        stringBuilder.append("\tFields:\n");
        stringBuilder.append("\t");
        stringBuilder.append(FIBFieldHandler.leftPad("Index", 8, ' '));
        stringBuilder.append(FIBFieldHandler.leftPad("FIB offset", 15, ' '));
        stringBuilder.append(FIBFieldHandler.leftPad("Offset", 8, ' '));
        stringBuilder.append(FIBFieldHandler.leftPad("Size", 8, ' '));
        stringBuilder.append('\n');
        for (int i = 0; i < this._fields.length / 2; ++i) {
            stringBuilder.append('\t');
            stringBuilder.append(FIBFieldHandler.leftPad(Integer.toString(i), 8, ' '));
            stringBuilder.append(FIBFieldHandler.leftPad(Integer.toString(154 + i * 4 * 2), 6, ' '));
            stringBuilder.append("   0x");
            stringBuilder.append(FIBFieldHandler.leftPad(Integer.toHexString(154 + i * 4 * 2), 4, '0'));
            stringBuilder.append(FIBFieldHandler.leftPad(Integer.toString(this.getFieldOffset(i)), 8, ' '));
            stringBuilder.append(FIBFieldHandler.leftPad(Integer.toString(this.getFieldSize(i)), 8, ' '));
            UnhandledDataStructure unhandledDataStructure = this._unknownMap.get(i);
            if (unhandledDataStructure != null) {
                stringBuilder.append(" => Unknown structure of size ");
                stringBuilder.append(unhandledDataStructure._buf.length);
            }
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }
}

