/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model;

import ai2.org.apache.poi.hwpf.model.FFDataBase;
import ai2.org.apache.poi.hwpf.model.Sttb;
import ai2.org.apache.poi.hwpf.model.Xstz;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;

@Internal
public class FFData {
    private FFDataBase _base;
    private Sttb _hsttbDropList;
    private Integer _wDef;
    private Xstz _xstzEntryMcr;
    private Xstz _xstzExitMcr;
    private Xstz _xstzHelpText;
    private Xstz _xstzName;
    private Xstz _xstzStatText;
    private Xstz _xstzTextDef;
    private Xstz _xstzTextFormat;

    public FFData(byte[] byArray, int n) {
        this.fillFields(byArray, n);
    }

    public void fillFields(byte[] byArray, int n) {
        int n2 = n;
        this._base = new FFDataBase(byArray, n2);
        this._xstzName = new Xstz(byArray, n2 += FFDataBase.getSize());
        n2 += this._xstzName.getSize();
        if (this._base.getIType() == 0) {
            this._xstzTextDef = new Xstz(byArray, n2);
            n2 += this._xstzTextDef.getSize();
        } else {
            this._xstzTextDef = null;
        }
        if (this._base.getIType() == 1 || this._base.getIType() == 2) {
            this._wDef = LittleEndian.getUShort(byArray, n2);
            n2 += 2;
        } else {
            this._wDef = null;
        }
        this._xstzTextFormat = new Xstz(byArray, n2);
        this._xstzHelpText = new Xstz(byArray, n2 += this._xstzTextFormat.getSize());
        this._xstzStatText = new Xstz(byArray, n2 += this._xstzHelpText.getSize());
        this._xstzEntryMcr = new Xstz(byArray, n2 += this._xstzStatText.getSize());
        this._xstzExitMcr = new Xstz(byArray, n2 += this._xstzEntryMcr.getSize());
        n2 += this._xstzExitMcr.getSize();
        if (this._base.getIType() == 2) {
            this._hsttbDropList = new Sttb(byArray, n2);
            n2 += this._hsttbDropList.getSize();
        }
    }

    public int getDefaultDropDownItemIndex() {
        return this._wDef;
    }

    public String[] getDropList() {
        return this._hsttbDropList.getData();
    }

    public int getSize() {
        int n = FFDataBase.getSize();
        n += this._xstzName.getSize();
        if (this._base.getIType() == 0) {
            n += this._xstzTextDef.getSize();
        }
        if (this._base.getIType() == 1 || this._base.getIType() == 2) {
            n += 2;
        }
        n += this._xstzTextFormat.getSize();
        n += this._xstzHelpText.getSize();
        n += this._xstzStatText.getSize();
        n += this._xstzEntryMcr.getSize();
        n += this._xstzExitMcr.getSize();
        if (this._base.getIType() == 2) {
            n += this._hsttbDropList.getSize();
        }
        return n;
    }

    public String getTextDef() {
        return this._xstzTextDef.getAsJavaString();
    }

    public byte[] serialize() {
        byte[] byArray = new byte[this.getSize()];
        int n = 0;
        this._base.serialize(byArray, n);
        n += FFDataBase.getSize();
        n += this._xstzName.serialize(byArray, n);
        if (this._base.getIType() == 0) {
            n += this._xstzTextDef.serialize(byArray, n);
        }
        if (this._base.getIType() == 1 || this._base.getIType() == 2) {
            LittleEndian.putUShort(byArray, n, this._wDef);
            n += 2;
        }
        n += this._xstzTextFormat.serialize(byArray, n);
        n += this._xstzHelpText.serialize(byArray, n);
        n += this._xstzStatText.serialize(byArray, n);
        n += this._xstzEntryMcr.serialize(byArray, n);
        n += this._xstzExitMcr.serialize(byArray, n);
        if (this._base.getIType() == 2) {
            n += this._hsttbDropList.serialize(byArray, n);
        }
        return byArray;
    }
}

