/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model;

import ai2.org.apache.poi.ddf.DefaultEscherRecordFactory;
import ai2.org.apache.poi.ddf.EscherContainerRecord;
import ai2.org.apache.poi.ddf.EscherRecord;
import ai2.org.apache.poi.util.Internal;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Internal
public final class EscherRecordHolder {
    private final ArrayList<EscherRecord> escherRecords = new ArrayList();

    public EscherRecordHolder() {
    }

    public EscherRecordHolder(byte[] byArray, int n, int n2) {
        this();
        this.fillEscherRecords(byArray, n, n2);
    }

    private void fillEscherRecords(byte[] byArray, int n, int n2) {
        int n3;
        DefaultEscherRecordFactory defaultEscherRecordFactory = new DefaultEscherRecordFactory();
        for (int i = n; i < n + n2; i += n3 + 1) {
            EscherRecord escherRecord = defaultEscherRecordFactory.createRecord(byArray, i);
            this.escherRecords.add(escherRecord);
            n3 = escherRecord.fillFields(byArray, i, defaultEscherRecordFactory);
        }
    }

    public List<EscherRecord> getEscherRecords() {
        return this.escherRecords;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.escherRecords.size() == 0) {
            stringBuffer.append("No Escher Records Decoded").append("\n");
        }
        for (EscherRecord escherRecord : this.escherRecords) {
            stringBuffer.append(escherRecord.toString());
        }
        return stringBuffer.toString();
    }

    public EscherContainerRecord getEscherContainer() {
        for (EscherRecord escherRecord : this.escherRecords) {
            if (!(escherRecord instanceof EscherContainerRecord)) continue;
            return (EscherContainerRecord)escherRecord;
        }
        return null;
    }

    public EscherRecord findFirstWithId(short s) {
        return EscherRecordHolder.findFirstWithId(s, this.getEscherRecords());
    }

    private static EscherRecord findFirstWithId(short s, List<EscherRecord> list) {
        for (EscherRecord escherRecord : list) {
            if (escherRecord.getRecordId() != s) continue;
            return escherRecord;
        }
        for (EscherRecord escherRecord : list) {
            EscherRecord escherRecord2;
            if (!escherRecord.isContainerRecord() || (escherRecord2 = EscherRecordHolder.findFirstWithId(s, escherRecord.getChildRecords())) == null) continue;
            return escherRecord2;
        }
        return null;
    }

    public List<? extends EscherContainerRecord> getDgContainers() {
        ArrayList<EscherContainerRecord> arrayList = new ArrayList<EscherContainerRecord>(1);
        for (EscherRecord escherRecord : this.getEscherRecords()) {
            if (escherRecord.getRecordId() != -4094) continue;
            arrayList.add((EscherContainerRecord)escherRecord);
        }
        return arrayList;
    }

    public List<? extends EscherContainerRecord> getDggContainers() {
        ArrayList<EscherContainerRecord> arrayList = new ArrayList<EscherContainerRecord>(1);
        for (EscherRecord escherRecord : this.getEscherRecords()) {
            if (escherRecord.getRecordId() != -4096) continue;
            arrayList.add((EscherContainerRecord)escherRecord);
        }
        return arrayList;
    }

    public List<? extends EscherContainerRecord> getBStoreContainers() {
        ArrayList<EscherContainerRecord> arrayList = new ArrayList<EscherContainerRecord>(1);
        for (EscherContainerRecord escherContainerRecord : this.getDggContainers()) {
            for (EscherRecord escherRecord : escherContainerRecord.getChildRecords()) {
                if (escherRecord.getRecordId() != -4095) continue;
                arrayList.add((EscherContainerRecord)escherRecord);
            }
        }
        return arrayList;
    }

    public List<? extends EscherContainerRecord> getSpgrContainers() {
        ArrayList<EscherContainerRecord> arrayList = new ArrayList<EscherContainerRecord>(1);
        for (EscherContainerRecord escherContainerRecord : this.getDgContainers()) {
            for (EscherRecord escherRecord : escherContainerRecord.getChildRecords()) {
                if (escherRecord.getRecordId() != -4093) continue;
                arrayList.add((EscherContainerRecord)escherRecord);
            }
        }
        return arrayList;
    }

    public List<? extends EscherContainerRecord> getSpContainers() {
        ArrayList<EscherContainerRecord> arrayList = new ArrayList<EscherContainerRecord>(1);
        for (EscherContainerRecord escherContainerRecord : this.getSpgrContainers()) {
            for (EscherRecord escherRecord : escherContainerRecord.getChildRecords()) {
                if (escherRecord.getRecordId() != -4092) continue;
                arrayList.add((EscherContainerRecord)escherRecord);
            }
        }
        return arrayList;
    }
}

