/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model;

import ai2.org.apache.poi.hwpf.model.TextPieceTable;
import ai2.org.apache.poi.hwpf.model.io.HWPFFileSystem;
import ai2.org.apache.poi.hwpf.model.io.HWPFOutputStream;
import ai2.org.apache.poi.hwpf.sprm.SprmBuffer;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.util.LinkedList;

@Internal
public final class ComplexFileTable {
    private static final byte GRPPRL_TYPE = 1;
    private static final byte TEXT_PIECE_TABLE_TYPE = 2;
    protected TextPieceTable _tpt;
    private SprmBuffer[] _grpprls;

    public ComplexFileTable() {
        this._tpt = new TextPieceTable();
    }

    public ComplexFileTable(byte[] byArray, byte[] byArray2, int n, int n2) throws IOException {
        int n3;
        LinkedList<SprmBuffer> linkedList = new LinkedList<SprmBuffer>();
        while (byArray2[n] == 1) {
            n3 = LittleEndian.getShort(byArray2, ++n);
            byte[] byArray3 = LittleEndian.getByteArray(byArray2, n += 2, n3);
            n += n3;
            SprmBuffer sprmBuffer = new SprmBuffer(byArray3, false, 0);
            linkedList.add(sprmBuffer);
        }
        this._grpprls = linkedList.toArray(new SprmBuffer[linkedList.size()]);
        if (byArray2[n] != 2) {
            throw new IOException("The text piece table is corrupted");
        }
        n3 = LittleEndian.getInt(byArray2, ++n);
        this._tpt = new TextPieceTable(byArray, byArray2, n += 4, n3, n2);
    }

    public TextPieceTable getTextPieceTable() {
        return this._tpt;
    }

    public SprmBuffer[] getGrpprls() {
        return this._grpprls;
    }

    @Deprecated
    public void writeTo(HWPFFileSystem hWPFFileSystem) throws IOException {
        HWPFOutputStream hWPFOutputStream = hWPFFileSystem.getStream("WordDocument");
        HWPFOutputStream hWPFOutputStream2 = hWPFFileSystem.getStream("1Table");
        this.writeTo(hWPFOutputStream, hWPFOutputStream2);
    }

    public void writeTo(HWPFOutputStream hWPFOutputStream, HWPFOutputStream hWPFOutputStream2) throws IOException {
        hWPFOutputStream2.write(2);
        byte[] byArray = this._tpt.writeTo(hWPFOutputStream);
        byte[] byArray2 = new byte[4];
        LittleEndian.putInt(byArray2, byArray.length);
        hWPFOutputStream2.write(byArray2);
        hWPFOutputStream2.write(byArray);
    }
}

