/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model;

import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;

@Internal
public class Colorref
implements Cloneable {
    private int value;

    public static Colorref valueOfIco(int n) {
        switch (n) {
            case 1: {
                return new Colorref(0);
            }
            case 2: {
                return new Colorref(0xFF0000);
            }
            case 3: {
                return new Colorref(0xFFFF00);
            }
            case 4: {
                return new Colorref(65280);
            }
            case 5: {
                return new Colorref(0xFF00FF);
            }
            case 6: {
                return new Colorref(255);
            }
            case 7: {
                return new Colorref(65535);
            }
            case 8: {
                return new Colorref(0xFFFFFF);
            }
            case 9: {
                return new Colorref(0x8B0000);
            }
            case 10: {
                return new Colorref(0x8B8B00);
            }
            case 11: {
                return new Colorref(25600);
            }
            case 12: {
                return new Colorref(0x8B008B);
            }
            case 13: {
                return new Colorref(139);
            }
            case 14: {
                return new Colorref(52479);
            }
            case 15: {
                return new Colorref(0xA9A9A9);
            }
            case 16: {
                return new Colorref(0xC0C0C0);
            }
        }
        return new Colorref(0);
    }

    public Colorref() {
        this.value = -1;
    }

    public Colorref(byte[] byArray, int n) {
        this.value = LittleEndian.getInt(byArray, n);
    }

    public Colorref(int n) {
        this.value = n;
    }

    public Colorref clone() throws CloneNotSupportedException {
        return new Colorref(this.value);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Colorref colorref = (Colorref)object;
        return this.value == colorref.value;
    }

    public int getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public boolean isEmpty() {
        return this.value == -1;
    }

    public void serialize(byte[] byArray, int n) {
        LittleEndian.putInt(byArray, n, this.value);
    }

    public void setValue(int n) {
        this.value = n;
    }

    public byte[] toByteArray() {
        if (this.isEmpty()) {
            throw new IllegalStateException("Structure state (EMPTY) is not good for serialization");
        }
        byte[] byArray = new byte[4];
        this.serialize(byArray, 0);
        return byArray;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[COLORREF] EMPTY";
        }
        return "[COLORREF] 0x" + Integer.toHexString(this.value);
    }
}

