/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model;

import ai2.org.apache.poi.hwpf.model.CHPX;
import ai2.org.apache.poi.hwpf.model.CharIndexTranslator;
import ai2.org.apache.poi.hwpf.model.FormattedDiskPage;
import ai2.org.apache.poi.hwpf.model.PropertyNode;
import ai2.org.apache.poi.hwpf.model.TextPieceTable;
import ai2.org.apache.poi.hwpf.sprm.SprmBuffer;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Internal
public final class CHPFormattedDiskPage
extends FormattedDiskPage {
    private static final int FC_SIZE = 4;
    private ArrayList<CHPX> _chpxList = new ArrayList();
    private ArrayList<CHPX> _overFlow;

    public CHPFormattedDiskPage() {
    }

    public CHPFormattedDiskPage(byte[] byArray, int n, int n2, TextPieceTable textPieceTable) {
        this(byArray, n, textPieceTable);
    }

    public CHPFormattedDiskPage(byte[] byArray, int n, CharIndexTranslator charIndexTranslator) {
        super(byArray, n);
        for (int i = 0; i < this._crun; ++i) {
            int n2 = this.getStart(i);
            int n3 = this.getEnd(i);
            for (int[] nArray : charIndexTranslator.getCharIndexRanges(n2, n3)) {
                CHPX cHPX = new CHPX(nArray[0], nArray[1], new SprmBuffer(this.getGrpprl(i), 0));
                this._chpxList.add(cHPX);
            }
        }
    }

    public CHPX getCHPX(int n) {
        return this._chpxList.get(n);
    }

    public List<CHPX> getCHPXs() {
        return Collections.unmodifiableList(this._chpxList);
    }

    public void fill(List<CHPX> list) {
        this._chpxList.addAll(list);
    }

    public ArrayList<CHPX> getOverflow() {
        return this._overFlow;
    }

    @Override
    protected byte[] getGrpprl(int n) {
        int n2 = 2 * LittleEndian.getUnsignedByte(this._fkp, this._offset + ((this._crun + 1) * 4 + n));
        if (n2 == 0) {
            return new byte[0];
        }
        int n3 = LittleEndian.getUnsignedByte(this._fkp, this._offset + n2);
        byte[] byArray = new byte[n3];
        System.arraycopy(this._fkp, this._offset + ++n2, byArray, 0, n3);
        return byArray;
    }

    @Deprecated
    protected byte[] toByteArray(CharIndexTranslator charIndexTranslator, int n) {
        return this.toByteArray(charIndexTranslator);
    }

    protected byte[] toByteArray(CharIndexTranslator charIndexTranslator) {
        int n;
        byte[] byArray = new byte[512];
        int n2 = this._chpxList.size();
        int n3 = 511;
        int n4 = 0;
        int n5 = 0;
        int n6 = 6;
        for (n = 0; n < n2; ++n) {
            int n7 = this._chpxList.get(n).getGrpprl().length;
            if ((n6 += 6 + n7) > 511 + n % 2) {
                n6 -= 6 + n7;
                break;
            }
            if ((1 + n7) % 2 <= 0) continue;
            ++n6;
        }
        if (n != n2) {
            this._overFlow = new ArrayList();
            this._overFlow.addAll(this._chpxList.subList(n, n2));
        }
        byArray[511] = (byte)n;
        n4 = 4 * n + 4;
        PropertyNode propertyNode = null;
        for (int i = 0; i < n; ++i) {
            propertyNode = this._chpxList.get(i);
            byte[] byArray2 = ((CHPX)propertyNode).getGrpprl();
            LittleEndian.putInt(byArray, n5, charIndexTranslator.getByteIndex(propertyNode.getStart()));
            n3 -= 1 + byArray2.length;
            n3 -= n3 % 2;
            byArray[n4] = (byte)(n3 / 2);
            byArray[n3] = (byte)byArray2.length;
            System.arraycopy(byArray2, 0, byArray, n3 + 1, byArray2.length);
            ++n4;
            n5 += 4;
        }
        LittleEndian.putInt(byArray, n5, charIndexTranslator.getByteIndex(propertyNode.getEnd()));
        return byArray;
    }
}

