/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.model;

import ai2.org.apache.poi.hwpf.model.BookmarkFirstDescriptor;
import ai2.org.apache.poi.hwpf.model.FileInformationBlock;
import ai2.org.apache.poi.hwpf.model.GenericPropertyNode;
import ai2.org.apache.poi.hwpf.model.PlexOfCps;
import ai2.org.apache.poi.hwpf.model.SttbUtils;
import ai2.org.apache.poi.hwpf.model.io.HWPFOutputStream;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Internal
public class BookmarksTables {
    private static final POILogger logger = POILogFactory.getLogger(BookmarksTables.class);
    private PlexOfCps descriptorsFirst = new PlexOfCps(4);
    private PlexOfCps descriptorsLim = new PlexOfCps(0);
    private List<String> names = new ArrayList<String>(0);

    public BookmarksTables(byte[] byArray, FileInformationBlock fileInformationBlock) {
        this.read(byArray, fileInformationBlock);
    }

    public void afterDelete(int n, int n2) {
        this.descriptorsFirst.adjust(n, -n2);
        this.descriptorsLim.adjust(n, -n2);
        for (int i = 0; i < this.descriptorsFirst.length(); ++i) {
            GenericPropertyNode genericPropertyNode = this.descriptorsFirst.getProperty(i);
            GenericPropertyNode genericPropertyNode2 = this.descriptorsLim.getProperty(i);
            if (genericPropertyNode.getStart() != genericPropertyNode2.getStart()) continue;
            logger.log(1, "Removing bookmark #", i, "...");
            this.remove(i);
            --i;
        }
    }

    public void afterInsert(int n, int n2) {
        this.descriptorsFirst.adjust(n, n2);
        this.descriptorsLim.adjust(n - 1, n2);
    }

    public int getBookmarksCount() {
        return this.descriptorsFirst.length();
    }

    public GenericPropertyNode getDescriptorFirst(int n) throws IndexOutOfBoundsException {
        return this.descriptorsFirst.getProperty(n);
    }

    public int getDescriptorFirstIndex(GenericPropertyNode genericPropertyNode) {
        return Arrays.asList(this.descriptorsFirst.toPropertiesArray()).indexOf(genericPropertyNode);
    }

    public GenericPropertyNode getDescriptorLim(int n) throws IndexOutOfBoundsException {
        return this.descriptorsLim.getProperty(n);
    }

    public int getDescriptorsFirstCount() {
        return this.descriptorsFirst.length();
    }

    public int getDescriptorsLimCount() {
        return this.descriptorsLim.length();
    }

    public String getName(int n) {
        return this.names.get(n);
    }

    public int getNamesCount() {
        return this.names.size();
    }

    private void read(byte[] byArray, FileInformationBlock fileInformationBlock) {
        int n = fileInformationBlock.getFcSttbfbkmk();
        int n2 = fileInformationBlock.getLcbSttbfbkmk();
        if (n != 0 && n2 != 0) {
            this.names = new ArrayList<String>(Arrays.asList(SttbUtils.readSttbfBkmk(byArray, n)));
        }
        int n3 = fileInformationBlock.getFcPlcfbkf();
        int n4 = fileInformationBlock.getLcbPlcfbkf();
        if (n3 != 0 && n4 != 0) {
            this.descriptorsFirst = new PlexOfCps(byArray, n3, n4, BookmarkFirstDescriptor.getSize());
        }
        int n5 = fileInformationBlock.getFcPlcfbkl();
        int n6 = fileInformationBlock.getLcbPlcfbkl();
        if (n5 != 0 && n6 != 0) {
            this.descriptorsLim = new PlexOfCps(byArray, n5, n6, 0);
        }
    }

    public void remove(int n) {
        this.descriptorsFirst.remove(n);
        this.descriptorsLim.remove(n);
        this.names.remove(n);
    }

    public void setName(int n, String string) {
        this.names.set(n, string);
    }

    public void writePlcfBkmkf(FileInformationBlock fileInformationBlock, HWPFOutputStream hWPFOutputStream) throws IOException {
        if (this.descriptorsFirst == null || this.descriptorsFirst.length() == 0) {
            fileInformationBlock.setFcPlcfbkf(0);
            fileInformationBlock.setLcbPlcfbkf(0);
            return;
        }
        int n = hWPFOutputStream.getOffset();
        hWPFOutputStream.write(this.descriptorsFirst.toByteArray());
        int n2 = hWPFOutputStream.getOffset();
        fileInformationBlock.setFcPlcfbkf(n);
        fileInformationBlock.setLcbPlcfbkf(n2 - n);
    }

    public void writePlcfBkmkl(FileInformationBlock fileInformationBlock, HWPFOutputStream hWPFOutputStream) throws IOException {
        if (this.descriptorsLim == null || this.descriptorsLim.length() == 0) {
            fileInformationBlock.setFcPlcfbkl(0);
            fileInformationBlock.setLcbPlcfbkl(0);
            return;
        }
        int n = hWPFOutputStream.getOffset();
        hWPFOutputStream.write(this.descriptorsLim.toByteArray());
        int n2 = hWPFOutputStream.getOffset();
        fileInformationBlock.setFcPlcfbkl(n);
        fileInformationBlock.setLcbPlcfbkl(n2 - n);
    }

    public void writeSttbfBkmk(FileInformationBlock fileInformationBlock, HWPFOutputStream hWPFOutputStream) throws IOException {
        if (this.names == null || this.names.isEmpty()) {
            fileInformationBlock.setFcSttbfbkmk(0);
            fileInformationBlock.setLcbSttbfbkmk(0);
            return;
        }
        int n = hWPFOutputStream.getOffset();
        SttbUtils.writeSttbfBkmk(this.names.toArray(new String[this.names.size()]), hWPFOutputStream);
        int n2 = hWPFOutputStream.getOffset();
        fileInformationBlock.setFcSttbfbkmk(n);
        fileInformationBlock.setLcbSttbfbkmk(n2 - n);
    }
}

