/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.extractor;

import ai2.org.apache.poi.POIOLE2TextExtractor;
import ai2.org.apache.poi.hwpf.HWPFDocument;
import ai2.org.apache.poi.hwpf.converter.WordToTextConverter;
import ai2.org.apache.poi.hwpf.usermodel.HeaderStories;
import ai2.org.apache.poi.hwpf.usermodel.Paragraph;
import ai2.org.apache.poi.hwpf.usermodel.Range;
import ai2.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai2.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class WordExtractor
extends POIOLE2TextExtractor {
    private HWPFDocument doc;

    public WordExtractor(InputStream inputStream) throws IOException {
        this(HWPFDocument.verifyAndBuildPOIFS(inputStream));
    }

    public WordExtractor(POIFSFileSystem pOIFSFileSystem) throws IOException {
        this(new HWPFDocument(pOIFSFileSystem));
    }

    @Deprecated
    public WordExtractor(DirectoryNode directoryNode, POIFSFileSystem pOIFSFileSystem) throws IOException {
        this(directoryNode);
    }

    public WordExtractor(DirectoryNode directoryNode) throws IOException {
        this(new HWPFDocument(directoryNode));
    }

    public WordExtractor(HWPFDocument hWPFDocument) {
        super(hWPFDocument);
        this.doc = hWPFDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length == 0) {
            System.err.println("Use:");
            System.err.println("   java ai2.org.apache.poi.hwpf.extractor.WordExtractor <filename>");
            System.exit(1);
        }
        FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
        WordExtractor wordExtractor = new WordExtractor(fileInputStream);
        try {
            System.out.println(wordExtractor.getText());
        }
        finally {
            wordExtractor.close();
        }
    }

    public String[] getParagraphText() {
        String[] stringArray;
        try {
            Range range = this.doc.getRange();
            stringArray = WordExtractor.getParagraphText(range);
        }
        catch (Exception exception) {
            stringArray = new String[]{this.getTextFromPieces()};
        }
        return stringArray;
    }

    public String[] getFootnoteText() {
        Range range = this.doc.getFootnoteRange();
        return WordExtractor.getParagraphText(range);
    }

    public String[] getMainTextboxText() {
        Range range = this.doc.getMainTextboxRange();
        return WordExtractor.getParagraphText(range);
    }

    public String[] getEndnoteText() {
        Range range = this.doc.getEndnoteRange();
        return WordExtractor.getParagraphText(range);
    }

    public String[] getCommentsText() {
        Range range = this.doc.getCommentsRange();
        return WordExtractor.getParagraphText(range);
    }

    protected static String[] getParagraphText(Range range) {
        String[] stringArray = new String[range.numParagraphs()];
        for (int i = 0; i < stringArray.length; ++i) {
            Paragraph paragraph = range.getParagraph(i);
            stringArray[i] = paragraph.text();
            if (!stringArray[i].endsWith("\r")) continue;
            stringArray[i] = stringArray[i] + "\n";
        }
        return stringArray;
    }

    private void appendHeaderFooter(String string, StringBuffer stringBuffer) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (!(string = string.replace('\r', '\n')).endsWith("\n")) {
            stringBuffer.append(string);
            stringBuffer.append('\n');
            return;
        }
        if (string.endsWith("\n\n")) {
            stringBuffer.append(string.substring(0, string.length() - 1));
            return;
        }
        stringBuffer.append(string);
    }

    @Deprecated
    public String getHeaderText() {
        HeaderStories headerStories = new HeaderStories(this.doc);
        StringBuffer stringBuffer = new StringBuffer();
        if (headerStories.getFirstHeader() != null) {
            this.appendHeaderFooter(headerStories.getFirstHeader(), stringBuffer);
        }
        if (headerStories.getEvenHeader() != null) {
            this.appendHeaderFooter(headerStories.getEvenHeader(), stringBuffer);
        }
        if (headerStories.getOddHeader() != null) {
            this.appendHeaderFooter(headerStories.getOddHeader(), stringBuffer);
        }
        return stringBuffer.toString();
    }

    @Deprecated
    public String getFooterText() {
        HeaderStories headerStories = new HeaderStories(this.doc);
        StringBuffer stringBuffer = new StringBuffer();
        if (headerStories.getFirstFooter() != null) {
            this.appendHeaderFooter(headerStories.getFirstFooter(), stringBuffer);
        }
        if (headerStories.getEvenFooter() != null) {
            this.appendHeaderFooter(headerStories.getEvenFooter(), stringBuffer);
        }
        if (headerStories.getOddFooter() != null) {
            this.appendHeaderFooter(headerStories.getOddFooter(), stringBuffer);
        }
        return stringBuffer.toString();
    }

    public String getTextFromPieces() {
        String string = this.doc.getDocumentText();
        string = string.replaceAll("\r\r\r", "\r\n\r\n\r\n");
        if ((string = string.replaceAll("\r\r", "\r\n\r\n")).endsWith("\r")) {
            string = string + "\n";
        }
        return string;
    }

    public String getText() {
        try {
            WordToTextConverter wordToTextConverter = new WordToTextConverter();
            HeaderStories headerStories = new HeaderStories(this.doc);
            if (headerStories.getFirstHeaderSubrange() != null) {
                wordToTextConverter.processDocumentPart(this.doc, headerStories.getFirstHeaderSubrange());
            }
            if (headerStories.getEvenHeaderSubrange() != null) {
                wordToTextConverter.processDocumentPart(this.doc, headerStories.getEvenHeaderSubrange());
            }
            if (headerStories.getOddHeaderSubrange() != null) {
                wordToTextConverter.processDocumentPart(this.doc, headerStories.getOddHeaderSubrange());
            }
            wordToTextConverter.processDocument(this.doc);
            wordToTextConverter.processDocumentPart(this.doc, this.doc.getMainTextboxRange());
            if (headerStories.getFirstFooterSubrange() != null) {
                wordToTextConverter.processDocumentPart(this.doc, headerStories.getFirstFooterSubrange());
            }
            if (headerStories.getEvenFooterSubrange() != null) {
                wordToTextConverter.processDocumentPart(this.doc, headerStories.getEvenFooterSubrange());
            }
            if (headerStories.getOddFooterSubrange() != null) {
                wordToTextConverter.processDocumentPart(this.doc, headerStories.getOddFooterSubrange());
            }
            return wordToTextConverter.getText();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static String stripFields(String string) {
        return Range.stripFields(string);
    }
}

