/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.extractor;

import ai2.org.apache.poi.POIOLE2TextExtractor;
import ai2.org.apache.poi.hwpf.HWPFOldDocument;
import ai2.org.apache.poi.hwpf.converter.WordToTextConverter;
import ai2.org.apache.poi.hwpf.extractor.WordExtractor;
import ai2.org.apache.poi.hwpf.usermodel.Range;
import ai2.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai2.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import java.io.IOException;
import java.io.InputStream;

public final class Word6Extractor
extends POIOLE2TextExtractor {
    private HWPFOldDocument doc;

    public Word6Extractor(InputStream inputStream) throws IOException {
        this(new POIFSFileSystem(inputStream));
    }

    public Word6Extractor(POIFSFileSystem pOIFSFileSystem) throws IOException {
        this(pOIFSFileSystem.getRoot());
    }

    @Deprecated
    public Word6Extractor(DirectoryNode directoryNode, POIFSFileSystem pOIFSFileSystem) throws IOException {
        this(directoryNode);
    }

    public Word6Extractor(DirectoryNode directoryNode) throws IOException {
        this(new HWPFOldDocument(directoryNode));
    }

    public Word6Extractor(HWPFOldDocument hWPFOldDocument) {
        super(hWPFOldDocument);
        this.doc = hWPFOldDocument;
    }

    @Deprecated
    public String[] getParagraphText() {
        String[] stringArray;
        try {
            Range range = this.doc.getRange();
            stringArray = WordExtractor.getParagraphText(range);
        }
        catch (Exception exception) {
            stringArray = new String[this.doc.getTextTable().getTextPieces().size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = this.doc.getTextTable().getTextPieces().get(i).getStringBuilder().toString();
                stringArray[i].replaceAll("\r", "\ufffe");
                stringArray[i].replaceAll("\ufffe", "\r\n");
            }
        }
        return stringArray;
    }

    public String getText() {
        try {
            WordToTextConverter wordToTextConverter = new WordToTextConverter();
            wordToTextConverter.processDocument(this.doc);
            return wordToTextConverter.getText();
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer();
            for (String string : this.getParagraphText()) {
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
    }
}

