/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.dev;

import ai2.org.apache.poi.POIDocument;
import ai2.org.apache.poi.hwpf.HWPFDocument;
import ai2.org.apache.poi.hwpf.HWPFDocumentCore;
import ai2.org.apache.poi.hwpf.HWPFOldDocument;
import ai2.org.apache.poi.hwpf.OldWordFileFormatException;
import ai2.org.apache.poi.hwpf.model.CHPX;
import ai2.org.apache.poi.hwpf.model.FieldsDocumentPart;
import ai2.org.apache.poi.hwpf.model.FileInformationBlock;
import ai2.org.apache.poi.hwpf.model.GenericPropertyNode;
import ai2.org.apache.poi.hwpf.model.LFO;
import ai2.org.apache.poi.hwpf.model.LFOData;
import ai2.org.apache.poi.hwpf.model.ListLevel;
import ai2.org.apache.poi.hwpf.model.ListTables;
import ai2.org.apache.poi.hwpf.model.PAPFormattedDiskPage;
import ai2.org.apache.poi.hwpf.model.PAPX;
import ai2.org.apache.poi.hwpf.model.PlexOfCps;
import ai2.org.apache.poi.hwpf.model.PropertyNode;
import ai2.org.apache.poi.hwpf.model.StyleDescription;
import ai2.org.apache.poi.hwpf.model.TextPiece;
import ai2.org.apache.poi.hwpf.sprm.SprmIterator;
import ai2.org.apache.poi.hwpf.sprm.SprmOperation;
import ai2.org.apache.poi.hwpf.usermodel.Bookmark;
import ai2.org.apache.poi.hwpf.usermodel.Bookmarks;
import ai2.org.apache.poi.hwpf.usermodel.OfficeDrawing;
import ai2.org.apache.poi.hwpf.usermodel.Paragraph;
import ai2.org.apache.poi.hwpf.usermodel.ParagraphProperties;
import ai2.org.apache.poi.hwpf.usermodel.Picture;
import ai2.org.apache.poi.hwpf.usermodel.Range;
import ai2.org.apache.poi.poifs.filesystem.DirectoryEntry;
import ai2.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai2.org.apache.poi.poifs.filesystem.Entry;
import ai2.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import ai2.org.apache.poi.util.IOUtils;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class HWPFLister {
    private final HWPFDocumentCore _doc;
    private LinkedHashMap<Integer, String> paragraphs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HWPFDocumentCore loadDoc(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            HWPFDocumentCore hWPFDocumentCore = HWPFLister.loadDoc(fileInputStream);
            return hWPFDocumentCore;
        }
        finally {
            IOUtils.closeQuietly(fileInputStream);
        }
    }

    private static HWPFDocumentCore loadDoc(InputStream inputStream) throws IOException {
        POIFSFileSystem pOIFSFileSystem = HWPFDocumentCore.verifyAndBuildPOIFS(inputStream);
        try {
            return new HWPFDocument(pOIFSFileSystem);
        }
        catch (OldWordFileFormatException oldWordFileFormatException) {
            return new HWPFOldDocument(pOIFSFileSystem);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] stringArray) throws Exception {
        void var20_23;
        if (stringArray.length == 0) {
            System.err.println("Use:");
            System.err.println("\tHWPFLister <filename>\n\t\t[--dop]\n\t\t[--textPieces] [--textPiecesText]\n\t\t[--chpx] [--chpxProperties] [--chpxSprms]\n\t\t[--papx] [--papxProperties] [--papxSprms]\n\t\t[--paragraphs] [--paragraphsText]\n\t\t[--bookmarks]\n\t\t[--escher]\n\t\t[--fields]\n\t\t[--pictures]\n\t\t[--officeDrawings]\n\t\t[--styles]\n\t\t[--writereadback]\n");
            System.exit(1);
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = false;
        boolean bl12 = false;
        boolean bl13 = false;
        boolean bl14 = false;
        boolean bl15 = false;
        boolean bl16 = false;
        boolean bl17 = false;
        boolean bl18 = false;
        for (String object2 : Arrays.asList(stringArray).subList(1, stringArray.length)) {
            if ("--dop".equals(object2)) {
                bl = true;
            }
            if ("--textPieces".equals(object2)) {
                bl2 = true;
            }
            if ("--textPiecesText".equals(object2)) {
                bl3 = true;
            }
            if ("--chpx".equals(object2)) {
                bl4 = true;
            }
            if ("--chpxProperties".equals(object2)) {
                bl5 = true;
            }
            if ("--chpxSprms".equals(object2)) {
                bl6 = true;
            }
            if ("--paragraphs".equals(object2)) {
                bl7 = true;
            }
            if ("--paragraphsText".equals(object2)) {
                bl8 = true;
            }
            if ("--papx".equals(object2)) {
                bl9 = true;
            }
            if ("--papxProperties".equals(object2)) {
                bl11 = true;
            }
            if ("--papxSprms".equals(object2)) {
                bl10 = true;
            }
            if ("--bookmarks".equals(object2)) {
                bl12 = true;
            }
            if ("--escher".equals(object2)) {
                bl13 = true;
            }
            if ("--fields".equals(object2)) {
                bl14 = true;
            }
            if ("--pictures".equals(object2)) {
                bl15 = true;
            }
            if ("--officeDrawings".equals(object2)) {
                bl16 = true;
            }
            if ("--styles".equals(object2)) {
                bl17 = true;
            }
            if (!"--writereadback".equals(object2)) continue;
            bl18 = true;
        }
        Object object3 = HWPFLister.loadDoc(new File(stringArray[0]));
        if (bl18) {
            object3 = HWPFLister.writeOutAndReadBack((HWPFDocumentCore)object3);
        }
        System.setProperty("ai2.org.apache.poi.hwpf.preserveBinTables", Boolean.TRUE.toString());
        System.setProperty("ai2.org.apache.poi.hwpf.preserveTextTable", Boolean.TRUE.toString());
        HWPFDocumentCore hWPFDocumentCore = HWPFLister.loadDoc(new File(stringArray[0]));
        if (bl18) {
            HWPFDocumentCore hWPFDocumentCore2 = HWPFLister.writeOutAndReadBack(hWPFDocumentCore);
        }
        HWPFLister hWPFLister = new HWPFLister((HWPFDocumentCore)var20_23);
        HWPFLister hWPFLister2 = new HWPFLister((HWPFDocumentCore)object3);
        System.out.println("== OLE streams ==");
        hWPFLister.dumpFileSystem();
        System.out.println("== FIB (original) ==");
        hWPFLister.dumpFIB();
        if (bl) {
            System.out.println("== Document properties ==");
            hWPFLister.dumpDop();
        }
        if (bl2) {
            System.out.println("== Text pieces (original) ==");
            hWPFLister.dumpTextPieces(bl3);
        }
        if (bl4) {
            System.out.println("== CHPX (original) ==");
            hWPFLister.dumpChpx(bl5, bl6);
            System.out.println("== CHPX (rebuilded) ==");
            hWPFLister2.dumpChpx(bl5, bl6);
        }
        if (bl9) {
            System.out.println("== PAPX (original) ==");
            hWPFLister.dumpPapx(bl11, bl10);
            System.out.println("== PAPX (rebuilded) ==");
            hWPFLister2.dumpPapx(bl11, bl10);
        }
        if (bl7) {
            System.out.println("== Text paragraphs (original) ==");
            hWPFLister2.dumpParagraphs(true);
            System.out.println("== DOM paragraphs (rebuilded) ==");
            hWPFLister2.dumpParagraphsDom(bl8);
        }
        if (bl12) {
            System.out.println("== BOOKMARKS (rebuilded) ==");
            hWPFLister2.dumpBookmarks();
        }
        if (bl13) {
            System.out.println("== ESCHER PROPERTIES (rebuilded) ==");
            hWPFLister2.dumpEscher();
        }
        if (bl14) {
            System.out.println("== FIELDS (rebuilded) ==");
            hWPFLister2.dumpFields();
        }
        if (bl16) {
            System.out.println("== OFFICE DRAWINGS (rebuilded) ==");
            hWPFLister2.dumpOfficeDrawings();
        }
        if (bl15) {
            System.out.println("== PICTURES (rebuilded) ==");
            hWPFLister2.dumpPictures();
        }
        if (bl17) {
            System.out.println("== STYLES (rebuilded) ==");
            hWPFLister2.dumpStyles();
        }
    }

    private static HWPFDocumentCore writeOutAndReadBack(HWPFDocumentCore hWPFDocumentCore) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
            hWPFDocumentCore.write(byteArrayOutputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            return HWPFLister.loadDoc(byteArrayInputStream);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public HWPFLister(HWPFDocumentCore hWPFDocumentCore) {
        this._doc = hWPFDocumentCore;
        this.buildParagraphs();
    }

    private void buildParagraphs() {
        this.paragraphs = new LinkedHashMap();
        StringBuilder stringBuilder = new StringBuilder();
        String string = this._doc.getDocumentText();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            stringBuilder.append(c);
            if (c != '\r' && c != '\u0007' && c != '\f') continue;
            this.paragraphs.put(i, stringBuilder.toString());
            stringBuilder.setLength(0);
        }
    }

    private void dumpBookmarks() {
        if (!(this._doc instanceof HWPFDocument)) {
            System.out.println("Word 95 not supported so far");
            return;
        }
        HWPFDocument hWPFDocument = (HWPFDocument)this._doc;
        Bookmarks bookmarks = hWPFDocument.getBookmarks();
        for (int i = 0; i < bookmarks.getBookmarksCount(); ++i) {
            Bookmark bookmark = bookmarks.getBookmark(i);
            System.out.println("[" + bookmark.getStart() + "; " + bookmark.getEnd() + "): " + bookmark.getName());
        }
    }

    public void dumpChpx(boolean bl, boolean bl2) {
        for (CHPX cHPX : this._doc.getCharacterTable().getTextRuns()) {
            Object object;
            Object object2;
            System.out.println(cHPX);
            if (bl) {
                System.out.println(cHPX.getCharacterProperties(this._doc.getStyleSheet(), (short)4095));
            }
            if (bl2) {
                object2 = new SprmIterator(cHPX.getGrpprl(), 0);
                while (((SprmIterator)object2).hasNext()) {
                    object = ((SprmIterator)object2).next();
                    System.out.println("\t" + ((SprmOperation)object).toString());
                }
            }
            object2 = new Range(cHPX.getStart(), cHPX.getEnd(), this._doc.getOverallRange()){

                public String toString() {
                    return "CHPX range (" + super.toString() + ")";
                }
            }.text();
            object = new StringBuilder();
            for (char c : ((String)object2).toCharArray()) {
                if (c < '\u001e') {
                    ((StringBuilder)object).append("\\0x" + Integer.toHexString(c));
                    continue;
                }
                ((StringBuilder)object).append(c);
            }
            System.out.println(object);
        }
    }

    private void dumpDop() {
        if (!(this._doc instanceof HWPFDocument)) {
            System.out.println("Word 95 not supported so far");
            return;
        }
        System.out.println(((HWPFDocument)this._doc).getDocProperties());
    }

    private void dumpEscher() {
        if (this._doc instanceof HWPFOldDocument) {
            System.out.println("Word 95 not supported so far");
            return;
        }
        System.out.println(((HWPFDocument)this._doc).getEscherRecordHolder());
    }

    public void dumpFIB() {
        FileInformationBlock fileInformationBlock = this._doc.getFileInformationBlock();
        System.out.println(fileInformationBlock);
    }

    private void dumpFields() {
        if (!(this._doc instanceof HWPFDocument)) {
            System.out.println("Word 95 not supported so far");
            return;
        }
        HWPFDocument hWPFDocument = (HWPFDocument)this._doc;
        for (FieldsDocumentPart fieldsDocumentPart : FieldsDocumentPart.values()) {
            System.out.println("=== Document part: " + (Object)((Object)fieldsDocumentPart) + " ===");
            for (ai2.org.apache.poi.hwpf.usermodel.Field field : hWPFDocument.getFields().getFields(fieldsDocumentPart)) {
                System.out.println(field);
            }
        }
    }

    public void dumpFileSystem() throws Exception {
        Field field = POIDocument.class.getDeclaredField("directory");
        field.setAccessible(true);
        DirectoryNode directoryNode = (DirectoryNode)field.get(this._doc);
        System.out.println(this.dumpFileSystem(directoryNode));
    }

    private String dumpFileSystem(DirectoryEntry directoryEntry) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("+ ");
        stringBuilder.append(directoryEntry.getName());
        Iterator<Entry> iterator = directoryEntry.getEntries();
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            String string = "\n" + this.dumpFileSystem(entry);
            string = string.replaceAll("\n", "\n+---");
            stringBuilder.append(string);
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    private String dumpFileSystem(Entry entry) {
        if (entry instanceof DirectoryEntry) {
            return this.dumpFileSystem((DirectoryEntry)entry);
        }
        return entry.getName();
    }

    private void dumpOfficeDrawings() {
        if (!(this._doc instanceof HWPFDocument)) {
            System.out.println("Word 95 not supported so far");
            return;
        }
        HWPFDocument hWPFDocument = (HWPFDocument)this._doc;
        if (hWPFDocument.getOfficeDrawingsHeaders() != null) {
            System.out.println("=== Document part: HEADER ===");
            for (OfficeDrawing officeDrawing : hWPFDocument.getOfficeDrawingsHeaders().getOfficeDrawings()) {
                System.out.println(officeDrawing);
            }
        }
        if (hWPFDocument.getOfficeDrawingsHeaders() != null) {
            System.out.println("=== Document part: MAIN ===");
            for (OfficeDrawing officeDrawing : hWPFDocument.getOfficeDrawingsMain().getOfficeDrawings()) {
                System.out.println(officeDrawing);
            }
        }
    }

    public void dumpPapx(boolean bl, boolean bl2) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Field field;
        Object object4;
        if (this._doc instanceof HWPFDocument) {
            PropertyNode propertyNode;
            System.out.println("binary PAP pages ");
            object4 = (HWPFDocument)this._doc;
            field = HWPFDocumentCore.class.getDeclaredField("_mainStream");
            field.setAccessible(true);
            object3 = (byte[])field.get(this._doc);
            object2 = new PlexOfCps(((HWPFDocument)object4).getTableStream(), ((HWPFDocumentCore)object4).getFileInformationBlock().getFcPlcfbtePapx(), ((HWPFDocumentCore)object4).getFileInformationBlock().getLcbPlcfbtePapx(), 4);
            object = new ArrayList();
            int n = ((PlexOfCps)object2).length();
            for (int i = 0; i < n; ++i) {
                propertyNode = ((PlexOfCps)object2).getProperty(i);
                int n2 = LittleEndian.getInt(((GenericPropertyNode)propertyNode).getBytes());
                int n3 = 512 * n2;
                PAPFormattedDiskPage pAPFormattedDiskPage = new PAPFormattedDiskPage((byte[])object3, ((HWPFDocument)object4).getDataStream(), n3, ((HWPFDocument)object4).getTextTable());
                System.out.println("* PFKP: " + pAPFormattedDiskPage);
                for (PAPX pAPX : pAPFormattedDiskPage.getPAPXs()) {
                    System.out.println("** " + pAPX);
                    object.add(pAPX);
                    if (pAPX == null || !bl2) continue;
                    SprmIterator sprmIterator = new SprmIterator(pAPX.getGrpprl(), 2);
                    this.dumpSprms(sprmIterator, "*** ");
                }
            }
            Collections.sort(object);
            System.out.println("* Sorted by END");
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                propertyNode = (PAPX)iterator.next();
                System.out.println("** " + propertyNode);
                if (propertyNode == null || !bl2) continue;
                SprmIterator sprmIterator = new SprmIterator(((PAPX)propertyNode).getGrpprl(), 2);
                this.dumpSprms(sprmIterator, "*** ");
            }
        }
        object4 = Paragraph.class.getDeclaredMethod("newParagraph", Range.class, PAPX.class);
        ((Method)object4).setAccessible(true);
        field = Paragraph.class.getDeclaredField("_props");
        field.setAccessible(true);
        object3 = this._doc.getParagraphTable().getParagraphs().iterator();
        while (object3.hasNext()) {
            object2 = (PAPX)object3.next();
            System.out.println(object2);
            if (bl) {
                object = (Paragraph)((Method)object4).invoke(null, this._doc.getOverallRange(), object2);
                System.out.println(field.get(object));
            }
            object = new SprmIterator(((PAPX)object2).getGrpprl(), 2);
            this.dumpSprms((SprmIterator)object, "\t");
        }
    }

    public void dumpParagraphs(boolean bl) {
        for (Map.Entry<Integer, String> entry : this.paragraphs.entrySet()) {
            Integer n = entry.getKey();
            System.out.println("[...; " + (n + 1) + "): " + entry.getValue());
            if (!bl) continue;
            boolean bl2 = false;
            for (PAPX pAPX : this._doc.getParagraphTable().getParagraphs()) {
                if (pAPX.getStart() > n || n >= pAPX.getEnd()) continue;
                bl2 = true;
                System.out.println("* " + pAPX);
                SprmIterator sprmIterator = new SprmIterator(pAPX.getGrpprl(), 2);
                this.dumpSprms(sprmIterator, "** ");
            }
            if (bl2) continue;
            System.out.println("* NO PAPX ASSOTIATED WITH PARAGRAPH!");
        }
    }

    protected void dumpSprms(SprmIterator sprmIterator, String string) {
        while (sprmIterator.hasNext()) {
            SprmOperation sprmOperation = sprmIterator.next();
            System.out.println(string + sprmOperation.toString());
        }
    }

    public void dumpParagraphsDom(boolean bl) {
        Range range = this._doc.getOverallRange();
        for (int i = 0; i < range.numParagraphs(); ++i) {
            Paragraph paragraph = range.getParagraph(i);
            System.out.println(i + ":\t" + paragraph.toString());
            if (!bl) continue;
            System.out.println(paragraph.text());
        }
    }

    private void dumpPictures() {
        if (this._doc instanceof HWPFOldDocument) {
            System.out.println("Word 95 not supported so far");
            return;
        }
        List<Picture> list = ((HWPFDocument)this._doc).getPicturesTable().getAllPictures();
        for (Picture picture : list) {
            System.out.println(picture.toString());
        }
    }

    private void dumpStyles() {
        if (this._doc instanceof HWPFOldDocument) {
            System.out.println("Word 95 not supported so far");
            return;
        }
        HWPFDocument hWPFDocument = (HWPFDocument)this._doc;
        for (int i = 0; i < hWPFDocument.getStyleSheet().numStyles(); ++i) {
            StyleDescription styleDescription = hWPFDocument.getStyleSheet().getStyleDescription(i);
            if (styleDescription == null) continue;
            System.out.println("=== Style #" + i + " '" + styleDescription.getName() + "' ===");
            System.out.println(styleDescription);
            if (styleDescription.getPAPX() != null) {
                this.dumpSprms(new SprmIterator(styleDescription.getPAPX(), 2), "Style's PAP SPRM: ");
            }
            if (styleDescription.getCHPX() == null) continue;
            this.dumpSprms(new SprmIterator(styleDescription.getCHPX(), 0), "Style's CHP SPRM: ");
        }
    }

    protected void dumpParagraphLevels(ListTables listTables, ParagraphProperties paragraphProperties) {
        if (paragraphProperties.getIlfo() != 0) {
            LFO lFO = listTables.getLfo(paragraphProperties.getIlfo());
            System.out.println("PAP's LFO: " + lFO);
            LFOData lFOData = listTables.getLfoData(paragraphProperties.getIlfo());
            System.out.println("PAP's LFOData: " + lFOData);
            if (lFO != null) {
                ListLevel listLevel = listTables.getLevel(lFO.getLsid(), paragraphProperties.getIlvl());
                System.out.println("PAP's ListLevel: " + listLevel);
                if (listLevel.getGrpprlPapx() != null) {
                    System.out.println("PAP's ListLevel PAPX:");
                    this.dumpSprms(new SprmIterator(listLevel.getGrpprlPapx(), 0), "* ");
                }
                if (listLevel.getGrpprlPapx() != null) {
                    System.out.println("PAP's ListLevel CHPX:");
                    this.dumpSprms(new SprmIterator(listLevel.getGrpprlChpx(), 0), "* ");
                }
            }
        }
    }

    public void dumpTextPieces(boolean bl) {
        for (TextPiece textPiece : this._doc.getTextTable().getTextPieces()) {
            System.out.println(textPiece);
            if (!bl) continue;
            System.out.println("\t" + textPiece.getStringBuilder());
        }
    }
}

