/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.converter;

import ai2.org.apache.poi.hpsf.SummaryInformation;
import ai2.org.apache.poi.hwpf.HWPFDocument;
import ai2.org.apache.poi.hwpf.HWPFDocumentCore;
import ai2.org.apache.poi.hwpf.converter.AbstractWordConverter;
import ai2.org.apache.poi.hwpf.converter.AbstractWordUtils;
import ai2.org.apache.poi.hwpf.converter.TextDocumentFacade;
import ai2.org.apache.poi.hwpf.usermodel.Bookmark;
import ai2.org.apache.poi.hwpf.usermodel.CharacterRun;
import ai2.org.apache.poi.hwpf.usermodel.OfficeDrawing;
import ai2.org.apache.poi.hwpf.usermodel.Paragraph;
import ai2.org.apache.poi.hwpf.usermodel.Picture;
import ai2.org.apache.poi.hwpf.usermodel.Range;
import ai2.org.apache.poi.hwpf.usermodel.Section;
import ai2.org.apache.poi.hwpf.usermodel.Table;
import ai2.org.apache.poi.hwpf.usermodel.TableCell;
import ai2.org.apache.poi.hwpf.usermodel.TableRow;
import ai2.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai2.org.apache.poi.poifs.filesystem.Entry;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import ai2.org.apache.poi.util.XMLHelper;
import java.io.File;
import java.io.StringWriter;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordToTextConverter
extends AbstractWordConverter {
    private static final POILogger logger = POILogFactory.getLogger(WordToTextConverter.class);
    private AtomicInteger noteCounters = new AtomicInteger(1);
    private Element notes = null;
    private boolean outputSummaryInformation = false;
    private final TextDocumentFacade textDocumentFacade;

    public static String getText(DirectoryNode directoryNode) throws Exception {
        HWPFDocumentCore hWPFDocumentCore = AbstractWordUtils.loadDoc(directoryNode);
        return WordToTextConverter.getText(hWPFDocumentCore);
    }

    public static String getText(File file) throws Exception {
        HWPFDocumentCore hWPFDocumentCore = AbstractWordUtils.loadDoc(file);
        return WordToTextConverter.getText(hWPFDocumentCore);
    }

    public static String getText(HWPFDocumentCore hWPFDocumentCore) throws Exception {
        WordToTextConverter wordToTextConverter = new WordToTextConverter(XMLHelper.getDocumentBuilderFactory().newDocumentBuilder().newDocument());
        wordToTextConverter.processDocument(hWPFDocumentCore);
        return wordToTextConverter.getText();
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            System.err.println("Usage: WordToTextConverter <inputFile.doc> <saveTo.txt>");
            return;
        }
        System.out.println("Converting " + stringArray[0]);
        System.out.println("Saving output to " + stringArray[1]);
        Document document = WordToTextConverter.process(new File(stringArray[0]));
        DOMSource dOMSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(new File(stringArray[1]));
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "no");
        transformer.setOutputProperty("method", "text");
        transformer.transform(dOMSource, streamResult);
    }

    static Document process(File file) throws Exception {
        HWPFDocumentCore hWPFDocumentCore = AbstractWordUtils.loadDoc(file);
        WordToTextConverter wordToTextConverter = new WordToTextConverter(XMLHelper.getDocumentBuilderFactory().newDocumentBuilder().newDocument());
        wordToTextConverter.processDocument(hWPFDocumentCore);
        return wordToTextConverter.getDocument();
    }

    public WordToTextConverter() throws ParserConfigurationException {
        this.textDocumentFacade = new TextDocumentFacade(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument());
    }

    public WordToTextConverter(Document document) {
        this.textDocumentFacade = new TextDocumentFacade(document);
    }

    public WordToTextConverter(TextDocumentFacade textDocumentFacade) {
        this.textDocumentFacade = textDocumentFacade;
    }

    @Override
    protected void afterProcess() {
        if (this.notes != null) {
            this.textDocumentFacade.getBody().appendChild(this.notes);
        }
    }

    @Override
    public Document getDocument() {
        return this.textDocumentFacade.getDocument();
    }

    public String getText() throws Exception {
        StringWriter stringWriter = new StringWriter();
        DOMSource dOMSource = new DOMSource(this.getDocument());
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "no");
        transformer.setOutputProperty("method", "text");
        transformer.transform(dOMSource, streamResult);
        return stringWriter.toString();
    }

    public boolean isOutputSummaryInformation() {
        return this.outputSummaryInformation;
    }

    @Override
    protected void outputCharacters(Element element, CharacterRun characterRun, String string) {
        element.appendChild(this.textDocumentFacade.createText(string));
    }

    @Override
    protected void processBookmarks(HWPFDocumentCore hWPFDocumentCore, Element element, Range range, int n, List<Bookmark> list) {
        this.processCharacters(hWPFDocumentCore, n, range, element);
    }

    @Override
    protected void processDocumentInformation(SummaryInformation summaryInformation) {
        if (this.isOutputSummaryInformation()) {
            if (AbstractWordUtils.isNotEmpty(summaryInformation.getTitle())) {
                this.textDocumentFacade.setTitle(summaryInformation.getTitle());
            }
            if (AbstractWordUtils.isNotEmpty(summaryInformation.getAuthor())) {
                this.textDocumentFacade.addAuthor(summaryInformation.getAuthor());
            }
            if (AbstractWordUtils.isNotEmpty(summaryInformation.getComments())) {
                this.textDocumentFacade.addDescription(summaryInformation.getComments());
            }
            if (AbstractWordUtils.isNotEmpty(summaryInformation.getKeywords())) {
                this.textDocumentFacade.addKeywords(summaryInformation.getKeywords());
            }
        }
    }

    @Override
    public void processDocumentPart(HWPFDocumentCore hWPFDocumentCore, Range range) {
        super.processDocumentPart(hWPFDocumentCore, range);
        this.afterProcess();
    }

    @Override
    protected void processDrawnObject(HWPFDocument hWPFDocument, CharacterRun characterRun, OfficeDrawing officeDrawing, String string, Element element) {
    }

    @Override
    protected void processEndnoteAutonumbered(HWPFDocument hWPFDocument, int n, Element element, Range range) {
        this.processNote(hWPFDocument, element, range);
    }

    @Override
    protected void processFootnoteAutonumbered(HWPFDocument hWPFDocument, int n, Element element, Range range) {
        this.processNote(hWPFDocument, element, range);
    }

    @Override
    protected void processHyperlink(HWPFDocumentCore hWPFDocumentCore, Element element, Range range, int n, String string) {
        this.processCharacters(hWPFDocumentCore, n, range, element);
        element.appendChild(this.textDocumentFacade.createText(" (\u200b" + string.replaceAll("\\/", "\u200b\\/\u200b") + '\u200b' + ")"));
    }

    @Override
    protected void processImage(Element element, boolean bl, Picture picture) {
    }

    @Override
    protected void processImage(Element element, boolean bl, Picture picture, String string) {
    }

    @Override
    protected void processImageWithoutPicturesManager(Element element, boolean bl, Picture picture) {
    }

    @Override
    protected void processLineBreak(Element element, CharacterRun characterRun) {
        element.appendChild(this.textDocumentFacade.createText("\n"));
    }

    protected void processNote(HWPFDocument hWPFDocument, Element element, Range range) {
        int n = this.noteCounters.getAndIncrement();
        element.appendChild(this.textDocumentFacade.createText("\u200b[" + n + "]" + '\u200b'));
        if (this.notes == null) {
            this.notes = this.textDocumentFacade.createBlock();
        }
        Element element2 = this.textDocumentFacade.createBlock();
        this.notes.appendChild(element2);
        element2.appendChild(this.textDocumentFacade.createText("^" + n + "\t "));
        this.processCharacters(hWPFDocument, Integer.MIN_VALUE, range, element2);
        element2.appendChild(this.textDocumentFacade.createText("\n"));
    }

    @Override
    protected boolean processOle2(HWPFDocument hWPFDocument, Element element, Entry entry) throws Exception {
        Object object;
        Object object2;
        GenericDeclaration genericDeclaration;
        if (!(entry instanceof DirectoryNode)) {
            return false;
        }
        DirectoryNode directoryNode = (DirectoryNode)entry;
        if (directoryNode.hasEntry("WordDocument")) {
            String string = WordToTextConverter.getText((DirectoryNode)entry);
            element.appendChild(this.textDocumentFacade.createText('\u200b' + string + '\u200b'));
            return true;
        }
        try {
            genericDeclaration = Class.forName("ai2.org.apache.poi.extractor.ExtractorFactory");
            object2 = ((Class)genericDeclaration).getMethod("createExtractor", DirectoryNode.class);
            object = ((Method)object2).invoke(null, directoryNode);
        }
        catch (Exception exception) {
            logger.log(5, "There is an OLE object entry '", entry.getName(), "', but there is no text extractor for this object type ", "or text extractor factory is not available: ", "" + exception);
            return false;
        }
        try {
            genericDeclaration = object.getClass().getMethod("getText", new Class[0]);
            object2 = (String)((Method)genericDeclaration).invoke(object, new Object[0]);
            element.appendChild(this.textDocumentFacade.createText('\u200b' + (String)object2 + '\u200b'));
            return true;
        }
        catch (Exception exception) {
            logger.log(7, "Unable to extract text from OLE entry '", entry.getName(), "': ", exception, exception);
            return false;
        }
    }

    @Override
    protected void processPageBreak(HWPFDocumentCore hWPFDocumentCore, Element element) {
        Element element2 = this.textDocumentFacade.createBlock();
        element2.appendChild(this.textDocumentFacade.createText("\n"));
        element.appendChild(element2);
    }

    @Override
    protected void processPageref(HWPFDocumentCore hWPFDocumentCore, Element element, Range range, int n, String string) {
        this.processCharacters(hWPFDocumentCore, n, range, element);
    }

    @Override
    protected void processParagraph(HWPFDocumentCore hWPFDocumentCore, Element element, int n, Paragraph paragraph, String string) {
        Element element2 = this.textDocumentFacade.createParagraph();
        element2.appendChild(this.textDocumentFacade.createText(string));
        this.processCharacters(hWPFDocumentCore, n, paragraph, element2);
        element2.appendChild(this.textDocumentFacade.createText("\n"));
        element.appendChild(element2);
    }

    @Override
    protected void processSection(HWPFDocumentCore hWPFDocumentCore, Section section, int n) {
        Element element = this.textDocumentFacade.createBlock();
        this.processParagraphes(hWPFDocumentCore, element, section, Integer.MIN_VALUE);
        element.appendChild(this.textDocumentFacade.createText("\n"));
        this.textDocumentFacade.body.appendChild(element);
    }

    @Override
    protected void processTable(HWPFDocumentCore hWPFDocumentCore, Element element, Table table) {
        int n = table.numRows();
        for (int i = 0; i < n; ++i) {
            TableRow tableRow = table.getRow(i);
            Element element2 = this.textDocumentFacade.createTableRow();
            int n2 = tableRow.numCells();
            for (int j = 0; j < n2; ++j) {
                TableCell tableCell = tableRow.getCell(j);
                Element element3 = this.textDocumentFacade.createTableCell();
                if (j != 0) {
                    element3.appendChild(this.textDocumentFacade.createText("\t"));
                }
                this.processCharacters(hWPFDocumentCore, table.getTableLevel(), tableCell, element3);
                element2.appendChild(element3);
            }
            element2.appendChild(this.textDocumentFacade.createText("\n"));
            element.appendChild(element2);
        }
    }

    public void setOutputSummaryInformation(boolean bl) {
        this.outputSummaryInformation = bl;
    }
}

