/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.converter;

import ai2.org.apache.poi.hwpf.converter.AbstractWordUtils;
import ai2.org.apache.poi.hwpf.usermodel.BorderCode;
import ai2.org.apache.poi.hwpf.usermodel.CharacterRun;
import ai2.org.apache.poi.hwpf.usermodel.Paragraph;
import ai2.org.apache.poi.hwpf.usermodel.Picture;
import ai2.org.apache.poi.hwpf.usermodel.TableCell;
import ai2.org.apache.poi.hwpf.usermodel.TableRow;
import org.w3c.dom.Element;

public class WordToFoUtils
extends AbstractWordUtils {
    static void compactInlines(Element element) {
        WordToFoUtils.compactChildNodesR(element, "fo:inline");
    }

    public static void setBold(Element element, boolean bl) {
        element.setAttribute("font-weight", bl ? "bold" : "normal");
    }

    public static void setBorder(Element element, BorderCode borderCode, String string) {
        if (element == null) {
            throw new IllegalArgumentException("element is null");
        }
        if (borderCode == null || borderCode.isEmpty()) {
            return;
        }
        if (WordToFoUtils.isEmpty(string)) {
            element.setAttribute("border-style", WordToFoUtils.getBorderType(borderCode));
            element.setAttribute("border-color", WordToFoUtils.getColor(borderCode.getColor()));
            element.setAttribute("border-width", WordToFoUtils.getBorderWidth(borderCode));
        } else {
            element.setAttribute("border-" + string + "-style", WordToFoUtils.getBorderType(borderCode));
            element.setAttribute("border-" + string + "-color", WordToFoUtils.getColor(borderCode.getColor()));
            element.setAttribute("border-" + string + "-width", WordToFoUtils.getBorderWidth(borderCode));
        }
    }

    public static void setCharactersProperties(CharacterRun characterRun, Element element) {
        StringBuilder stringBuilder = new StringBuilder();
        WordToFoUtils.setBorder(element, characterRun.getBorder(), "");
        if (characterRun.getIco24() != -1) {
            element.setAttribute("color", WordToFoUtils.getColor24(characterRun.getIco24()));
        }
        if (characterRun.isCapitalized()) {
            element.setAttribute("text-transform", "uppercase");
        }
        if (characterRun.isHighlighted()) {
            element.setAttribute("background-color", WordToFoUtils.getColor(characterRun.getHighlightedColor()));
        }
        if (characterRun.isStrikeThrough()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append("line-through");
        }
        if (characterRun.isShadowed()) {
            element.setAttribute("text-shadow", characterRun.getFontSize() / 24 + "pt");
        }
        if (characterRun.isSmallCaps()) {
            element.setAttribute("font-variant", "small-caps");
        }
        if (characterRun.getSubSuperScriptIndex() == 1) {
            element.setAttribute("baseline-shift", "super");
            element.setAttribute("font-size", "smaller");
        }
        if (characterRun.getSubSuperScriptIndex() == 2) {
            element.setAttribute("baseline-shift", "sub");
            element.setAttribute("font-size", "smaller");
        }
        if (characterRun.getUnderlineCode() > 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append("underline");
        }
        if (characterRun.isVanished()) {
            element.setAttribute("visibility", "hidden");
        }
        if (stringBuilder.length() > 0) {
            element.setAttribute("text-decoration", stringBuilder.toString());
        }
    }

    public static void setFontFamily(Element element, String string) {
        if (WordToFoUtils.isEmpty(string)) {
            return;
        }
        element.setAttribute("font-family", string);
    }

    public static void setFontSize(Element element, int n) {
        element.setAttribute("font-size", String.valueOf(n));
    }

    public static void setIndent(Paragraph paragraph, Element element) {
        if (paragraph.getFirstLineIndent() != 0) {
            element.setAttribute("text-indent", String.valueOf(paragraph.getFirstLineIndent() / 20) + "pt");
        }
        if (paragraph.getIndentFromLeft() != 0) {
            element.setAttribute("start-indent", String.valueOf(paragraph.getIndentFromLeft() / 20) + "pt");
        }
        if (paragraph.getIndentFromRight() != 0) {
            element.setAttribute("end-indent", String.valueOf(paragraph.getIndentFromRight() / 20) + "pt");
        }
        if (paragraph.getSpacingBefore() != 0) {
            element.setAttribute("space-before", String.valueOf(paragraph.getSpacingBefore() / 20) + "pt");
        }
        if (paragraph.getSpacingAfter() != 0) {
            element.setAttribute("space-after", String.valueOf(paragraph.getSpacingAfter() / 20) + "pt");
        }
    }

    public static void setItalic(Element element, boolean bl) {
        element.setAttribute("font-style", bl ? "italic" : "normal");
    }

    public static void setJustification(Paragraph paragraph, Element element) {
        String string = WordToFoUtils.getJustification(paragraph.getJustification());
        if (WordToFoUtils.isNotEmpty(string)) {
            element.setAttribute("text-align", string);
        }
    }

    public static void setLanguage(CharacterRun characterRun, Element element) {
        String string;
        if (characterRun.getLanguageCode() != 0 && WordToFoUtils.isNotEmpty(string = WordToFoUtils.getLanguage(characterRun.getLanguageCode()))) {
            element.setAttribute("language", string);
        }
    }

    public static void setParagraphProperties(Paragraph paragraph, Element element) {
        WordToFoUtils.setIndent(paragraph, element);
        WordToFoUtils.setJustification(paragraph, element);
        WordToFoUtils.setBorder(element, paragraph.getBottomBorder(), "bottom");
        WordToFoUtils.setBorder(element, paragraph.getLeftBorder(), "left");
        WordToFoUtils.setBorder(element, paragraph.getRightBorder(), "right");
        WordToFoUtils.setBorder(element, paragraph.getTopBorder(), "top");
        if (paragraph.pageBreakBefore()) {
            element.setAttribute("break-before", "page");
        }
        element.setAttribute("hyphenate", String.valueOf(paragraph.isAutoHyphenated()));
        if (paragraph.keepOnPage()) {
            element.setAttribute("keep-together.within-page", "always");
        }
        if (paragraph.keepWithNext()) {
            element.setAttribute("keep-with-next.within-page", "always");
        }
        element.setAttribute("linefeed-treatment", "preserve");
        element.setAttribute("white-space-collapse", "false");
    }

    public static void setPictureProperties(Picture picture, Element element) {
        int n = picture.getHorizontalScalingFactor();
        int n2 = picture.getVerticalScalingFactor();
        if (n > 0) {
            element.setAttribute("content-width", picture.getDxaGoal() * n / 1000 / 20 + "pt");
        } else {
            element.setAttribute("content-width", picture.getDxaGoal() / 20 + "pt");
        }
        if (n2 > 0) {
            element.setAttribute("content-height", picture.getDyaGoal() * n2 / 1000 / 20 + "pt");
        } else {
            element.setAttribute("content-height", picture.getDyaGoal() / 20 + "pt");
        }
        if (n <= 0 || n2 <= 0) {
            element.setAttribute("scaling", "uniform");
        } else {
            element.setAttribute("scaling", "non-uniform");
        }
        element.setAttribute("vertical-align", "text-bottom");
        if (picture.getDyaCropTop() != 0 || picture.getDxaCropRight() != 0 || picture.getDyaCropBottom() != 0 || picture.getDxaCropLeft() != 0) {
            int n3 = picture.getDyaCropTop() / 20;
            int n4 = picture.getDxaCropRight() / 20;
            int n5 = picture.getDyaCropBottom() / 20;
            int n6 = picture.getDxaCropLeft() / 20;
            element.setAttribute("clip", "rect(" + n3 + "pt, " + n4 + "pt, " + n5 + "pt, " + n6 + "pt)");
            element.setAttribute("overflow", "hidden");
        }
    }

    public static void setTableCellProperties(TableRow tableRow, TableCell tableCell, Element element, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        BorderCode borderCode;
        BorderCode borderCode2;
        BorderCode borderCode3;
        element.setAttribute("width", (float)tableCell.getWidth() / 1440.0f + "in");
        element.setAttribute("padding-start", (float)tableRow.getGapHalf() / 1440.0f + "in");
        element.setAttribute("padding-end", (float)tableRow.getGapHalf() / 1440.0f + "in");
        BorderCode borderCode4 = tableCell.getBrcTop() != null && tableCell.getBrcTop().getBorderType() != 0 ? tableCell.getBrcTop() : (borderCode3 = bl ? tableRow.getTopBorder() : tableRow.getHorizontalBorder());
        BorderCode borderCode5 = tableCell.getBrcBottom() != null && tableCell.getBrcBottom().getBorderType() != 0 ? tableCell.getBrcBottom() : (borderCode2 = bl2 ? tableRow.getBottomBorder() : tableRow.getHorizontalBorder());
        BorderCode borderCode6 = tableCell.getBrcLeft() != null && tableCell.getBrcLeft().getBorderType() != 0 ? tableCell.getBrcLeft() : (borderCode = bl3 ? tableRow.getLeftBorder() : tableRow.getVerticalBorder());
        BorderCode borderCode7 = tableCell.getBrcRight() != null && tableCell.getBrcRight().getBorderType() != 0 ? tableCell.getBrcRight() : (bl4 ? tableRow.getRightBorder() : tableRow.getVerticalBorder());
        WordToFoUtils.setBorder(element, borderCode2, "bottom");
        WordToFoUtils.setBorder(element, borderCode, "left");
        WordToFoUtils.setBorder(element, borderCode7, "right");
        WordToFoUtils.setBorder(element, borderCode3, "top");
    }

    public static void setTableRowProperties(TableRow tableRow, Element element) {
        if (tableRow.getRowHeight() > 0) {
            element.setAttribute("height", (float)tableRow.getRowHeight() / 1440.0f + "in");
        }
        if (!tableRow.cantSplit()) {
            element.setAttribute("keep-together.within-column", "always");
        }
    }
}

