/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.converter;

import ai2.org.apache.poi.hpsf.SummaryInformation;
import ai2.org.apache.poi.hwpf.HWPFDocument;
import ai2.org.apache.poi.hwpf.HWPFDocumentCore;
import ai2.org.apache.poi.hwpf.converter.AbstractWordConverter;
import ai2.org.apache.poi.hwpf.converter.FoDocumentFacade;
import ai2.org.apache.poi.hwpf.converter.FontReplacer;
import ai2.org.apache.poi.hwpf.converter.WordToFoUtils;
import ai2.org.apache.poi.hwpf.converter.WordToHtmlUtils;
import ai2.org.apache.poi.hwpf.usermodel.Bookmark;
import ai2.org.apache.poi.hwpf.usermodel.CharacterRun;
import ai2.org.apache.poi.hwpf.usermodel.OfficeDrawing;
import ai2.org.apache.poi.hwpf.usermodel.Paragraph;
import ai2.org.apache.poi.hwpf.usermodel.Picture;
import ai2.org.apache.poi.hwpf.usermodel.Range;
import ai2.org.apache.poi.hwpf.usermodel.Section;
import ai2.org.apache.poi.hwpf.usermodel.Table;
import ai2.org.apache.poi.hwpf.usermodel.TableCell;
import ai2.org.apache.poi.hwpf.usermodel.TableRow;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import ai2.org.apache.poi.util.XMLHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordToFoConverter
extends AbstractWordConverter {
    private static final POILogger logger = POILogFactory.getLogger(WordToFoConverter.class);
    private List<Element> endnotes = new ArrayList<Element>(0);
    protected final FoDocumentFacade foDocumentFacade;
    private AtomicInteger internalLinkCounter = new AtomicInteger(0);
    private boolean outputCharactersLanguage = false;
    private Set<String> usedIds = new LinkedHashSet<String>();

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            System.err.println("Usage: WordToFoConverter <inputFile.doc> <saveTo.fo>");
            return;
        }
        System.out.println("Converting " + stringArray[0]);
        System.out.println("Saving output to " + stringArray[1]);
        Document document = WordToFoConverter.process(new File(stringArray[0]));
        DOMSource dOMSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(new File(stringArray[1]));
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(dOMSource, streamResult);
    }

    static Document process(File file) throws Exception {
        HWPFDocumentCore hWPFDocumentCore = WordToFoUtils.loadDoc(file);
        WordToFoConverter wordToFoConverter = new WordToFoConverter(XMLHelper.getDocumentBuilderFactory().newDocumentBuilder().newDocument());
        wordToFoConverter.processDocument(hWPFDocumentCore);
        return wordToFoConverter.getDocument();
    }

    public WordToFoConverter(Document document) {
        this.foDocumentFacade = new FoDocumentFacade(document);
    }

    public WordToFoConverter(FoDocumentFacade foDocumentFacade) {
        this.foDocumentFacade = foDocumentFacade;
    }

    protected Element createNoteInline(String string) {
        Element element = this.foDocumentFacade.createInline();
        element.setTextContent(string);
        element.setAttribute("baseline-shift", "super");
        element.setAttribute("font-size", "smaller");
        return element;
    }

    protected String createPageMaster(Section section, String string, int n) {
        float f = (float)section.getPageHeight() / 1440.0f;
        float f2 = (float)section.getPageWidth() / 1440.0f;
        float f3 = (float)section.getMarginLeft() / 1440.0f;
        float f4 = (float)section.getMarginRight() / 1440.0f;
        float f5 = (float)section.getMarginTop() / 1440.0f;
        float f6 = (float)section.getMarginBottom() / 1440.0f;
        String string2 = string + "-page" + n;
        Element element = this.foDocumentFacade.addSimplePageMaster(string2);
        element.setAttribute("page-height", f + "in");
        element.setAttribute("page-width", f2 + "in");
        Element element2 = this.foDocumentFacade.addRegionBody(element);
        element2.setAttribute("margin", f5 + "in " + f4 + "in " + f6 + "in " + f3 + "in");
        if (section.getNumColumns() > 1) {
            element2.setAttribute("column-count", "" + section.getNumColumns());
            if (section.isColumnsEvenlySpaced()) {
                float f7 = (float)section.getDistanceBetweenColumns() / 1440.0f;
                element2.setAttribute("column-gap", f7 + "in");
            } else {
                element2.setAttribute("column-gap", "0.25in");
            }
        }
        return string2;
    }

    @Override
    public Document getDocument() {
        return this.foDocumentFacade.getDocument();
    }

    public boolean isOutputCharactersLanguage() {
        return this.outputCharactersLanguage;
    }

    @Override
    protected void outputCharacters(Element element, CharacterRun characterRun, String string) {
        Element element2 = this.foDocumentFacade.createInline();
        FontReplacer.Triplet triplet = this.getCharacterRunTriplet(characterRun);
        if (WordToFoUtils.isNotEmpty(triplet.fontName)) {
            WordToFoUtils.setFontFamily(element2, triplet.fontName);
        }
        WordToFoUtils.setBold(element2, triplet.bold);
        WordToFoUtils.setItalic(element2, triplet.italic);
        WordToFoUtils.setFontSize(element2, characterRun.getFontSize() / 2);
        WordToFoUtils.setCharactersProperties(characterRun, element2);
        if (this.isOutputCharactersLanguage()) {
            WordToFoUtils.setLanguage(characterRun, element2);
        }
        element.appendChild(element2);
        Text text = this.foDocumentFacade.createText(string);
        element2.appendChild(text);
    }

    @Override
    protected void processBookmarks(HWPFDocumentCore hWPFDocumentCore, Element element, Range range, int n, List<Bookmark> list) {
        Element element2 = element;
        for (Bookmark bookmark : list) {
            String string;
            Element element3 = this.foDocumentFacade.createInline();
            if (!this.setId(element3, string = "bookmark_" + bookmark.getName())) continue;
            element2.appendChild(element3);
            element2 = element3;
        }
        if (range != null) {
            this.processCharacters(hWPFDocumentCore, n, range, element2);
        }
    }

    @Override
    protected void processDocumentInformation(SummaryInformation summaryInformation) {
        if (WordToHtmlUtils.isNotEmpty(summaryInformation.getTitle())) {
            this.foDocumentFacade.setTitle(summaryInformation.getTitle());
        }
        if (WordToHtmlUtils.isNotEmpty(summaryInformation.getAuthor())) {
            this.foDocumentFacade.setCreator(summaryInformation.getAuthor());
        }
        if (WordToHtmlUtils.isNotEmpty(summaryInformation.getKeywords())) {
            this.foDocumentFacade.setKeywords(summaryInformation.getKeywords());
        }
        if (WordToHtmlUtils.isNotEmpty(summaryInformation.getComments())) {
            this.foDocumentFacade.setDescription(summaryInformation.getComments());
        }
    }

    @Override
    protected void processDrawnObject(HWPFDocument hWPFDocument, CharacterRun characterRun, OfficeDrawing officeDrawing, String string, Element element) {
        Element element2 = this.foDocumentFacade.createExternalGraphic(string);
        element.appendChild(element2);
    }

    @Override
    protected void processEndnoteAutonumbered(HWPFDocument hWPFDocument, int n, Element element, Range range) {
        String string = String.valueOf(this.internalLinkCounter.incrementAndGet());
        String string2 = "endnote_" + string;
        String string3 = "endnote_back_" + string;
        Element element2 = this.foDocumentFacade.createBasicLinkInternal(string2);
        element2.appendChild(this.createNoteInline(string));
        this.setId(element2, string3);
        element.appendChild(element2);
        Element element3 = this.foDocumentFacade.createBlock();
        Element element4 = this.foDocumentFacade.createBasicLinkInternal(string3);
        element4.appendChild(this.createNoteInline(string + " "));
        this.setId(element4, string2);
        element3.appendChild(element4);
        this.processCharacters(hWPFDocument, Integer.MIN_VALUE, range, element3);
        WordToFoUtils.compactInlines(element3);
        this.endnotes.add(element3);
    }

    @Override
    protected void processFootnoteAutonumbered(HWPFDocument hWPFDocument, int n, Element element, Range range) {
        String string = String.valueOf(this.internalLinkCounter.incrementAndGet());
        String string2 = "footnote_" + string;
        String string3 = "footnote_back_" + string;
        Element element2 = this.foDocumentFacade.createFootnote();
        element.appendChild(element2);
        Element element3 = this.foDocumentFacade.createInline();
        Element element4 = this.foDocumentFacade.createBasicLinkInternal(string2);
        element4.appendChild(this.createNoteInline(string));
        this.setId(element4, string3);
        element3.appendChild(element4);
        element2.appendChild(element3);
        Element element5 = this.foDocumentFacade.createFootnoteBody();
        Element element6 = this.foDocumentFacade.createBlock();
        Element element7 = this.foDocumentFacade.createBasicLinkInternal(string3);
        element7.appendChild(this.createNoteInline(string + " "));
        this.setId(element7, string2);
        element6.appendChild(element7);
        element5.appendChild(element6);
        element2.appendChild(element5);
        this.processCharacters(hWPFDocument, Integer.MIN_VALUE, range, element6);
        WordToFoUtils.compactInlines(element6);
    }

    @Override
    protected void processHyperlink(HWPFDocumentCore hWPFDocumentCore, Element element, Range range, int n, String string) {
        Element element2 = this.foDocumentFacade.createBasicLinkExternal(string);
        element.appendChild(element2);
        if (range != null) {
            this.processCharacters(hWPFDocumentCore, n, range, element2);
        }
    }

    @Override
    protected void processImage(Element element, boolean bl, Picture picture, String string) {
        Element element2 = this.foDocumentFacade.createExternalGraphic(string);
        WordToFoUtils.setPictureProperties(picture, element2);
        element.appendChild(element2);
    }

    @Override
    protected void processImageWithoutPicturesManager(Element element, boolean bl, Picture picture) {
        element.appendChild(this.foDocumentFacade.document.createComment("Image link to '" + picture.suggestFullFileName() + "' can be here"));
    }

    @Override
    protected void processLineBreak(Element element, CharacterRun characterRun) {
        element.appendChild(this.foDocumentFacade.createBlock());
    }

    @Override
    protected void processPageBreak(HWPFDocumentCore hWPFDocumentCore, Element element) {
        Element element2;
        Node node;
        Element element3 = null;
        NodeList nodeList = element.getChildNodes();
        if (nodeList.getLength() > 0 && (node = nodeList.item(nodeList.getLength() - 1)) instanceof Element && !(element2 = (Element)node).hasAttribute("break-after")) {
            element3 = element2;
        }
        if (element3 == null) {
            element3 = this.foDocumentFacade.createBlock();
            element.appendChild(element3);
        }
        element3.setAttribute("break-after", "page");
    }

    @Override
    protected void processPageref(HWPFDocumentCore hWPFDocumentCore, Element element, Range range, int n, String string) {
        Element element2 = this.foDocumentFacade.createBasicLinkInternal("bookmark_" + string);
        element.appendChild(element2);
        if (range != null) {
            this.processCharacters(hWPFDocumentCore, n, range, element2);
        }
    }

    @Override
    protected void processParagraph(HWPFDocumentCore hWPFDocumentCore, Element element, int n, Paragraph paragraph, String string) {
        Element element2;
        Element element3 = this.foDocumentFacade.createBlock();
        element.appendChild(element3);
        WordToFoUtils.setParagraphProperties(paragraph, element3);
        int n2 = paragraph.numCharacterRuns();
        if (n2 == 0) {
            return;
        }
        boolean bl = false;
        if (WordToFoUtils.isNotEmpty(string)) {
            element2 = this.foDocumentFacade.createInline();
            element3.appendChild(element2);
            Text text = this.foDocumentFacade.createText(string);
            element2.appendChild(text);
            bl |= string.trim().length() != 0;
        }
        if (!(bl = this.processCharacters(hWPFDocumentCore, n, paragraph, element3))) {
            element2 = this.foDocumentFacade.createLeader();
            element3.appendChild(element2);
        }
        WordToFoUtils.compactInlines(element3);
    }

    @Override
    protected void processSection(HWPFDocumentCore hWPFDocumentCore, Section section, int n) {
        String string = this.createPageMaster(section, "page", n);
        Element element = this.foDocumentFacade.addPageSequence(string);
        Element element2 = this.foDocumentFacade.addFlowToPageSequence(element, "xsl-region-body");
        this.processParagraphes(hWPFDocumentCore, element2, section, Integer.MIN_VALUE);
        if (this.endnotes != null && !this.endnotes.isEmpty()) {
            for (Element element3 : this.endnotes) {
                element2.appendChild(element3);
            }
            this.endnotes.clear();
        }
    }

    @Override
    protected void processTable(HWPFDocumentCore hWPFDocumentCore, Element element, Table table) {
        int n;
        Element element2 = this.foDocumentFacade.createTableHeader();
        Element element3 = this.foDocumentFacade.createTableBody();
        int[] nArray = WordToHtmlUtils.buildTableCellEdgesArray(table);
        int n2 = table.numRows();
        int n3 = Integer.MIN_VALUE;
        for (n = 0; n < n2; ++n) {
            n3 = Math.max(n3, table.getRow(n).numCells());
        }
        for (n = 0; n < n2; ++n) {
            TableRow tableRow = table.getRow(n);
            Element element4 = this.foDocumentFacade.createTableRow();
            WordToFoUtils.setTableRowProperties(tableRow, element4);
            int n4 = 0;
            int n5 = tableRow.numCells();
            for (int i = 0; i < n5; ++i) {
                int n6;
                TableCell tableCell = tableRow.getCell(i);
                if (tableCell.isVerticallyMerged() && !tableCell.isFirstVerticallyMerged()) {
                    n4 += this.getNumberColumnsSpanned(nArray, n4, tableCell);
                    continue;
                }
                Element element5 = this.foDocumentFacade.createTableCell();
                WordToFoUtils.setTableCellProperties(tableRow, tableCell, element5, n == 0, n == n2 - 1, i == 0, i == n5 - 1);
                int n7 = this.getNumberColumnsSpanned(nArray, n4, tableCell);
                n4 += n7;
                if (n7 == 0) continue;
                if (n7 != 1) {
                    element5.setAttribute("number-columns-spanned", String.valueOf(n7));
                }
                if ((n6 = this.getNumberRowsSpanned(table, nArray, n, i, tableCell)) > 1) {
                    element5.setAttribute("number-rows-spanned", String.valueOf(n6));
                }
                this.processParagraphes(hWPFDocumentCore, element5, tableCell, table.getTableLevel());
                if (!element5.hasChildNodes()) {
                    element5.appendChild(this.foDocumentFacade.createBlock());
                }
                element4.appendChild(element5);
            }
            if (!element4.hasChildNodes()) continue;
            if (tableRow.isTableHeader()) {
                element2.appendChild(element4);
                continue;
            }
            element3.appendChild(element4);
        }
        Element element6 = this.foDocumentFacade.createTable();
        element6.setAttribute("table-layout", "fixed");
        if (element2.hasChildNodes()) {
            element6.appendChild(element2);
        }
        if (element3.hasChildNodes()) {
            element6.appendChild(element3);
            element.appendChild(element6);
        } else {
            logger.log(5, new Object[]{"Table without body starting on offset " + table.getStartOffset() + " -- " + table.getEndOffset()});
        }
    }

    protected boolean setId(Element element, String string) {
        if (this.usedIds.contains(string)) {
            logger.log(5, "Tried to create element with same ID '", string, "'. Skipped");
            return false;
        }
        element.setAttribute("id", string);
        this.usedIds.add(string);
        return true;
    }

    public void setOutputCharactersLanguage(boolean bl) {
        this.outputCharactersLanguage = bl;
    }
}

