/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.converter;

import ai2.org.apache.poi.hwpf.converter.WordToHtmlUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlDocumentFacade {
    protected final Element body;
    protected final Document document;
    protected final Element head;
    protected final Element html;
    private Map<String, Map<String, String>> stylesheet = new LinkedHashMap<String, Map<String, String>>();
    private Element stylesheetElement;
    protected Element title;
    protected Text titleText;

    public HtmlDocumentFacade(Document document) {
        this.document = document;
        this.html = document.createElement("html");
        document.appendChild(this.html);
        this.body = document.createElement("body");
        this.head = document.createElement("head");
        this.stylesheetElement = document.createElement("style");
        this.stylesheetElement.setAttribute("type", "text/css");
        this.html.appendChild(this.head);
        this.html.appendChild(this.body);
        this.head.appendChild(this.stylesheetElement);
        this.addStyleClass(this.body, "b", "white-space-collapsing:preserve;");
    }

    public void addAuthor(String string) {
        this.addMeta("author", string);
    }

    public void addDescription(String string) {
        this.addMeta("description", string);
    }

    public void addKeywords(String string) {
        this.addMeta("keywords", string);
    }

    public void addMeta(String string, String string2) {
        Element element = this.document.createElement("meta");
        element.setAttribute("name", string);
        element.setAttribute("content", string2);
        this.head.appendChild(element);
    }

    public void addStyleClass(Element element, String string, String string2) {
        String string3 = element.getAttribute("class");
        String string4 = this.getOrCreateCssClass(string, string2);
        String string5 = WordToHtmlUtils.isEmpty(string3) ? string4 : string3 + " " + string4;
        element.setAttribute("class", string5);
    }

    protected String buildStylesheet(Map<String, Map<String, String>> map) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map<String, String> map2 : map.values()) {
            for (Map.Entry<String, String> entry : map2.entrySet()) {
                String string = entry.getKey();
                String string2 = entry.getValue();
                stringBuilder.append(".");
                stringBuilder.append(string2);
                stringBuilder.append("{");
                stringBuilder.append(string);
                stringBuilder.append("}\n");
            }
        }
        String string = stringBuilder.toString();
        return string;
    }

    public Element createBlock() {
        return this.document.createElement("div");
    }

    public Element createBookmark(String string) {
        Element element = this.document.createElement("a");
        element.setAttribute("name", string);
        return element;
    }

    public Element createHeader1() {
        return this.document.createElement("h1");
    }

    public Element createHeader2() {
        return this.document.createElement("h2");
    }

    public Element createHyperlink(String string) {
        Element element = this.document.createElement("a");
        element.setAttribute("href", string);
        return element;
    }

    public Element createImage(String string) {
        Element element = this.document.createElement("img");
        element.setAttribute("src", string);
        return element;
    }

    public Element createLineBreak() {
        return this.document.createElement("br");
    }

    public Element createListItem() {
        return this.document.createElement("li");
    }

    public Element createOption(String string, boolean bl) {
        Element element = this.document.createElement("option");
        element.appendChild(this.createText(string));
        if (bl) {
            element.setAttribute("selected", "selected");
        }
        return element;
    }

    public Element createParagraph() {
        return this.document.createElement("p");
    }

    public Element createSelect() {
        Element element = this.document.createElement("select");
        return element;
    }

    public Element createTable() {
        return this.document.createElement("table");
    }

    public Element createTableBody() {
        return this.document.createElement("tbody");
    }

    public Element createTableCell() {
        return this.document.createElement("td");
    }

    public Element createTableColumn() {
        return this.document.createElement("col");
    }

    public Element createTableColumnGroup() {
        return this.document.createElement("colgroup");
    }

    public Element createTableHeader() {
        return this.document.createElement("thead");
    }

    public Element createTableHeaderCell() {
        return this.document.createElement("th");
    }

    public Element createTableRow() {
        return this.document.createElement("tr");
    }

    public Text createText(String string) {
        return this.document.createTextNode(string);
    }

    public Element createUnorderedList() {
        return this.document.createElement("ul");
    }

    public Element getBody() {
        return this.body;
    }

    public Document getDocument() {
        return this.document;
    }

    public Element getHead() {
        return this.head;
    }

    public String getOrCreateCssClass(String string, String string2) {
        Map<String, String> map;
        String string3;
        if (!this.stylesheet.containsKey(string)) {
            this.stylesheet.put(string, new LinkedHashMap(1));
        }
        if ((string3 = (map = this.stylesheet.get(string)).get(string2)) != null) {
            return string3;
        }
        String string4 = string + (map.size() + 1);
        map.put(string2, string4);
        return string4;
    }

    public String getTitle() {
        if (this.title == null) {
            return null;
        }
        return this.titleText.getTextContent();
    }

    public void setTitle(String string) {
        if (WordToHtmlUtils.isEmpty(string) && this.title != null) {
            this.head.removeChild(this.title);
            this.title = null;
            this.titleText = null;
        }
        if (this.title == null) {
            this.title = this.document.createElement("title");
            this.titleText = this.document.createTextNode(string);
            this.title.appendChild(this.titleText);
            this.head.appendChild(this.title);
        }
        this.titleText.setData(string);
    }

    public void updateStylesheet() {
        this.stylesheetElement.setTextContent(this.buildStylesheet(this.stylesheet));
    }
}

