/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf.converter;

import ai2.org.apache.poi.hwpf.HWPFDocument;
import ai2.org.apache.poi.hwpf.HWPFDocumentCore;
import ai2.org.apache.poi.hwpf.HWPFOldDocument;
import ai2.org.apache.poi.hwpf.OldWordFileFormatException;
import ai2.org.apache.poi.hwpf.converter.NumberFormatter;
import ai2.org.apache.poi.hwpf.converter.WordToFoUtils;
import ai2.org.apache.poi.hwpf.usermodel.BorderCode;
import ai2.org.apache.poi.hwpf.usermodel.HWPFList;
import ai2.org.apache.poi.hwpf.usermodel.Table;
import ai2.org.apache.poi.hwpf.usermodel.TableCell;
import ai2.org.apache.poi.hwpf.usermodel.TableRow;
import ai2.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai2.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import ai2.org.apache.poi.util.IOUtils;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AbstractWordUtils {
    static final String EMPTY = "";
    private static final POILogger logger = POILogFactory.getLogger(AbstractWordUtils.class);
    public static final float TWIPS_PER_INCH = 1440.0f;
    public static final int TWIPS_PER_PT = 20;

    static int[] buildTableCellEdgesArray(Table table) {
        int n;
        Object object;
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (int i = 0; i < table.numRows(); ++i) {
            object = table.getRow(i);
            for (n = 0; n < ((TableRow)object).numCells(); ++n) {
                TableCell tableCell = ((TableRow)object).getCell(n);
                treeSet.add(tableCell.getLeftEdge());
                treeSet.add(tableCell.getLeftEdge() + tableCell.getWidth());
            }
        }
        Integer[] integerArray = treeSet.toArray(new Integer[treeSet.size()]);
        object = new int[integerArray.length];
        for (n = 0; n < integerArray.length; ++n) {
            object[n] = integerArray[n];
        }
        return object;
    }

    static boolean canBeMerged(Node node, Node node2, String string) {
        if (node.getNodeType() != 1 || node2.getNodeType() != 1) {
            return false;
        }
        Element element = (Element)node;
        Element element2 = (Element)node2;
        if (!AbstractWordUtils.equals(string, element.getTagName()) || !AbstractWordUtils.equals(string, element2.getTagName())) {
            return false;
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        NamedNodeMap namedNodeMap2 = element2.getAttributes();
        if (namedNodeMap.getLength() != namedNodeMap2.getLength()) {
            return false;
        }
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            Attr attr2 = AbstractWordUtils.isNotEmpty(attr.getNamespaceURI()) ? (Attr)namedNodeMap2.getNamedItemNS(attr.getNamespaceURI(), attr.getLocalName()) : (Attr)namedNodeMap2.getNamedItem(attr.getName());
            if (attr2 != null && AbstractWordUtils.equals(attr.getTextContent(), attr2.getTextContent())) continue;
            return false;
        }
        return true;
    }

    static void compactChildNodesR(Element element, String string) {
        Node node;
        int n;
        NodeList nodeList = element.getChildNodes();
        for (n = 0; n < nodeList.getLength() - 1; ++n) {
            Node node2;
            node = nodeList.item(n);
            if (!WordToFoUtils.canBeMerged(node, node2 = nodeList.item(n + 1), string)) continue;
            while (node2.getChildNodes().getLength() > 0) {
                node.appendChild(node2.getFirstChild());
            }
            node2.getParentNode().removeChild(node2);
            --n;
        }
        nodeList = element.getChildNodes();
        for (n = 0; n < nodeList.getLength() - 1; ++n) {
            node = nodeList.item(n);
            if (!(node instanceof Element)) continue;
            AbstractWordUtils.compactChildNodesR((Element)node, string);
        }
    }

    static boolean equals(String string, String string2) {
        return string == null ? string2 == null : string.equals(string2);
    }

    public static String getBorderType(BorderCode borderCode) {
        if (borderCode == null) {
            throw new IllegalArgumentException("borderCode is null");
        }
        switch (borderCode.getBorderType()) {
            case 1: 
            case 2: {
                return "solid";
            }
            case 3: {
                return "double";
            }
            case 5: {
                return "solid";
            }
            case 6: {
                return "dotted";
            }
            case 7: 
            case 8: {
                return "dashed";
            }
            case 9: {
                return "dotted";
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return "double";
            }
            case 20: {
                return "solid";
            }
            case 21: {
                return "double";
            }
            case 22: {
                return "dashed";
            }
            case 23: {
                return "dashed";
            }
            case 24: {
                return "ridge";
            }
            case 25: {
                return "grooved";
            }
        }
        return "solid";
    }

    public static String getBorderWidth(BorderCode borderCode) {
        int n = borderCode.getLineWidth();
        int n2 = n / 8;
        int n3 = n - n2 * 8;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(n2);
        stringBuilder.append(".");
        stringBuilder.append(125 * n3);
        stringBuilder.append("pt");
        return stringBuilder.toString();
    }

    public static String getBulletText(NumberingState numberingState, HWPFList hWPFList, char c) {
        char[] cArray;
        StringBuffer stringBuffer = new StringBuffer();
        for (char c2 : cArray = hWPFList.getNumberText(c).toCharArray()) {
            if (c2 < '\t') {
                int n;
                int n2 = hWPFList.getLsid();
                String string = n2 + "#" + c2;
                if (!hWPFList.isStartAtOverriden(c2) && numberingState.levels.containsKey(string)) {
                    n = (Integer)numberingState.levels.get(string);
                    if (c == c2) {
                        numberingState.levels.put(string, ++n);
                    }
                } else {
                    n = hWPFList.getStartAt(c2);
                    numberingState.levels.put(string, n);
                }
                if (c == c2) {
                    for (int i = c2 + '\u0001'; i < 9; ++i) {
                        String string2 = n2 + "#" + i;
                        numberingState.levels.remove(string2);
                    }
                }
                stringBuffer.append(NumberFormatter.getNumber(n, hWPFList.getNumberFormat(c)));
                continue;
            }
            stringBuffer.append(c2);
        }
        byte by = hWPFList.getTypeOfCharFollowingTheNumber(c);
        switch (by) {
            case 0: {
                stringBuffer.append("\t");
                break;
            }
            case 1: {
                stringBuffer.append(" ");
                break;
            }
        }
        return stringBuffer.toString();
    }

    public static String getColor(int n) {
        switch (n) {
            case 1: {
                return "black";
            }
            case 2: {
                return "blue";
            }
            case 3: {
                return "cyan";
            }
            case 4: {
                return "green";
            }
            case 5: {
                return "magenta";
            }
            case 6: {
                return "red";
            }
            case 7: {
                return "yellow";
            }
            case 8: {
                return "white";
            }
            case 9: {
                return "darkblue";
            }
            case 10: {
                return "darkcyan";
            }
            case 11: {
                return "darkgreen";
            }
            case 12: {
                return "darkmagenta";
            }
            case 13: {
                return "darkred";
            }
            case 14: {
                return "darkyellow";
            }
            case 15: {
                return "darkgray";
            }
            case 16: {
                return "lightgray";
            }
        }
        return "black";
    }

    public static String getOpacity(int n) {
        int n2 = (int)(((long)n & 0xFF000000L) >>> 24);
        if (n2 == 0 || n2 == 255) {
            return ".0";
        }
        return EMPTY + (float)n2 / 255.0f;
    }

    public static String getColor24(int n) {
        if (n == -1) {
            throw new IllegalArgumentException("This colorref is empty");
        }
        int n2 = n & 0xFFFFFF;
        int n3 = (n2 & 0xFF) << 16 | n2 & 0xFF00 | (n2 & 0xFF0000) >> 16;
        switch (n3) {
            case 0xFFFFFF: {
                return "white";
            }
            case 0xC0C0C0: {
                return "silver";
            }
            case 0x808080: {
                return "gray";
            }
            case 0: {
                return "black";
            }
            case 0xFF0000: {
                return "red";
            }
            case 0x800000: {
                return "maroon";
            }
            case 0xFFFF00: {
                return "yellow";
            }
            case 0x808000: {
                return "olive";
            }
            case 65280: {
                return "lime";
            }
            case 32768: {
                return "green";
            }
            case 65535: {
                return "aqua";
            }
            case 32896: {
                return "teal";
            }
            case 255: {
                return "blue";
            }
            case 128: {
                return "navy";
            }
            case 0xFF00FF: {
                return "fuchsia";
            }
            case 0x800080: {
                return "purple";
            }
        }
        StringBuilder stringBuilder = new StringBuilder("#");
        String string = Integer.toHexString(n3);
        for (int i = string.length(); i < 6; ++i) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public static String getJustification(int n) {
        switch (n) {
            case 0: {
                return "start";
            }
            case 1: {
                return "center";
            }
            case 2: {
                return "end";
            }
            case 3: 
            case 4: {
                return "justify";
            }
            case 5: {
                return "center";
            }
            case 6: {
                return "left";
            }
            case 7: {
                return "start";
            }
            case 8: {
                return "end";
            }
            case 9: {
                return "justify";
            }
        }
        return EMPTY;
    }

    public static String getLanguage(int n) {
        switch (n) {
            case 1024: {
                return EMPTY;
            }
            case 1033: {
                return "en-us";
            }
            case 1049: {
                return "ru-ru";
            }
            case 2057: {
                return "en-uk";
            }
        }
        logger.log(5, "Uknown or unmapped language code: ", n);
        return EMPTY;
    }

    public static String getListItemNumberLabel(int n, int n2) {
        if (n2 != 0) {
            logger.log(3, new Object[]{"NYI: toListItemNumberLabel(): " + n2});
        }
        return String.valueOf(n);
    }

    static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    static boolean isNotEmpty(String string) {
        return !AbstractWordUtils.isEmpty(string);
    }

    public static HWPFDocumentCore loadDoc(DirectoryNode directoryNode) throws IOException {
        try {
            return new HWPFDocument(directoryNode);
        }
        catch (OldWordFileFormatException oldWordFileFormatException) {
            return new HWPFOldDocument(directoryNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HWPFDocumentCore loadDoc(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            HWPFDocumentCore hWPFDocumentCore = AbstractWordUtils.loadDoc(fileInputStream);
            return hWPFDocumentCore;
        }
        finally {
            IOUtils.closeQuietly(fileInputStream);
        }
    }

    public static HWPFDocumentCore loadDoc(InputStream inputStream) throws IOException {
        return AbstractWordUtils.loadDoc(HWPFDocumentCore.verifyAndBuildPOIFS(inputStream));
    }

    public static HWPFDocumentCore loadDoc(POIFSFileSystem pOIFSFileSystem) throws IOException {
        return AbstractWordUtils.loadDoc(pOIFSFileSystem.getRoot());
    }

    static String substringBeforeLast(String string, String string2) {
        if (AbstractWordUtils.isEmpty(string) || AbstractWordUtils.isEmpty(string2)) {
            return string;
        }
        int n = string.lastIndexOf(string2);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public static class NumberingState {
        private final Map<String, Integer> levels = new HashMap<String, Integer>();
    }
}

