/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf;

import ai2.org.apache.poi.hwpf.HWPFDocumentCore;
import ai2.org.apache.poi.hwpf.model.ComplexFileTable;
import ai2.org.apache.poi.hwpf.model.OldCHPBinTable;
import ai2.org.apache.poi.hwpf.model.OldPAPBinTable;
import ai2.org.apache.poi.hwpf.model.OldSectionTable;
import ai2.org.apache.poi.hwpf.model.PieceDescriptor;
import ai2.org.apache.poi.hwpf.model.TextPiece;
import ai2.org.apache.poi.hwpf.model.TextPieceTable;
import ai2.org.apache.poi.hwpf.usermodel.Range;
import ai2.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai2.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.OutputStream;

public class HWPFOldDocument
extends HWPFDocumentCore {
    private TextPieceTable tpt;
    private StringBuilder _text;

    public HWPFOldDocument(POIFSFileSystem pOIFSFileSystem) throws IOException {
        this(pOIFSFileSystem.getRoot());
    }

    @Deprecated
    public HWPFOldDocument(DirectoryNode directoryNode, POIFSFileSystem pOIFSFileSystem) throws IOException {
        this(directoryNode);
    }

    public HWPFOldDocument(DirectoryNode directoryNode) throws IOException {
        super(directoryNode);
        int n = LittleEndian.getInt(this._mainStream, 136);
        int n2 = LittleEndian.getInt(this._mainStream, 140);
        int n3 = LittleEndian.getInt(this._mainStream, 184);
        int n4 = LittleEndian.getInt(this._mainStream, 188);
        int n5 = LittleEndian.getInt(this._mainStream, 192);
        int n6 = LittleEndian.getInt(this._mainStream, 196);
        int n7 = LittleEndian.getInt(this._mainStream, 352);
        ComplexFileTable complexFileTable = null;
        StringBuffer stringBuffer = new StringBuffer();
        if (this._fib.getFibBase().isFComplex()) {
            complexFileTable = new ComplexFileTable(this._mainStream, this._mainStream, n7, this._fib.getFibBase().getFcMin());
            this.tpt = complexFileTable.getTextPieceTable();
            for (TextPiece textPiece : this.tpt.getTextPieces()) {
                stringBuffer.append((CharSequence)textPiece.getStringBuilder());
            }
        } else {
            PieceDescriptor pieceDescriptor = new PieceDescriptor(new byte[]{0, 0, 0, 0, 0, 127, 0, 0}, 0);
            pieceDescriptor.setFilePosition(this._fib.getFibBase().getFcMin());
            this.tpt = new TextPieceTable();
            byte[] byArray = new byte[this._fib.getFibBase().getFcMac() - this._fib.getFibBase().getFcMin()];
            System.arraycopy(this._mainStream, this._fib.getFibBase().getFcMin(), byArray, 0, byArray.length);
            TextPiece textPiece = new TextPiece(0, byArray.length, byArray, pieceDescriptor);
            this.tpt.add(textPiece);
            stringBuffer.append((CharSequence)textPiece.getStringBuilder());
        }
        this._text = this.tpt.getText();
        this._cbt = new OldCHPBinTable(this._mainStream, n3, n4, this._fib.getFibBase().getFcMin(), this.tpt);
        this._pbt = new OldPAPBinTable(this._mainStream, n5, n6, this._fib.getFibBase().getFcMin(), this.tpt);
        this._st = new OldSectionTable(this._mainStream, n, n2, this._fib.getFibBase().getFcMin(), this.tpt);
        boolean bl = false;
        try {
            bl = Boolean.parseBoolean(System.getProperty("ai2.org.apache.poi.hwpf.preserveBinTables"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            this._cbt.rebuild(complexFileTable);
            this._pbt.rebuild(this._text, complexFileTable);
        }
    }

    public Range getOverallRange() {
        return new Range(0, this._fib.getFibBase().getFcMac() - this._fib.getFibBase().getFcMin(), this);
    }

    public Range getRange() {
        return this.getOverallRange();
    }

    public TextPieceTable getTextTable() {
        return this.tpt;
    }

    public StringBuilder getText() {
        return this._text;
    }

    public void write(OutputStream outputStream) throws IOException {
        throw new IllegalStateException("Writing is not available for the older file formats");
    }
}

