/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hwpf;

import ai2.org.apache.poi.hwpf.HWPFDocumentCore;
import ai2.org.apache.poi.hwpf.OldWordFileFormatException;
import ai2.org.apache.poi.hwpf.model.BookmarksTables;
import ai2.org.apache.poi.hwpf.model.CHPBinTable;
import ai2.org.apache.poi.hwpf.model.ComplexFileTable;
import ai2.org.apache.poi.hwpf.model.DocumentProperties;
import ai2.org.apache.poi.hwpf.model.EscherRecordHolder;
import ai2.org.apache.poi.hwpf.model.FSPADocumentPart;
import ai2.org.apache.poi.hwpf.model.FSPATable;
import ai2.org.apache.poi.hwpf.model.FieldsTables;
import ai2.org.apache.poi.hwpf.model.FontTable;
import ai2.org.apache.poi.hwpf.model.ListTables;
import ai2.org.apache.poi.hwpf.model.NoteType;
import ai2.org.apache.poi.hwpf.model.NotesTables;
import ai2.org.apache.poi.hwpf.model.PAPBinTable;
import ai2.org.apache.poi.hwpf.model.PicturesTable;
import ai2.org.apache.poi.hwpf.model.RevisionMarkAuthorTable;
import ai2.org.apache.poi.hwpf.model.SavedByTable;
import ai2.org.apache.poi.hwpf.model.SectionTable;
import ai2.org.apache.poi.hwpf.model.ShapesTable;
import ai2.org.apache.poi.hwpf.model.SinglentonTextPiece;
import ai2.org.apache.poi.hwpf.model.StyleSheet;
import ai2.org.apache.poi.hwpf.model.SubdocumentType;
import ai2.org.apache.poi.hwpf.model.TextPieceTable;
import ai2.org.apache.poi.hwpf.model.io.HWPFFileSystem;
import ai2.org.apache.poi.hwpf.model.io.HWPFOutputStream;
import ai2.org.apache.poi.hwpf.usermodel.Bookmarks;
import ai2.org.apache.poi.hwpf.usermodel.BookmarksImpl;
import ai2.org.apache.poi.hwpf.usermodel.Fields;
import ai2.org.apache.poi.hwpf.usermodel.FieldsImpl;
import ai2.org.apache.poi.hwpf.usermodel.HWPFList;
import ai2.org.apache.poi.hwpf.usermodel.Notes;
import ai2.org.apache.poi.hwpf.usermodel.NotesImpl;
import ai2.org.apache.poi.hwpf.usermodel.OfficeDrawings;
import ai2.org.apache.poi.hwpf.usermodel.OfficeDrawingsImpl;
import ai2.org.apache.poi.hwpf.usermodel.Range;
import ai2.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai2.org.apache.poi.poifs.filesystem.DocumentEntry;
import ai2.org.apache.poi.poifs.filesystem.Entry;
import ai2.org.apache.poi.poifs.filesystem.EntryUtils;
import ai2.org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import ai2.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import ai2.org.apache.poi.util.Internal;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;

public final class HWPFDocument
extends HWPFDocumentCore {
    static final String PROPERTY_PRESERVE_BIN_TABLES = "ai2.org.apache.poi.hwpf.preserveBinTables";
    private static final String PROPERTY_PRESERVE_TEXT_TABLE = "ai2.org.apache.poi.hwpf.preserveTextTable";
    private static final String STREAM_DATA = "Data";
    private static final String STREAM_TABLE_0 = "0Table";
    private static final String STREAM_TABLE_1 = "1Table";
    protected byte[] _tableStream;
    protected byte[] _dataStream;
    protected DocumentProperties _dop;
    protected ComplexFileTable _cft;
    protected StringBuilder _text;
    protected SavedByTable _sbt;
    protected RevisionMarkAuthorTable _rmat;
    private FSPATable _fspaHeaders;
    private FSPATable _fspaMain;
    protected EscherRecordHolder _escherRecordHolder;
    protected PicturesTable _pictures;
    @Deprecated
    protected ShapesTable _officeArts;
    protected OfficeDrawingsImpl _officeDrawingsHeaders;
    protected OfficeDrawingsImpl _officeDrawingsMain;
    protected BookmarksTables _bookmarksTables;
    protected Bookmarks _bookmarks;
    protected NotesTables _endnotesTables = new NotesTables(NoteType.ENDNOTE);
    protected Notes _endnotes = new NotesImpl(this._endnotesTables);
    protected NotesTables _footnotesTables = new NotesTables(NoteType.FOOTNOTE);
    protected Notes _footnotes = new NotesImpl(this._footnotesTables);
    protected FieldsTables _fieldsTables;
    protected Fields _fields;

    protected HWPFDocument() {
        this._text = new StringBuilder("\r");
    }

    public HWPFDocument(InputStream inputStream) throws IOException {
        this(HWPFDocument.verifyAndBuildPOIFS(inputStream));
    }

    public HWPFDocument(POIFSFileSystem pOIFSFileSystem) throws IOException {
        this(pOIFSFileSystem.getRoot());
    }

    @Deprecated
    public HWPFDocument(DirectoryNode directoryNode, POIFSFileSystem pOIFSFileSystem) throws IOException {
        this(directoryNode);
    }

    public HWPFDocument(DirectoryNode directoryNode) throws IOException {
        super(directoryNode);
        DocumentEntry documentEntry;
        if (this._fib.getFibBase().getNFib() < 106) {
            throw new OldWordFileFormatException("The document is too old - Word 95 or older. Try HWPFOldDocument instead?");
        }
        String string = STREAM_TABLE_0;
        if (this._fib.getFibBase().isFWhichTblStm()) {
            string = STREAM_TABLE_1;
        }
        try {
            documentEntry = (DocumentEntry)directoryNode.getEntry(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalStateException("Table Stream '" + string + "' wasn't found - Either the document is corrupt, or is Word95 (or earlier)");
        }
        this._tableStream = new byte[documentEntry.getSize()];
        directoryNode.createDocumentInputStream(string).read(this._tableStream);
        this._fib.fillVariableFields(this._mainStream, this._tableStream);
        try {
            DocumentEntry documentEntry2 = (DocumentEntry)directoryNode.getEntry(STREAM_DATA);
            this._dataStream = new byte[documentEntry2.getSize()];
            directoryNode.createDocumentInputStream(STREAM_DATA).read(this._dataStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this._dataStream = new byte[0];
        }
        int n = 0;
        this._dop = new DocumentProperties(this._tableStream, this._fib.getFcDop(), this._fib.getLcbDop());
        this._cft = new ComplexFileTable(this._mainStream, this._tableStream, this._fib.getFcClx(), n);
        TextPieceTable textPieceTable = this._cft.getTextPieceTable();
        this._cbt = new CHPBinTable(this._mainStream, this._tableStream, this._fib.getFcPlcfbteChpx(), this._fib.getLcbPlcfbteChpx(), textPieceTable);
        this._pbt = new PAPBinTable(this._mainStream, this._tableStream, this._dataStream, this._fib.getFcPlcfbtePapx(), this._fib.getLcbPlcfbtePapx(), textPieceTable);
        this._text = textPieceTable.getText();
        boolean bl = false;
        try {
            bl = Boolean.parseBoolean(System.getProperty(PROPERTY_PRESERVE_BIN_TABLES));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            this._cbt.rebuild(this._cft);
            this._pbt.rebuild(this._text, this._cft);
        }
        boolean bl2 = false;
        try {
            bl2 = Boolean.parseBoolean(System.getProperty(PROPERTY_PRESERVE_TEXT_TABLE));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl2) {
            this._cft = new ComplexFileTable();
            textPieceTable = this._cft.getTextPieceTable();
            SinglentonTextPiece singlentonTextPiece = new SinglentonTextPiece(this._text);
            textPieceTable.add(singlentonTextPiece);
            this._text = singlentonTextPiece.getStringBuilder();
        }
        this._fspaHeaders = new FSPATable(this._tableStream, this._fib, FSPADocumentPart.HEADER);
        this._fspaMain = new FSPATable(this._tableStream, this._fib, FSPADocumentPart.MAIN);
        this._escherRecordHolder = this._fib.getFcDggInfo() != 0 ? new EscherRecordHolder(this._tableStream, this._fib.getFcDggInfo(), this._fib.getLcbDggInfo()) : new EscherRecordHolder();
        this._pictures = new PicturesTable(this, this._dataStream, this._mainStream, this._fspaMain, this._escherRecordHolder);
        this._officeArts = new ShapesTable(this._tableStream, this._fib);
        this._officeDrawingsHeaders = new OfficeDrawingsImpl(this._fspaHeaders, this._escherRecordHolder, this._mainStream);
        this._officeDrawingsMain = new OfficeDrawingsImpl(this._fspaMain, this._escherRecordHolder, this._mainStream);
        this._st = new SectionTable(this._mainStream, this._tableStream, this._fib.getFcPlcfsed(), this._fib.getLcbPlcfsed(), n, textPieceTable, this._fib.getSubdocumentTextStreamLength(SubdocumentType.MAIN));
        this._ss = new StyleSheet(this._tableStream, this._fib.getFcStshf());
        this._ft = new FontTable(this._tableStream, this._fib.getFcSttbfffn(), this._fib.getLcbSttbfffn());
        int n2 = this._fib.getFcPlfLst();
        if (n2 != 0 && this._fib.getLcbPlfLst() != 0) {
            this._lt = new ListTables(this._tableStream, n2, this._fib.getFcPlfLfo(), this._fib.getLcbPlfLfo());
        }
        int n3 = this._fib.getFcSttbSavedBy();
        int n4 = this._fib.getLcbSttbSavedBy();
        if (n3 != 0 && n4 != 0) {
            this._sbt = new SavedByTable(this._tableStream, n3, n4);
        }
        int n5 = this._fib.getFcSttbfRMark();
        int n6 = this._fib.getLcbSttbfRMark();
        if (n5 != 0 && n6 != 0) {
            this._rmat = new RevisionMarkAuthorTable(this._tableStream, n5, n6);
        }
        this._bookmarksTables = new BookmarksTables(this._tableStream, this._fib);
        this._bookmarks = new BookmarksImpl(this._bookmarksTables);
        this._endnotesTables = new NotesTables(NoteType.ENDNOTE, this._tableStream, this._fib);
        this._endnotes = new NotesImpl(this._endnotesTables);
        this._footnotesTables = new NotesTables(NoteType.FOOTNOTE, this._tableStream, this._fib);
        this._footnotes = new NotesImpl(this._footnotesTables);
        this._fieldsTables = new FieldsTables(this._tableStream, this._fib);
        this._fields = new FieldsImpl(this._fieldsTables);
    }

    @Internal
    public TextPieceTable getTextTable() {
        return this._cft.getTextPieceTable();
    }

    @Internal
    public StringBuilder getText() {
        return this._text;
    }

    public DocumentProperties getDocProperties() {
        return this._dop;
    }

    public Range getOverallRange() {
        return new Range(0, this._text.length(), this);
    }

    public Range getRange() {
        return this.getRange(SubdocumentType.MAIN);
    }

    private Range getRange(SubdocumentType subdocumentType) {
        int n = 0;
        for (SubdocumentType subdocumentType2 : SubdocumentType.ORDERED) {
            int n2 = this.getFileInformationBlock().getSubdocumentTextStreamLength(subdocumentType2);
            if (subdocumentType == subdocumentType2) {
                return new Range(n, n + n2, this);
            }
            n += n2;
        }
        throw new UnsupportedOperationException("Subdocument type not supported: " + (Object)((Object)subdocumentType));
    }

    public Range getFootnoteRange() {
        return this.getRange(SubdocumentType.FOOTNOTE);
    }

    public Range getEndnoteRange() {
        return this.getRange(SubdocumentType.ENDNOTE);
    }

    public Range getCommentsRange() {
        return this.getRange(SubdocumentType.ANNOTATION);
    }

    public Range getMainTextboxRange() {
        return this.getRange(SubdocumentType.TEXTBOX);
    }

    public Range getHeaderStoryRange() {
        return this.getRange(SubdocumentType.HEADER);
    }

    public int characterLength() {
        return this._text.length();
    }

    @Internal
    public SavedByTable getSavedByTable() {
        return this._sbt;
    }

    @Internal
    public RevisionMarkAuthorTable getRevisionMarkAuthorTable() {
        return this._rmat;
    }

    public PicturesTable getPicturesTable() {
        return this._pictures;
    }

    @Internal
    public EscherRecordHolder getEscherRecordHolder() {
        return this._escherRecordHolder;
    }

    @Deprecated
    @Internal
    public ShapesTable getShapesTable() {
        return this._officeArts;
    }

    public OfficeDrawings getOfficeDrawingsHeaders() {
        return this._officeDrawingsHeaders;
    }

    public OfficeDrawings getOfficeDrawingsMain() {
        return this._officeDrawingsMain;
    }

    public Bookmarks getBookmarks() {
        return this._bookmarks;
    }

    public Notes getEndnotes() {
        return this._endnotes;
    }

    public Notes getFootnotes() {
        return this._footnotes;
    }

    @Deprecated
    @Internal
    public FieldsTables getFieldsTables() {
        return this._fieldsTables;
    }

    public Fields getFields() {
        return this._fields;
    }

    public void write(OutputStream outputStream) throws IOException {
        Object object;
        byte[] byArray;
        byte[] byArray2;
        HWPFFileSystem hWPFFileSystem = new HWPFFileSystem();
        HWPFOutputStream hWPFOutputStream = hWPFFileSystem.getStream("WordDocument");
        HWPFOutputStream hWPFOutputStream2 = hWPFFileSystem.getStream(STREAM_TABLE_1);
        int n = 0;
        this._fib.clearOffsetsSizes();
        int n2 = this._fib.getSize();
        n2 += 512 - n2 % 512;
        byte[] byArray3 = new byte[n2];
        hWPFOutputStream.write(byArray3);
        int n3 = hWPFOutputStream.getOffset();
        this._fib.setFcStshf(n);
        this._ss.writeTo(hWPFOutputStream2);
        this._fib.setLcbStshf(hWPFOutputStream2.getOffset() - n);
        n = hWPFOutputStream2.getOffset();
        int n4 = n3;
        this._fib.setFcClx(n);
        this._cft.writeTo(hWPFOutputStream, hWPFOutputStream2);
        this._fib.setLcbClx(hWPFOutputStream2.getOffset() - n);
        n = hWPFOutputStream2.getOffset();
        int n5 = hWPFOutputStream.getOffset();
        this._fib.setFcDop(n);
        this._dop.writeTo(hWPFOutputStream2);
        this._fib.setLcbDop(hWPFOutputStream2.getOffset() - n);
        n = hWPFOutputStream2.getOffset();
        if (this._bookmarksTables != null) {
            this._bookmarksTables.writePlcfBkmkf(this._fib, hWPFOutputStream2);
            n = hWPFOutputStream2.getOffset();
        }
        if (this._bookmarksTables != null) {
            this._bookmarksTables.writePlcfBkmkl(this._fib, hWPFOutputStream2);
            n = hWPFOutputStream2.getOffset();
        }
        this._fib.setFcPlcfbteChpx(n);
        this._cbt.writeTo(hWPFOutputStream, hWPFOutputStream2, n4, this._cft.getTextPieceTable());
        this._fib.setLcbPlcfbteChpx(hWPFOutputStream2.getOffset() - n);
        n = hWPFOutputStream2.getOffset();
        this._fib.setFcPlcfbtePapx(n);
        this._pbt.writeTo(hWPFOutputStream, hWPFOutputStream2, this._cft.getTextPieceTable());
        this._fib.setLcbPlcfbtePapx(hWPFOutputStream2.getOffset() - n);
        n = hWPFOutputStream2.getOffset();
        this._endnotesTables.writeRef(this._fib, hWPFOutputStream2);
        this._endnotesTables.writeTxt(this._fib, hWPFOutputStream2);
        n = hWPFOutputStream2.getOffset();
        if (this._fieldsTables != null) {
            this._fieldsTables.write(this._fib, hWPFOutputStream2);
            n = hWPFOutputStream2.getOffset();
        }
        this._footnotesTables.writeRef(this._fib, hWPFOutputStream2);
        this._footnotesTables.writeTxt(this._fib, hWPFOutputStream2);
        n = hWPFOutputStream2.getOffset();
        this._fib.setFcPlcfsed(n);
        this._st.writeTo(hWPFOutputStream, hWPFOutputStream2);
        this._fib.setLcbPlcfsed(hWPFOutputStream2.getOffset() - n);
        n = hWPFOutputStream2.getOffset();
        if (this._lt != null) {
            this._lt.writeListDataTo(this._fib, hWPFOutputStream2);
            n = hWPFOutputStream2.getOffset();
            this._lt.writeListOverridesTo(this._fib, hWPFOutputStream2);
            n = hWPFOutputStream2.getOffset();
        }
        if (this._bookmarksTables != null) {
            this._bookmarksTables.writeSttbfBkmk(this._fib, hWPFOutputStream2);
            n = hWPFOutputStream2.getOffset();
        }
        if (this._sbt != null) {
            this._fib.setFcSttbSavedBy(n);
            this._sbt.writeTo(hWPFOutputStream2);
            this._fib.setLcbSttbSavedBy(hWPFOutputStream2.getOffset() - n);
            n = hWPFOutputStream2.getOffset();
        }
        if (this._rmat != null) {
            this._fib.setFcSttbfRMark(n);
            this._rmat.writeTo(hWPFOutputStream2);
            this._fib.setLcbSttbfRMark(hWPFOutputStream2.getOffset() - n);
            n = hWPFOutputStream2.getOffset();
        }
        this._fib.setFcSttbfffn(n);
        this._ft.writeTo(hWPFOutputStream2);
        this._fib.setLcbSttbfffn(hWPFOutputStream2.getOffset() - n);
        n = hWPFOutputStream2.getOffset();
        this._fib.getFibBase().setFcMin(n4);
        this._fib.getFibBase().setFcMac(n5);
        this._fib.setCbMac(hWPFOutputStream.getOffset());
        byte[] byArray4 = hWPFOutputStream.toByteArray();
        if (byArray4.length < 4096) {
            byArray2 = new byte[4096];
            System.arraycopy(byArray4, 0, byArray2, 0, byArray4.length);
            byArray4 = byArray2;
        }
        this._fib.getFibBase().setFWhichTblStm(true);
        this._fib.writeTo(byArray4, hWPFOutputStream2);
        byArray2 = hWPFOutputStream2.toByteArray();
        if (byArray2.length < 4096) {
            byArray = new byte[4096];
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
            byArray2 = byArray;
        }
        if ((byArray = this._dataStream) == null) {
            byArray = new byte[4096];
        }
        if (byArray.length < 4096) {
            object = new byte[4096];
            System.arraycopy(byArray, 0, object, 0, byArray.length);
            byArray = object;
        }
        object = new NPOIFSFileSystem();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        Iterator<Entry> iterator = this.directory.getEntries();
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            if (entry.getName().equals("WordDocument")) {
                if (bl) continue;
                ((NPOIFSFileSystem)object).createDocument(new ByteArrayInputStream(byArray4), "WordDocument");
                bl = true;
                continue;
            }
            if (entry.getName().equals("ObjectPool")) {
                if (bl3) continue;
                this._objectPool.writeTo(((NPOIFSFileSystem)object).getRoot());
                bl3 = true;
                continue;
            }
            if (entry.getName().equals(STREAM_TABLE_0) || entry.getName().equals(STREAM_TABLE_1)) {
                if (bl4) continue;
                ((NPOIFSFileSystem)object).createDocument(new ByteArrayInputStream(byArray2), STREAM_TABLE_1);
                bl4 = true;
                continue;
            }
            if (entry.getName().equals("\u0005SummaryInformation") || entry.getName().equals("\u0005DocumentSummaryInformation")) {
                if (bl5) continue;
                this.writeProperties((NPOIFSFileSystem)object);
                bl5 = true;
                continue;
            }
            if (entry.getName().equals(STREAM_DATA)) {
                if (bl2) continue;
                ((NPOIFSFileSystem)object).createDocument(new ByteArrayInputStream(byArray), STREAM_DATA);
                bl2 = true;
                continue;
            }
            EntryUtils.copyNodeRecursively(entry, ((NPOIFSFileSystem)object).getRoot());
        }
        if (!bl) {
            ((NPOIFSFileSystem)object).createDocument(new ByteArrayInputStream(byArray4), "WordDocument");
        }
        if (!bl4) {
            ((NPOIFSFileSystem)object).createDocument(new ByteArrayInputStream(byArray2), STREAM_TABLE_1);
        }
        if (!bl5) {
            this.writeProperties((NPOIFSFileSystem)object);
        }
        if (!bl2) {
            ((NPOIFSFileSystem)object).createDocument(new ByteArrayInputStream(byArray), STREAM_DATA);
        }
        if (!bl3) {
            this._objectPool.writeTo(((NPOIFSFileSystem)object).getRoot());
        }
        ((NPOIFSFileSystem)object).writeFilesystem(outputStream);
        this.directory = ((NPOIFSFileSystem)object).getRoot();
        this.directory = ((NPOIFSFileSystem)object).getRoot();
        this._tableStream = hWPFOutputStream2.toByteArray();
        this._dataStream = byArray;
    }

    @Internal
    public byte[] getDataStream() {
        return this._dataStream;
    }

    @Internal
    public byte[] getTableStream() {
        return this._tableStream;
    }

    public int registerList(HWPFList hWPFList) {
        if (this._lt == null) {
            this._lt = new ListTables();
        }
        return this._lt.addList(hWPFList.getListData(), hWPFList.getLFO(), hWPFList.getLFOData());
    }

    public void delete(int n, int n2) {
        Range range = new Range(n, n + n2, this);
        range.delete();
    }
}

