/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.usermodel;

import ai2.org.apache.poi.ddf.DefaultEscherRecordFactory;
import ai2.org.apache.poi.ddf.EscherBoolProperty;
import ai2.org.apache.poi.ddf.EscherClientDataRecord;
import ai2.org.apache.poi.ddf.EscherContainerRecord;
import ai2.org.apache.poi.ddf.EscherOptRecord;
import ai2.org.apache.poi.ddf.EscherRGBProperty;
import ai2.org.apache.poi.ddf.EscherRecord;
import ai2.org.apache.poi.ddf.EscherSimpleProperty;
import ai2.org.apache.poi.ddf.EscherSpRecord;
import ai2.org.apache.poi.ddf.EscherTextboxRecord;
import ai2.org.apache.poi.hssf.record.CommonObjectDataSubRecord;
import ai2.org.apache.poi.hssf.record.EndSubRecord;
import ai2.org.apache.poi.hssf.record.EscherAggregate;
import ai2.org.apache.poi.hssf.record.ObjRecord;
import ai2.org.apache.poi.hssf.record.TextObjectRecord;
import ai2.org.apache.poi.hssf.usermodel.HSSFAnchor;
import ai2.org.apache.poi.hssf.usermodel.HSSFPatriarch;
import ai2.org.apache.poi.hssf.usermodel.HSSFRichTextString;
import ai2.org.apache.poi.hssf.usermodel.HSSFShape;
import ai2.org.apache.poi.hssf.usermodel.HSSFSimpleShape;

public class HSSFTextbox
extends HSSFSimpleShape {
    public static final short OBJECT_TYPE_TEXT = 6;
    public static final short HORIZONTAL_ALIGNMENT_LEFT = 1;
    public static final short HORIZONTAL_ALIGNMENT_CENTERED = 2;
    public static final short HORIZONTAL_ALIGNMENT_RIGHT = 3;
    public static final short HORIZONTAL_ALIGNMENT_JUSTIFIED = 4;
    public static final short HORIZONTAL_ALIGNMENT_DISTRIBUTED = 7;
    public static final short VERTICAL_ALIGNMENT_TOP = 1;
    public static final short VERTICAL_ALIGNMENT_CENTER = 2;
    public static final short VERTICAL_ALIGNMENT_BOTTOM = 3;
    public static final short VERTICAL_ALIGNMENT_JUSTIFY = 4;
    public static final short VERTICAL_ALIGNMENT_DISTRIBUTED = 7;
    HSSFRichTextString string = new HSSFRichTextString("");

    public HSSFTextbox(EscherContainerRecord escherContainerRecord, ObjRecord objRecord, TextObjectRecord textObjectRecord) {
        super(escherContainerRecord, objRecord, textObjectRecord);
    }

    public HSSFTextbox(HSSFShape hSSFShape, HSSFAnchor hSSFAnchor) {
        super(hSSFShape, hSSFAnchor);
        this.setHorizontalAlignment((short)1);
        this.setVerticalAlignment((short)1);
        this.setString(new HSSFRichTextString(""));
    }

    protected ObjRecord createObjRecord() {
        ObjRecord objRecord = new ObjRecord();
        CommonObjectDataSubRecord commonObjectDataSubRecord = new CommonObjectDataSubRecord();
        commonObjectDataSubRecord.setObjectType((short)6);
        commonObjectDataSubRecord.setLocked(true);
        commonObjectDataSubRecord.setPrintable(true);
        commonObjectDataSubRecord.setAutofill(true);
        commonObjectDataSubRecord.setAutoline(true);
        EndSubRecord endSubRecord = new EndSubRecord();
        objRecord.addSubRecord(commonObjectDataSubRecord);
        objRecord.addSubRecord(endSubRecord);
        return objRecord;
    }

    protected EscherContainerRecord createSpContainer() {
        EscherContainerRecord escherContainerRecord = new EscherContainerRecord();
        EscherSpRecord escherSpRecord = new EscherSpRecord();
        EscherOptRecord escherOptRecord = new EscherOptRecord();
        EscherClientDataRecord escherClientDataRecord = new EscherClientDataRecord();
        EscherTextboxRecord escherTextboxRecord = new EscherTextboxRecord();
        escherContainerRecord.setRecordId((short)-4092);
        escherContainerRecord.setOptions((short)15);
        escherSpRecord.setRecordId((short)-4086);
        escherSpRecord.setOptions((short)3234);
        escherSpRecord.setFlags(2560);
        escherOptRecord.setRecordId((short)-4085);
        escherOptRecord.addEscherProperty(new EscherSimpleProperty(128, 0));
        escherOptRecord.addEscherProperty(new EscherSimpleProperty(133, 0));
        escherOptRecord.addEscherProperty(new EscherSimpleProperty(135, 0));
        escherOptRecord.addEscherProperty(new EscherSimpleProperty(959, 524288));
        escherOptRecord.addEscherProperty(new EscherSimpleProperty(129, 0));
        escherOptRecord.addEscherProperty(new EscherSimpleProperty(131, 0));
        escherOptRecord.addEscherProperty(new EscherSimpleProperty(130, 0));
        escherOptRecord.addEscherProperty(new EscherSimpleProperty(132, 0));
        escherOptRecord.setEscherProperty(new EscherSimpleProperty(462, 0));
        escherOptRecord.setEscherProperty(new EscherBoolProperty(511, 524296));
        escherOptRecord.setEscherProperty(new EscherSimpleProperty(459, 9525));
        escherOptRecord.setEscherProperty(new EscherRGBProperty(385, 0x8000009));
        escherOptRecord.setEscherProperty(new EscherRGBProperty(448, 0x8000040));
        escherOptRecord.setEscherProperty(new EscherBoolProperty(447, 65536));
        escherOptRecord.setEscherProperty(new EscherBoolProperty(959, 524288));
        EscherRecord escherRecord = this.getAnchor().getEscherAnchor();
        escherClientDataRecord.setRecordId((short)-4079);
        escherClientDataRecord.setOptions((short)0);
        escherTextboxRecord.setRecordId((short)-4083);
        escherTextboxRecord.setOptions((short)0);
        escherContainerRecord.addChildRecord(escherSpRecord);
        escherContainerRecord.addChildRecord(escherOptRecord);
        escherContainerRecord.addChildRecord(escherRecord);
        escherContainerRecord.addChildRecord(escherClientDataRecord);
        escherContainerRecord.addChildRecord(escherTextboxRecord);
        return escherContainerRecord;
    }

    void afterInsert(HSSFPatriarch hSSFPatriarch) {
        EscherAggregate escherAggregate = hSSFPatriarch._getBoundAggregate();
        escherAggregate.associateShapeToObjRecord((EscherRecord)this.getEscherContainer().getChildById((short)-4079), this.getObjRecord());
        if (this.getTextObjectRecord() != null) {
            escherAggregate.associateShapeToObjRecord((EscherRecord)this.getEscherContainer().getChildById((short)-4083), this.getTextObjectRecord());
        }
    }

    public int getMarginLeft() {
        EscherSimpleProperty escherSimpleProperty = (EscherSimpleProperty)this.getOptRecord().lookup(129);
        return escherSimpleProperty == null ? 0 : escherSimpleProperty.getPropertyValue();
    }

    public void setMarginLeft(int n) {
        this.setPropertyValue(new EscherSimpleProperty(129, n));
    }

    public int getMarginRight() {
        EscherSimpleProperty escherSimpleProperty = (EscherSimpleProperty)this.getOptRecord().lookup(131);
        return escherSimpleProperty == null ? 0 : escherSimpleProperty.getPropertyValue();
    }

    public void setMarginRight(int n) {
        this.setPropertyValue(new EscherSimpleProperty(131, n));
    }

    public int getMarginTop() {
        EscherSimpleProperty escherSimpleProperty = (EscherSimpleProperty)this.getOptRecord().lookup(130);
        return escherSimpleProperty == null ? 0 : escherSimpleProperty.getPropertyValue();
    }

    public void setMarginTop(int n) {
        this.setPropertyValue(new EscherSimpleProperty(130, n));
    }

    public int getMarginBottom() {
        EscherSimpleProperty escherSimpleProperty = (EscherSimpleProperty)this.getOptRecord().lookup(132);
        return escherSimpleProperty == null ? 0 : escherSimpleProperty.getPropertyValue();
    }

    public void setMarginBottom(int n) {
        this.setPropertyValue(new EscherSimpleProperty(132, n));
    }

    public short getHorizontalAlignment() {
        return (short)this.getTextObjectRecord().getHorizontalTextAlignment();
    }

    public void setHorizontalAlignment(short s) {
        this.getTextObjectRecord().setHorizontalTextAlignment(s);
    }

    public short getVerticalAlignment() {
        return (short)this.getTextObjectRecord().getVerticalTextAlignment();
    }

    public void setVerticalAlignment(short s) {
        this.getTextObjectRecord().setVerticalTextAlignment(s);
    }

    public void setShapeType(int n) {
        throw new IllegalStateException("Shape type can not be changed in " + this.getClass().getSimpleName());
    }

    protected HSSFShape cloneShape() {
        TextObjectRecord textObjectRecord = this.getTextObjectRecord() == null ? null : (TextObjectRecord)this.getTextObjectRecord().cloneViaReserialise();
        EscherContainerRecord escherContainerRecord = new EscherContainerRecord();
        byte[] byArray = this.getEscherContainer().serialize();
        escherContainerRecord.fillFields(byArray, 0, new DefaultEscherRecordFactory());
        ObjRecord objRecord = (ObjRecord)this.getObjRecord().cloneViaReserialise();
        return new HSSFTextbox(escherContainerRecord, objRecord, textObjectRecord);
    }

    protected void afterRemove(HSSFPatriarch hSSFPatriarch) {
        hSSFPatriarch._getBoundAggregate().removeShapeToObjRecord((EscherRecord)this.getEscherContainer().getChildById((short)-4079));
        hSSFPatriarch._getBoundAggregate().removeShapeToObjRecord((EscherRecord)this.getEscherContainer().getChildById((short)-4083));
    }
}

