/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.usermodel;

import ai2.org.apache.poi.hssf.record.CFRule12Record;
import ai2.org.apache.poi.hssf.record.CFRuleBase;
import ai2.org.apache.poi.hssf.record.CFRuleRecord;
import ai2.org.apache.poi.hssf.record.aggregates.CFRecordsAggregate;
import ai2.org.apache.poi.hssf.record.aggregates.ConditionalFormattingTable;
import ai2.org.apache.poi.hssf.usermodel.HSSFConditionalFormatting;
import ai2.org.apache.poi.hssf.usermodel.HSSFConditionalFormattingRule;
import ai2.org.apache.poi.hssf.usermodel.HSSFExtendedColor;
import ai2.org.apache.poi.hssf.usermodel.HSSFSheet;
import ai2.org.apache.poi.ss.SpreadsheetVersion;
import ai2.org.apache.poi.ss.usermodel.ConditionalFormatting;
import ai2.org.apache.poi.ss.usermodel.ConditionalFormattingRule;
import ai2.org.apache.poi.ss.usermodel.ExtendedColor;
import ai2.org.apache.poi.ss.usermodel.IconMultiStateFormatting;
import ai2.org.apache.poi.ss.usermodel.SheetConditionalFormatting;
import ai2.org.apache.poi.ss.util.CellRangeAddress;
import ai2.org.apache.poi.ss.util.Region;

public final class HSSFSheetConditionalFormatting
implements SheetConditionalFormatting {
    private final HSSFSheet _sheet;
    private final ConditionalFormattingTable _conditionalFormattingTable;

    HSSFSheetConditionalFormatting(HSSFSheet hSSFSheet) {
        this._sheet = hSSFSheet;
        this._conditionalFormattingTable = hSSFSheet.getSheet().getConditionalFormattingTable();
    }

    public HSSFConditionalFormattingRule createConditionalFormattingRule(byte by, String string, String string2) {
        CFRuleRecord cFRuleRecord = CFRuleRecord.create(this._sheet, by, string, string2);
        return new HSSFConditionalFormattingRule(this._sheet, cFRuleRecord);
    }

    public HSSFConditionalFormattingRule createConditionalFormattingRule(byte by, String string) {
        CFRuleRecord cFRuleRecord = CFRuleRecord.create(this._sheet, by, string, null);
        return new HSSFConditionalFormattingRule(this._sheet, cFRuleRecord);
    }

    public HSSFConditionalFormattingRule createConditionalFormattingRule(String string) {
        CFRuleRecord cFRuleRecord = CFRuleRecord.create(this._sheet, string);
        return new HSSFConditionalFormattingRule(this._sheet, cFRuleRecord);
    }

    public HSSFConditionalFormattingRule createConditionalFormattingRule(IconMultiStateFormatting.IconSet iconSet) {
        CFRule12Record cFRule12Record = CFRule12Record.create(this._sheet, iconSet);
        return new HSSFConditionalFormattingRule(this._sheet, cFRule12Record);
    }

    public HSSFConditionalFormattingRule createConditionalFormattingRule(HSSFExtendedColor hSSFExtendedColor) {
        CFRule12Record cFRule12Record = CFRule12Record.create(this._sheet, hSSFExtendedColor.getExtendedColor());
        return new HSSFConditionalFormattingRule(this._sheet, cFRule12Record);
    }

    public HSSFConditionalFormattingRule createConditionalFormattingRule(ExtendedColor extendedColor) {
        return this.createConditionalFormattingRule((HSSFExtendedColor)extendedColor);
    }

    public HSSFConditionalFormattingRule createConditionalFormattingColorScaleRule() {
        CFRule12Record cFRule12Record = CFRule12Record.createColorScale(this._sheet);
        return new HSSFConditionalFormattingRule(this._sheet, cFRule12Record);
    }

    public int addConditionalFormatting(HSSFConditionalFormatting hSSFConditionalFormatting) {
        CFRecordsAggregate cFRecordsAggregate = hSSFConditionalFormatting.getCFRecordsAggregate().cloneCFAggregate();
        return this._conditionalFormattingTable.add(cFRecordsAggregate);
    }

    public int addConditionalFormatting(ConditionalFormatting conditionalFormatting) {
        return this.addConditionalFormatting((HSSFConditionalFormatting)conditionalFormatting);
    }

    public int addConditionalFormatting(Region[] regionArray, HSSFConditionalFormattingRule[] hSSFConditionalFormattingRuleArray) {
        return this.addConditionalFormatting(Region.convertRegionsToCellRanges(regionArray), hSSFConditionalFormattingRuleArray);
    }

    public int addConditionalFormatting(CellRangeAddress[] cellRangeAddressArray, HSSFConditionalFormattingRule[] hSSFConditionalFormattingRuleArray) {
        if (cellRangeAddressArray == null) {
            throw new IllegalArgumentException("regions must not be null");
        }
        for (CellRangeAddress cellRangeAddress : cellRangeAddressArray) {
            cellRangeAddress.validate(SpreadsheetVersion.EXCEL97);
        }
        if (hSSFConditionalFormattingRuleArray == null) {
            throw new IllegalArgumentException("cfRules must not be null");
        }
        if (hSSFConditionalFormattingRuleArray.length == 0) {
            throw new IllegalArgumentException("cfRules must not be empty");
        }
        if (hSSFConditionalFormattingRuleArray.length > 3) {
            throw new IllegalArgumentException("Number of rules must not exceed 3");
        }
        Object[] objectArray = new CFRuleBase[hSSFConditionalFormattingRuleArray.length];
        for (int i = 0; i != hSSFConditionalFormattingRuleArray.length; ++i) {
            objectArray[i] = hSSFConditionalFormattingRuleArray[i].getCfRuleRecord();
        }
        CFRecordsAggregate cFRecordsAggregate = new CFRecordsAggregate(cellRangeAddressArray, (CFRuleBase[])objectArray);
        return this._conditionalFormattingTable.add(cFRecordsAggregate);
    }

    public int addConditionalFormatting(CellRangeAddress[] cellRangeAddressArray, ConditionalFormattingRule[] conditionalFormattingRuleArray) {
        HSSFConditionalFormattingRule[] hSSFConditionalFormattingRuleArray;
        if (conditionalFormattingRuleArray instanceof HSSFConditionalFormattingRule[]) {
            hSSFConditionalFormattingRuleArray = (HSSFConditionalFormattingRule[])conditionalFormattingRuleArray;
        } else {
            hSSFConditionalFormattingRuleArray = new HSSFConditionalFormattingRule[conditionalFormattingRuleArray.length];
            System.arraycopy(conditionalFormattingRuleArray, 0, hSSFConditionalFormattingRuleArray, 0, hSSFConditionalFormattingRuleArray.length);
        }
        return this.addConditionalFormatting(cellRangeAddressArray, hSSFConditionalFormattingRuleArray);
    }

    public int addConditionalFormatting(CellRangeAddress[] cellRangeAddressArray, HSSFConditionalFormattingRule hSSFConditionalFormattingRule) {
        HSSFConditionalFormattingRule[] hSSFConditionalFormattingRuleArray;
        if (hSSFConditionalFormattingRule == null) {
            hSSFConditionalFormattingRuleArray = null;
        } else {
            HSSFConditionalFormattingRule[] hSSFConditionalFormattingRuleArray2 = new HSSFConditionalFormattingRule[1];
            hSSFConditionalFormattingRuleArray = hSSFConditionalFormattingRuleArray2;
            hSSFConditionalFormattingRuleArray2[0] = hSSFConditionalFormattingRule;
        }
        return this.addConditionalFormatting(cellRangeAddressArray, hSSFConditionalFormattingRuleArray);
    }

    public int addConditionalFormatting(CellRangeAddress[] cellRangeAddressArray, ConditionalFormattingRule conditionalFormattingRule) {
        return this.addConditionalFormatting(cellRangeAddressArray, (HSSFConditionalFormattingRule)conditionalFormattingRule);
    }

    public int addConditionalFormatting(CellRangeAddress[] cellRangeAddressArray, HSSFConditionalFormattingRule hSSFConditionalFormattingRule, HSSFConditionalFormattingRule hSSFConditionalFormattingRule2) {
        return this.addConditionalFormatting(cellRangeAddressArray, new HSSFConditionalFormattingRule[]{hSSFConditionalFormattingRule, hSSFConditionalFormattingRule2});
    }

    public int addConditionalFormatting(CellRangeAddress[] cellRangeAddressArray, ConditionalFormattingRule conditionalFormattingRule, ConditionalFormattingRule conditionalFormattingRule2) {
        return this.addConditionalFormatting(cellRangeAddressArray, (HSSFConditionalFormattingRule)conditionalFormattingRule, (HSSFConditionalFormattingRule)conditionalFormattingRule2);
    }

    public HSSFConditionalFormatting getConditionalFormattingAt(int n) {
        CFRecordsAggregate cFRecordsAggregate = this._conditionalFormattingTable.get(n);
        if (cFRecordsAggregate == null) {
            return null;
        }
        return new HSSFConditionalFormatting(this._sheet, cFRecordsAggregate);
    }

    public int getNumConditionalFormattings() {
        return this._conditionalFormattingTable.size();
    }

    public void removeConditionalFormatting(int n) {
        this._conditionalFormattingTable.remove(n);
    }
}

