/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.usermodel;

import ai2.org.apache.poi.hssf.record.CFRuleBase;
import ai2.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import ai2.org.apache.poi.hssf.util.HSSFColor;
import ai2.org.apache.poi.ss.usermodel.Color;
import ai2.org.apache.poi.ss.usermodel.PatternFormatting;

public class HSSFPatternFormatting
implements PatternFormatting {
    private final HSSFWorkbook workbook;
    private final CFRuleBase cfRuleRecord;
    private final ai2.org.apache.poi.hssf.record.cf.PatternFormatting patternFormatting;

    protected HSSFPatternFormatting(CFRuleBase cFRuleBase, HSSFWorkbook hSSFWorkbook) {
        this.workbook = hSSFWorkbook;
        this.cfRuleRecord = cFRuleBase;
        this.patternFormatting = cFRuleBase.getPatternFormatting();
    }

    protected ai2.org.apache.poi.hssf.record.cf.PatternFormatting getPatternFormattingBlock() {
        return this.patternFormatting;
    }

    public HSSFColor getFillBackgroundColorColor() {
        return this.workbook.getCustomPalette().getColor(this.getFillBackgroundColor());
    }

    public HSSFColor getFillForegroundColorColor() {
        return this.workbook.getCustomPalette().getColor(this.getFillForegroundColor());
    }

    public short getFillBackgroundColor() {
        return (short)this.patternFormatting.getFillBackgroundColor();
    }

    public short getFillForegroundColor() {
        return (short)this.patternFormatting.getFillForegroundColor();
    }

    public short getFillPattern() {
        return (short)this.patternFormatting.getFillPattern();
    }

    public void setFillBackgroundColor(Color color) {
        HSSFColor hSSFColor = HSSFColor.toHSSFColor(color);
        if (hSSFColor == null) {
            this.setFillBackgroundColor((short)0);
        } else {
            this.setFillBackgroundColor(hSSFColor.getIndex());
        }
    }

    public void setFillForegroundColor(Color color) {
        HSSFColor hSSFColor = HSSFColor.toHSSFColor(color);
        if (hSSFColor == null) {
            this.setFillForegroundColor((short)0);
        } else {
            this.setFillForegroundColor(hSSFColor.getIndex());
        }
    }

    public void setFillBackgroundColor(short s) {
        this.patternFormatting.setFillBackgroundColor(s);
        if (s != 0) {
            this.cfRuleRecord.setPatternBackgroundColorModified(true);
        }
    }

    public void setFillForegroundColor(short s) {
        this.patternFormatting.setFillForegroundColor(s);
        if (s != 0) {
            this.cfRuleRecord.setPatternColorModified(true);
        }
    }

    public void setFillPattern(short s) {
        this.patternFormatting.setFillPattern(s);
        if (s != 0) {
            this.cfRuleRecord.setPatternStyleModified(true);
        }
    }
}

