/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.usermodel;

import ai2.org.apache.poi.ddf.EscherComplexProperty;
import ai2.org.apache.poi.ddf.EscherContainerRecord;
import ai2.org.apache.poi.ddf.EscherDgRecord;
import ai2.org.apache.poi.ddf.EscherOptRecord;
import ai2.org.apache.poi.ddf.EscherProperty;
import ai2.org.apache.poi.ddf.EscherSpRecord;
import ai2.org.apache.poi.ddf.EscherSpgrRecord;
import ai2.org.apache.poi.hssf.model.DrawingManager2;
import ai2.org.apache.poi.hssf.record.CommonObjectDataSubRecord;
import ai2.org.apache.poi.hssf.record.EmbeddedObjectRefSubRecord;
import ai2.org.apache.poi.hssf.record.EndSubRecord;
import ai2.org.apache.poi.hssf.record.EscherAggregate;
import ai2.org.apache.poi.hssf.record.FtCfSubRecord;
import ai2.org.apache.poi.hssf.record.FtPioGrbitSubRecord;
import ai2.org.apache.poi.hssf.record.NoteRecord;
import ai2.org.apache.poi.hssf.record.ObjRecord;
import ai2.org.apache.poi.hssf.usermodel.HSSFAnchor;
import ai2.org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import ai2.org.apache.poi.hssf.usermodel.HSSFCombobox;
import ai2.org.apache.poi.hssf.usermodel.HSSFComment;
import ai2.org.apache.poi.hssf.usermodel.HSSFObjectData;
import ai2.org.apache.poi.hssf.usermodel.HSSFPicture;
import ai2.org.apache.poi.hssf.usermodel.HSSFPictureData;
import ai2.org.apache.poi.hssf.usermodel.HSSFPolygon;
import ai2.org.apache.poi.hssf.usermodel.HSSFShape;
import ai2.org.apache.poi.hssf.usermodel.HSSFShapeContainer;
import ai2.org.apache.poi.hssf.usermodel.HSSFShapeFactory;
import ai2.org.apache.poi.hssf.usermodel.HSSFShapeGroup;
import ai2.org.apache.poi.hssf.usermodel.HSSFSheet;
import ai2.org.apache.poi.hssf.usermodel.HSSFSimpleShape;
import ai2.org.apache.poi.hssf.usermodel.HSSFTextbox;
import ai2.org.apache.poi.hssf.util.CellReference;
import ai2.org.apache.poi.poifs.filesystem.DirectoryEntry;
import ai2.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai2.org.apache.poi.ss.usermodel.Chart;
import ai2.org.apache.poi.ss.usermodel.ClientAnchor;
import ai2.org.apache.poi.ss.usermodel.Drawing;
import ai2.org.apache.poi.util.HexDump;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.StringUtil;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HSSFPatriarch
implements HSSFShapeContainer,
Drawing {
    private final List<HSSFShape> _shapes = new ArrayList<HSSFShape>();
    private final EscherSpgrRecord _spgrRecord;
    private final EscherContainerRecord _mainSpgrContainer;
    private EscherAggregate _boundAggregate;
    private final HSSFSheet _sheet;

    HSSFPatriarch(HSSFSheet hSSFSheet, EscherAggregate escherAggregate) {
        this._sheet = hSSFSheet;
        this._boundAggregate = escherAggregate;
        this._mainSpgrContainer = this._boundAggregate.getEscherContainer().getChildContainers().get(0);
        EscherContainerRecord escherContainerRecord = (EscherContainerRecord)this._boundAggregate.getEscherContainer().getChildContainers().get(0).getChild(0);
        this._spgrRecord = (EscherSpgrRecord)escherContainerRecord.getChildById((short)-4087);
        this.buildShapeTree();
    }

    static HSSFPatriarch createPatriarch(HSSFPatriarch hSSFPatriarch, HSSFSheet hSSFSheet) {
        HSSFPatriarch hSSFPatriarch2 = new HSSFPatriarch(hSSFSheet, new EscherAggregate(true));
        hSSFPatriarch2.afterCreate();
        for (HSSFShape hSSFShape : hSSFPatriarch.getChildren()) {
            HSSFShape hSSFShape2 = hSSFShape instanceof HSSFShapeGroup ? ((HSSFShapeGroup)hSSFShape).cloneShape(hSSFPatriarch2) : hSSFShape.cloneShape();
            hSSFPatriarch2.onCreate(hSSFShape2);
            hSSFPatriarch2.addShape(hSSFShape2);
        }
        return hSSFPatriarch2;
    }

    protected void preSerialize() {
        Map<Integer, NoteRecord> map = this._boundAggregate.getTailRecords();
        HashSet<String> hashSet = new HashSet<String>(map.size());
        for (NoteRecord noteRecord : map.values()) {
            String string = new CellReference(noteRecord.getRow(), noteRecord.getColumn()).formatAsString();
            if (hashSet.contains(string)) {
                throw new IllegalStateException("found multiple cell comments for cell " + string);
            }
            hashSet.add(string);
        }
    }

    @Override
    public boolean removeShape(HSSFShape hSSFShape) {
        boolean bl = this._mainSpgrContainer.removeChildRecord(hSSFShape.getEscherContainer());
        if (bl) {
            hSSFShape.afterRemove(this);
            this._shapes.remove(hSSFShape);
        }
        return bl;
    }

    void afterCreate() {
        DrawingManager2 drawingManager2 = this._sheet.getWorkbook().getWorkbook().getDrawingManager();
        short s = drawingManager2.findNewDrawingGroupId();
        this._boundAggregate.setDgId(s);
        this._boundAggregate.setMainSpRecordId(this.newShapeId());
        drawingManager2.incrementDrawingsSaved();
    }

    public HSSFShapeGroup createGroup(HSSFClientAnchor hSSFClientAnchor) {
        HSSFShapeGroup hSSFShapeGroup = new HSSFShapeGroup(null, hSSFClientAnchor);
        this.addShape(hSSFShapeGroup);
        this.onCreate(hSSFShapeGroup);
        return hSSFShapeGroup;
    }

    public HSSFSimpleShape createSimpleShape(HSSFClientAnchor hSSFClientAnchor) {
        HSSFSimpleShape hSSFSimpleShape = new HSSFSimpleShape(null, hSSFClientAnchor);
        this.addShape(hSSFSimpleShape);
        this.onCreate(hSSFSimpleShape);
        return hSSFSimpleShape;
    }

    public HSSFPicture createPicture(HSSFClientAnchor hSSFClientAnchor, int n) {
        HSSFPicture hSSFPicture = new HSSFPicture(null, hSSFClientAnchor);
        hSSFPicture.setPictureIndex(n);
        this.addShape(hSSFPicture);
        this.onCreate(hSSFPicture);
        return hSSFPicture;
    }

    @Override
    public HSSFPicture createPicture(ClientAnchor clientAnchor, int n) {
        return this.createPicture((HSSFClientAnchor)clientAnchor, n);
    }

    public HSSFObjectData createObjectData(HSSFClientAnchor hSSFClientAnchor, int n, int n2) {
        DirectoryEntry directoryEntry;
        Object object;
        ObjRecord objRecord = new ObjRecord();
        CommonObjectDataSubRecord commonObjectDataSubRecord = new CommonObjectDataSubRecord();
        commonObjectDataSubRecord.setObjectType((short)8);
        commonObjectDataSubRecord.setLocked(true);
        commonObjectDataSubRecord.setPrintable(true);
        commonObjectDataSubRecord.setAutofill(true);
        commonObjectDataSubRecord.setAutoline(true);
        commonObjectDataSubRecord.setReserved1(0);
        commonObjectDataSubRecord.setReserved2(0);
        commonObjectDataSubRecord.setReserved3(0);
        objRecord.addSubRecord(commonObjectDataSubRecord);
        FtCfSubRecord ftCfSubRecord = new FtCfSubRecord();
        HSSFPictureData hSSFPictureData = this.getSheet().getWorkbook().getAllPictures().get(n2 - 1);
        switch (hSSFPictureData.getFormat()) {
            case 2: 
            case 3: {
                ftCfSubRecord.setFlags((short)2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                ftCfSubRecord.setFlags((short)9);
            }
        }
        objRecord.addSubRecord(ftCfSubRecord);
        FtPioGrbitSubRecord ftPioGrbitSubRecord = new FtPioGrbitSubRecord();
        ftPioGrbitSubRecord.setFlagByBit(1, true);
        objRecord.addSubRecord(ftPioGrbitSubRecord);
        EmbeddedObjectRefSubRecord embeddedObjectRefSubRecord = new EmbeddedObjectRefSubRecord();
        embeddedObjectRefSubRecord.setUnknownFormulaData(new byte[]{2, 0, 0, 0, 0});
        embeddedObjectRefSubRecord.setOleClassname("Paket");
        embeddedObjectRefSubRecord.setStorageId(n);
        objRecord.addSubRecord(embeddedObjectRefSubRecord);
        objRecord.addSubRecord(new EndSubRecord());
        String string = "MBD" + HexDump.toHex(n);
        try {
            object = this._sheet.getWorkbook().getRootDirectory();
            if (object == null) {
                throw new FileNotFoundException();
            }
            directoryEntry = (DirectoryEntry)((DirectoryNode)object).getEntry(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalStateException("trying to add ole shape without actually adding data first - use HSSFWorkbook.addOlePackage first", fileNotFoundException);
        }
        object = new HSSFPicture(null, hSSFClientAnchor);
        ((HSSFPicture)object).setPictureIndex(n2);
        EscherContainerRecord escherContainerRecord = ((HSSFShape)object).getEscherContainer();
        EscherSpRecord escherSpRecord = (EscherSpRecord)escherContainerRecord.getChildById((short)-4086);
        escherSpRecord.setFlags(escherSpRecord.getFlags() | 0x10);
        HSSFObjectData hSSFObjectData = new HSSFObjectData(escherContainerRecord, objRecord, directoryEntry);
        this.addShape(hSSFObjectData);
        this.onCreate(hSSFObjectData);
        return hSSFObjectData;
    }

    public HSSFPolygon createPolygon(HSSFClientAnchor hSSFClientAnchor) {
        HSSFPolygon hSSFPolygon = new HSSFPolygon(null, hSSFClientAnchor);
        this.addShape(hSSFPolygon);
        this.onCreate(hSSFPolygon);
        return hSSFPolygon;
    }

    public HSSFTextbox createTextbox(HSSFClientAnchor hSSFClientAnchor) {
        HSSFTextbox hSSFTextbox = new HSSFTextbox(null, hSSFClientAnchor);
        this.addShape(hSSFTextbox);
        this.onCreate(hSSFTextbox);
        return hSSFTextbox;
    }

    public HSSFComment createComment(HSSFAnchor hSSFAnchor) {
        HSSFComment hSSFComment = new HSSFComment(null, hSSFAnchor);
        this.addShape(hSSFComment);
        this.onCreate(hSSFComment);
        return hSSFComment;
    }

    HSSFSimpleShape createComboBox(HSSFAnchor hSSFAnchor) {
        HSSFCombobox hSSFCombobox = new HSSFCombobox(null, hSSFAnchor);
        this.addShape(hSSFCombobox);
        this.onCreate(hSSFCombobox);
        return hSSFCombobox;
    }

    @Override
    public HSSFComment createCellComment(ClientAnchor clientAnchor) {
        return this.createComment((HSSFAnchor)((Object)clientAnchor));
    }

    @Override
    public List<HSSFShape> getChildren() {
        return Collections.unmodifiableList(this._shapes);
    }

    @Override
    @Internal
    public void addShape(HSSFShape hSSFShape) {
        hSSFShape.setPatriarch(this);
        this._shapes.add(hSSFShape);
    }

    private void onCreate(HSSFShape hSSFShape) {
        EscherContainerRecord escherContainerRecord = this._boundAggregate.getEscherContainer().getChildContainers().get(0);
        EscherContainerRecord escherContainerRecord2 = hSSFShape.getEscherContainer();
        int n = this.newShapeId();
        hSSFShape.setShapeId(n);
        escherContainerRecord.addChildRecord(escherContainerRecord2);
        hSSFShape.afterInsert(this);
        this.setFlipFlags(hSSFShape);
    }

    public int countOfAllChildren() {
        int n = this._shapes.size();
        for (HSSFShape hSSFShape : this._shapes) {
            n += hSSFShape.countOfAllChildren();
        }
        return n;
    }

    @Override
    public void setCoordinates(int n, int n2, int n3, int n4) {
        this._spgrRecord.setRectY1(n2);
        this._spgrRecord.setRectY2(n4);
        this._spgrRecord.setRectX1(n);
        this._spgrRecord.setRectX2(n3);
    }

    @Override
    public void clear() {
        ArrayList<HSSFShape> arrayList = new ArrayList<HSSFShape>(this._shapes);
        for (HSSFShape hSSFShape : arrayList) {
            this.removeShape(hSSFShape);
        }
    }

    int newShapeId() {
        DrawingManager2 drawingManager2 = this._sheet.getWorkbook().getWorkbook().getDrawingManager();
        EscherDgRecord escherDgRecord = (EscherDgRecord)this._boundAggregate.getEscherContainer().getChildById((short)-4088);
        short s = escherDgRecord.getDrawingGroupId();
        return drawingManager2.allocateShapeId(s, escherDgRecord);
    }

    public boolean containsChart() {
        EscherOptRecord escherOptRecord = (EscherOptRecord)this._boundAggregate.findFirstWithId((short)-4085);
        if (escherOptRecord == null) {
            return false;
        }
        for (EscherProperty escherProperty : escherOptRecord.getEscherProperties()) {
            EscherComplexProperty escherComplexProperty;
            String string;
            if (escherProperty.getPropertyNumber() != 896 || !escherProperty.isComplex() || !(string = StringUtil.getFromUnicodeLE((escherComplexProperty = (EscherComplexProperty)escherProperty).getComplexData())).equals("Chart 1\u0000")) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getX1() {
        return this._spgrRecord.getRectX1();
    }

    @Override
    public int getY1() {
        return this._spgrRecord.getRectY1();
    }

    @Override
    public int getX2() {
        return this._spgrRecord.getRectX2();
    }

    @Override
    public int getY2() {
        return this._spgrRecord.getRectY2();
    }

    protected EscherAggregate _getBoundAggregate() {
        return this._boundAggregate;
    }

    @Override
    public HSSFClientAnchor createAnchor(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return new HSSFClientAnchor(n, n2, n3, n4, (short)n5, n6, (short)n7, n8);
    }

    @Override
    public Chart createChart(ClientAnchor clientAnchor) {
        throw new RuntimeException("NotImplemented");
    }

    void buildShapeTree() {
        EscherContainerRecord escherContainerRecord = this._boundAggregate.getEscherContainer();
        if (escherContainerRecord == null) {
            return;
        }
        EscherContainerRecord escherContainerRecord2 = escherContainerRecord.getChildContainers().get(0);
        List<EscherContainerRecord> list = escherContainerRecord2.getChildContainers();
        for (int i = 0; i < list.size(); ++i) {
            EscherContainerRecord escherContainerRecord3 = list.get(i);
            if (i == 0) continue;
            HSSFShapeFactory.createShapeTree(escherContainerRecord3, this._boundAggregate, this, this._sheet.getWorkbook().getRootDirectory());
        }
    }

    private void setFlipFlags(HSSFShape hSSFShape) {
        EscherSpRecord escherSpRecord = (EscherSpRecord)hSSFShape.getEscherContainer().getChildById((short)-4086);
        if (hSSFShape.getAnchor().isHorizontallyFlipped()) {
            escherSpRecord.setFlags(escherSpRecord.getFlags() | 0x40);
        }
        if (hSSFShape.getAnchor().isVerticallyFlipped()) {
            escherSpRecord.setFlags(escherSpRecord.getFlags() | 0x80);
        }
    }

    @Override
    public Iterator<HSSFShape> iterator() {
        return this._shapes.iterator();
    }

    protected HSSFSheet getSheet() {
        return this._sheet;
    }
}

