/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.usermodel;

import ai2.org.apache.poi.hssf.record.CFRuleBase;
import ai2.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import ai2.org.apache.poi.hssf.util.HSSFColor;
import ai2.org.apache.poi.ss.usermodel.Color;
import ai2.org.apache.poi.ss.usermodel.FontFormatting;

public final class HSSFFontFormatting
implements FontFormatting {
    public static final byte U_NONE = 0;
    public static final byte U_SINGLE = 1;
    public static final byte U_DOUBLE = 2;
    public static final byte U_SINGLE_ACCOUNTING = 33;
    public static final byte U_DOUBLE_ACCOUNTING = 34;
    private final ai2.org.apache.poi.hssf.record.cf.FontFormatting fontFormatting;
    private final HSSFWorkbook workbook;

    protected HSSFFontFormatting(CFRuleBase cFRuleBase, HSSFWorkbook hSSFWorkbook) {
        this.fontFormatting = cFRuleBase.getFontFormatting();
        this.workbook = hSSFWorkbook;
    }

    protected ai2.org.apache.poi.hssf.record.cf.FontFormatting getFontFormattingBlock() {
        return this.fontFormatting;
    }

    public short getEscapementType() {
        return this.fontFormatting.getEscapementType();
    }

    public short getFontColorIndex() {
        return this.fontFormatting.getFontColorIndex();
    }

    public HSSFColor getFontColor() {
        return this.workbook.getCustomPalette().getColor(this.getFontColorIndex());
    }

    public void setFontColor(Color color) {
        HSSFColor hSSFColor = HSSFColor.toHSSFColor(color);
        if (hSSFColor == null) {
            this.fontFormatting.setFontColorIndex((short)0);
        } else {
            this.fontFormatting.setFontColorIndex(hSSFColor.getIndex());
        }
    }

    public int getFontHeight() {
        return this.fontFormatting.getFontHeight();
    }

    public short getFontWeight() {
        return this.fontFormatting.getFontWeight();
    }

    protected byte[] getRawRecord() {
        return this.fontFormatting.getRawRecord();
    }

    public short getUnderlineType() {
        return this.fontFormatting.getUnderlineType();
    }

    public boolean isBold() {
        return this.fontFormatting.isFontWeightModified() && this.fontFormatting.isBold();
    }

    public boolean isEscapementTypeModified() {
        return this.fontFormatting.isEscapementTypeModified();
    }

    public boolean isFontCancellationModified() {
        return this.fontFormatting.isFontCancellationModified();
    }

    public boolean isFontOutlineModified() {
        return this.fontFormatting.isFontOutlineModified();
    }

    public boolean isFontShadowModified() {
        return this.fontFormatting.isFontShadowModified();
    }

    public boolean isFontStyleModified() {
        return this.fontFormatting.isFontStyleModified();
    }

    public boolean isItalic() {
        return this.fontFormatting.isFontStyleModified() && this.fontFormatting.isItalic();
    }

    public boolean isOutlineOn() {
        return this.fontFormatting.isFontOutlineModified() && this.fontFormatting.isOutlineOn();
    }

    public boolean isShadowOn() {
        return this.fontFormatting.isFontOutlineModified() && this.fontFormatting.isShadowOn();
    }

    public boolean isStruckout() {
        return this.fontFormatting.isFontCancellationModified() && this.fontFormatting.isStruckout();
    }

    public boolean isUnderlineTypeModified() {
        return this.fontFormatting.isUnderlineTypeModified();
    }

    public boolean isFontWeightModified() {
        return this.fontFormatting.isFontWeightModified();
    }

    public void setFontStyle(boolean bl, boolean bl2) {
        boolean bl3 = bl || bl2;
        this.fontFormatting.setItalic(bl);
        this.fontFormatting.setBold(bl2);
        this.fontFormatting.setFontStyleModified(bl3);
        this.fontFormatting.setFontWieghtModified(bl3);
    }

    public void resetFontStyle() {
        this.setFontStyle(false, false);
    }

    public void setEscapementType(short s) {
        switch (s) {
            case 1: 
            case 2: {
                this.fontFormatting.setEscapementType(s);
                this.fontFormatting.setEscapementTypeModified(true);
                break;
            }
            case 0: {
                this.fontFormatting.setEscapementType(s);
                this.fontFormatting.setEscapementTypeModified(false);
                break;
            }
        }
    }

    public void setEscapementTypeModified(boolean bl) {
        this.fontFormatting.setEscapementTypeModified(bl);
    }

    public void setFontCancellationModified(boolean bl) {
        this.fontFormatting.setFontCancellationModified(bl);
    }

    public void setFontColorIndex(short s) {
        this.fontFormatting.setFontColorIndex(s);
    }

    public void setFontHeight(int n) {
        this.fontFormatting.setFontHeight(n);
    }

    public void setFontOutlineModified(boolean bl) {
        this.fontFormatting.setFontOutlineModified(bl);
    }

    public void setFontShadowModified(boolean bl) {
        this.fontFormatting.setFontShadowModified(bl);
    }

    public void setFontStyleModified(boolean bl) {
        this.fontFormatting.setFontStyleModified(bl);
    }

    public void setOutline(boolean bl) {
        this.fontFormatting.setOutline(bl);
        this.fontFormatting.setFontOutlineModified(bl);
    }

    public void setShadow(boolean bl) {
        this.fontFormatting.setShadow(bl);
        this.fontFormatting.setFontShadowModified(bl);
    }

    public void setStrikeout(boolean bl) {
        this.fontFormatting.setStrikeout(bl);
        this.fontFormatting.setFontCancellationModified(bl);
    }

    public void setUnderlineType(short s) {
        switch (s) {
            case 1: 
            case 2: 
            case 33: 
            case 34: {
                this.fontFormatting.setUnderlineType(s);
                this.setUnderlineTypeModified(true);
                break;
            }
            case 0: {
                this.fontFormatting.setUnderlineType(s);
                this.setUnderlineTypeModified(false);
                break;
            }
        }
    }

    public void setUnderlineTypeModified(boolean bl) {
        this.fontFormatting.setUnderlineTypeModified(bl);
    }
}

