/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.usermodel;

import ai2.org.apache.poi.hssf.record.FontRecord;
import ai2.org.apache.poi.hssf.usermodel.HSSFPalette;
import ai2.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import ai2.org.apache.poi.hssf.util.HSSFColor;
import ai2.org.apache.poi.ss.usermodel.Font;

public final class HSSFFont
implements Font {
    public static final String FONT_ARIAL = "Arial";
    private FontRecord font;
    private short index;

    protected HSSFFont(short s, FontRecord fontRecord) {
        this.font = fontRecord;
        this.index = s;
    }

    public void setFontName(String string) {
        this.font.setFontName(string);
    }

    public String getFontName() {
        return this.font.getFontName();
    }

    public short getIndex() {
        return this.index;
    }

    public void setFontHeight(short s) {
        this.font.setFontHeight(s);
    }

    public void setFontHeightInPoints(short s) {
        this.font.setFontHeight((short)(s * 20));
    }

    public short getFontHeight() {
        return this.font.getFontHeight();
    }

    public short getFontHeightInPoints() {
        return (short)(this.font.getFontHeight() / 20);
    }

    public void setItalic(boolean bl) {
        this.font.setItalic(bl);
    }

    public boolean getItalic() {
        return this.font.isItalic();
    }

    public void setStrikeout(boolean bl) {
        this.font.setStrikeout(bl);
    }

    public boolean getStrikeout() {
        return this.font.isStruckout();
    }

    public void setColor(short s) {
        this.font.setColorPaletteIndex(s);
    }

    public short getColor() {
        return this.font.getColorPaletteIndex();
    }

    public HSSFColor getHSSFColor(HSSFWorkbook hSSFWorkbook) {
        HSSFPalette hSSFPalette = hSSFWorkbook.getCustomPalette();
        return hSSFPalette.getColor(this.getColor());
    }

    public void setBoldweight(short s) {
        this.font.setBoldWeight(s);
    }

    public void setBold(boolean bl) {
        if (bl) {
            this.font.setBoldWeight((short)700);
        } else {
            this.font.setBoldWeight((short)400);
        }
    }

    public short getBoldweight() {
        return this.font.getBoldWeight();
    }

    public boolean getBold() {
        return this.getBoldweight() == 700;
    }

    public void setTypeOffset(short s) {
        this.font.setSuperSubScript(s);
    }

    public short getTypeOffset() {
        return this.font.getSuperSubScript();
    }

    public void setUnderline(byte by) {
        this.font.setUnderline(by);
    }

    public byte getUnderline() {
        return this.font.getUnderline();
    }

    public int getCharSet() {
        byte by = this.font.getCharset();
        if (by >= 0) {
            return by;
        }
        return by + 256;
    }

    public void setCharSet(int n) {
        byte by = (byte)n;
        if (n > 127) {
            by = (byte)(n - 256);
        }
        this.setCharSet(by);
    }

    public void setCharSet(byte by) {
        this.font.setCharset(by);
    }

    public String toString() {
        return "ai2.org.apache.poi.hssf.usermodel.HSSFFont{" + this.font + "}";
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.font == null ? 0 : this.font.hashCode());
        n = 31 * n + this.index;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof HSSFFont) {
            HSSFFont hSSFFont = (HSSFFont)object;
            if (this.font == null ? hSSFFont.font != null : !this.font.equals(hSSFFont.font)) {
                return false;
            }
            return this.index == hSSFFont.index;
        }
        return false;
    }
}

