/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.usermodel;

import ai2.org.apache.poi.ss.usermodel.ExtendedColor;

public class HSSFExtendedColor
extends ExtendedColor {
    private ai2.org.apache.poi.hssf.record.common.ExtendedColor color;

    public HSSFExtendedColor(ai2.org.apache.poi.hssf.record.common.ExtendedColor extendedColor) {
        this.color = extendedColor;
    }

    protected ai2.org.apache.poi.hssf.record.common.ExtendedColor getExtendedColor() {
        return this.color;
    }

    public boolean isAuto() {
        return this.color.getType() == 0;
    }

    public boolean isIndexed() {
        return this.color.getType() == 1;
    }

    public boolean isRGB() {
        return this.color.getType() == 2;
    }

    public boolean isThemed() {
        return this.color.getType() == 3;
    }

    public short getIndex() {
        return (short)this.color.getColorIndex();
    }

    public int getTheme() {
        return this.color.getThemeIndex();
    }

    public byte[] getRGB() {
        byte[] byArray = new byte[3];
        byte[] byArray2 = this.color.getRGBA();
        if (byArray2 == null) {
            return null;
        }
        System.arraycopy(byArray2, 0, byArray, 0, 3);
        return byArray;
    }

    public byte[] getARGB() {
        byte[] byArray = new byte[4];
        byte[] byArray2 = this.color.getRGBA();
        if (byArray2 == null) {
            return null;
        }
        System.arraycopy(byArray2, 0, byArray, 1, 3);
        byArray[0] = byArray2[3];
        return byArray;
    }

    protected byte[] getStoredRBG() {
        return this.getARGB();
    }

    public void setRGB(byte[] byArray) {
        if (byArray.length == 3) {
            byte[] byArray2 = new byte[4];
            System.arraycopy(byArray, 0, byArray2, 0, 3);
            byArray2[3] = -1;
        } else {
            byte by = byArray[0];
            byArray[0] = byArray[1];
            byArray[1] = byArray[2];
            byArray[2] = byArray[3];
            byArray[3] = by;
            this.color.setRGBA(byArray);
        }
    }

    public double getTint() {
        return this.color.getTint();
    }

    public void setTint(double d) {
        this.color.setTint(d);
    }
}

