/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.usermodel;

import ai2.org.apache.poi.hssf.record.CFRule12Record;
import ai2.org.apache.poi.hssf.record.cf.DataBarThreshold;
import ai2.org.apache.poi.hssf.usermodel.HSSFConditionalFormattingThreshold;
import ai2.org.apache.poi.hssf.usermodel.HSSFExtendedColor;
import ai2.org.apache.poi.hssf.usermodel.HSSFSheet;
import ai2.org.apache.poi.ss.usermodel.Color;
import ai2.org.apache.poi.ss.usermodel.DataBarFormatting;

public final class HSSFDataBarFormatting
implements DataBarFormatting {
    private final HSSFSheet sheet;
    private final CFRule12Record cfRule12Record;
    private final ai2.org.apache.poi.hssf.record.cf.DataBarFormatting databarFormatting;

    protected HSSFDataBarFormatting(CFRule12Record cFRule12Record, HSSFSheet hSSFSheet) {
        this.sheet = hSSFSheet;
        this.cfRule12Record = cFRule12Record;
        this.databarFormatting = this.cfRule12Record.getDataBarFormatting();
    }

    public boolean isLeftToRight() {
        return !this.databarFormatting.isReversed();
    }

    public void setLeftToRight(boolean bl) {
        this.databarFormatting.setReversed(!bl);
    }

    public int getWidthMin() {
        return this.databarFormatting.getPercentMin();
    }

    public void setWidthMin(int n) {
        this.databarFormatting.setPercentMin((byte)n);
    }

    public int getWidthMax() {
        return this.databarFormatting.getPercentMax();
    }

    public void setWidthMax(int n) {
        this.databarFormatting.setPercentMax((byte)n);
    }

    public HSSFExtendedColor getColor() {
        return new HSSFExtendedColor(this.databarFormatting.getColor());
    }

    public void setColor(Color color) {
        HSSFExtendedColor hSSFExtendedColor = (HSSFExtendedColor)color;
        this.databarFormatting.setColor(hSSFExtendedColor.getExtendedColor());
    }

    public HSSFConditionalFormattingThreshold getMinThreshold() {
        return new HSSFConditionalFormattingThreshold(this.databarFormatting.getThresholdMin(), this.sheet);
    }

    public HSSFConditionalFormattingThreshold getMaxThreshold() {
        return new HSSFConditionalFormattingThreshold(this.databarFormatting.getThresholdMax(), this.sheet);
    }

    public boolean isIconOnly() {
        return this.databarFormatting.isIconOnly();
    }

    public void setIconOnly(boolean bl) {
        this.databarFormatting.setIconOnly(bl);
    }

    public HSSFConditionalFormattingThreshold createThreshold() {
        return new HSSFConditionalFormattingThreshold(new DataBarThreshold(), this.sheet);
    }
}

