/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.usermodel;

import ai2.org.apache.poi.hssf.record.CFRuleBase;
import ai2.org.apache.poi.hssf.record.cf.Threshold;
import ai2.org.apache.poi.hssf.usermodel.HSSFConditionalFormattingRule;
import ai2.org.apache.poi.hssf.usermodel.HSSFSheet;
import ai2.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import ai2.org.apache.poi.ss.usermodel.ConditionalFormattingThreshold;

public final class HSSFConditionalFormattingThreshold
implements ConditionalFormattingThreshold {
    private final Threshold threshold;
    private final HSSFSheet sheet;
    private final HSSFWorkbook workbook;

    protected HSSFConditionalFormattingThreshold(Threshold threshold, HSSFSheet hSSFSheet) {
        this.threshold = threshold;
        this.sheet = hSSFSheet;
        this.workbook = hSSFSheet.getWorkbook();
    }

    protected Threshold getThreshold() {
        return this.threshold;
    }

    public ConditionalFormattingThreshold.RangeType getRangeType() {
        return ConditionalFormattingThreshold.RangeType.byId(this.threshold.getType());
    }

    public void setRangeType(ConditionalFormattingThreshold.RangeType rangeType) {
        this.threshold.setType((byte)rangeType.id);
    }

    public String getFormula() {
        return HSSFConditionalFormattingRule.toFormulaString(this.threshold.getParsedExpression(), this.workbook);
    }

    public void setFormula(String string) {
        this.threshold.setParsedExpression(CFRuleBase.parseFormula(string, this.sheet));
    }

    public Double getValue() {
        return this.threshold.getValue();
    }

    public void setValue(Double d) {
        this.threshold.setValue(d);
    }
}

