/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record.cont;

import ai2.org.apache.poi.util.DelayableLittleEndianOutput;
import ai2.org.apache.poi.util.LittleEndianByteArrayOutputStream;
import ai2.org.apache.poi.util.LittleEndianOutput;

final class UnknownLengthRecordOutput
implements LittleEndianOutput {
    private static final int MAX_DATA_SIZE = 8224;
    private final LittleEndianOutput _originalOut;
    private final LittleEndianOutput _dataSizeOutput;
    private final byte[] _byteBuffer;
    private LittleEndianOutput _out;
    private int _size;

    public UnknownLengthRecordOutput(LittleEndianOutput littleEndianOutput, int n) {
        this._originalOut = littleEndianOutput;
        littleEndianOutput.writeShort(n);
        if (littleEndianOutput instanceof DelayableLittleEndianOutput) {
            DelayableLittleEndianOutput delayableLittleEndianOutput = (DelayableLittleEndianOutput)littleEndianOutput;
            this._dataSizeOutput = delayableLittleEndianOutput.createDelayedOutput(2);
            this._byteBuffer = null;
            this._out = littleEndianOutput;
        } else {
            this._dataSizeOutput = littleEndianOutput;
            this._byteBuffer = new byte[8224];
            this._out = new LittleEndianByteArrayOutputStream(this._byteBuffer, 0);
        }
    }

    public int getTotalSize() {
        return 4 + this._size;
    }

    public int getAvailableSpace() {
        if (this._out == null) {
            throw new IllegalStateException("Record already terminated");
        }
        return 8224 - this._size;
    }

    public void terminate() {
        if (this._out == null) {
            throw new IllegalStateException("Record already terminated");
        }
        this._dataSizeOutput.writeShort(this._size);
        if (this._byteBuffer != null) {
            this._originalOut.write(this._byteBuffer, 0, this._size);
            this._out = null;
            return;
        }
        this._out = null;
    }

    public void write(byte[] byArray) {
        this._out.write(byArray);
        this._size += byArray.length;
    }

    public void write(byte[] byArray, int n, int n2) {
        this._out.write(byArray, n, n2);
        this._size += n2;
    }

    public void writeByte(int n) {
        this._out.writeByte(n);
        ++this._size;
    }

    public void writeDouble(double d) {
        this._out.writeDouble(d);
        this._size += 8;
    }

    public void writeInt(int n) {
        this._out.writeInt(n);
        this._size += 4;
    }

    public void writeLong(long l) {
        this._out.writeLong(l);
        this._size += 8;
    }

    public void writeShort(int n) {
        this._out.writeShort(n);
        this._size += 2;
    }
}

