/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record.cont;

import ai2.org.apache.poi.hssf.record.cont.UnknownLengthRecordOutput;
import ai2.org.apache.poi.util.DelayableLittleEndianOutput;
import ai2.org.apache.poi.util.LittleEndianOutput;
import ai2.org.apache.poi.util.StringUtil;

public final class ContinuableRecordOutput
implements LittleEndianOutput {
    private final LittleEndianOutput _out;
    private UnknownLengthRecordOutput _ulrOutput;
    private int _totalPreviousRecordsSize;
    private static final LittleEndianOutput NOPOutput = new DelayableLittleEndianOutput(){

        public LittleEndianOutput createDelayedOutput(int n) {
            return this;
        }

        public void write(byte[] byArray) {
        }

        public void write(byte[] byArray, int n, int n2) {
        }

        public void writeByte(int n) {
        }

        public void writeDouble(double d) {
        }

        public void writeInt(int n) {
        }

        public void writeLong(long l) {
        }

        public void writeShort(int n) {
        }
    };

    public ContinuableRecordOutput(LittleEndianOutput littleEndianOutput, int n) {
        this._ulrOutput = new UnknownLengthRecordOutput(littleEndianOutput, n);
        this._out = littleEndianOutput;
        this._totalPreviousRecordsSize = 0;
    }

    public static ContinuableRecordOutput createForCountingOnly() {
        return new ContinuableRecordOutput(NOPOutput, -777);
    }

    public int getTotalSize() {
        return this._totalPreviousRecordsSize + this._ulrOutput.getTotalSize();
    }

    void terminate() {
        this._ulrOutput.terminate();
    }

    public int getAvailableSpace() {
        return this._ulrOutput.getAvailableSpace();
    }

    public void writeContinue() {
        this._ulrOutput.terminate();
        this._totalPreviousRecordsSize += this._ulrOutput.getTotalSize();
        this._ulrOutput = new UnknownLengthRecordOutput(this._out, 60);
    }

    public void writeContinueIfRequired(int n) {
        if (this._ulrOutput.getAvailableSpace() < n) {
            this.writeContinue();
        }
    }

    public void writeStringData(String string) {
        boolean bl = StringUtil.hasMultibyte(string);
        int n = 2;
        int n2 = 0;
        if (bl) {
            n2 |= 1;
            ++n;
        }
        this.writeContinueIfRequired(n);
        this.writeByte(n2);
        this.writeCharacterData(string, bl);
    }

    public void writeString(String string, int n, int n2) {
        boolean bl = StringUtil.hasMultibyte(string);
        int n3 = 4;
        int n4 = 0;
        if (bl) {
            n4 |= 1;
            ++n3;
        }
        if (n > 0) {
            n4 |= 8;
            n3 += 2;
        }
        if (n2 > 0) {
            n4 |= 4;
            n3 += 4;
        }
        this.writeContinueIfRequired(n3);
        this.writeShort(string.length());
        this.writeByte(n4);
        if (n > 0) {
            this.writeShort(n);
        }
        if (n2 > 0) {
            this.writeInt(n2);
        }
        this.writeCharacterData(string, bl);
    }

    private void writeCharacterData(String string, boolean bl) {
        int n = string.length();
        int n2 = 0;
        if (bl) {
            while (true) {
                for (int i = Math.min(n - n2, this._ulrOutput.getAvailableSpace() / 2); i > 0; --i) {
                    this._ulrOutput.writeShort(string.charAt(n2++));
                }
                if (n2 < n) {
                    this.writeContinue();
                    this.writeByte(1);
                    continue;
                }
                break;
            }
        } else {
            while (true) {
                for (int i = Math.min(n - n2, this._ulrOutput.getAvailableSpace() / 1); i > 0; --i) {
                    this._ulrOutput.writeByte(string.charAt(n2++));
                }
                if (n2 >= n) break;
                this.writeContinue();
                this.writeByte(0);
            }
        }
    }

    public void write(byte[] byArray) {
        this.writeContinueIfRequired(byArray.length);
        this._ulrOutput.write(byArray);
    }

    public void write(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (true) {
            for (int i = Math.min(n2 - n3, this._ulrOutput.getAvailableSpace() / 1); i > 0; --i) {
                this._ulrOutput.writeByte(byArray[n + n3++]);
            }
            if (n3 >= n2) break;
            this.writeContinue();
        }
    }

    public void writeByte(int n) {
        this.writeContinueIfRequired(1);
        this._ulrOutput.writeByte(n);
    }

    public void writeDouble(double d) {
        this.writeContinueIfRequired(8);
        this._ulrOutput.writeDouble(d);
    }

    public void writeInt(int n) {
        this.writeContinueIfRequired(4);
        this._ulrOutput.writeInt(n);
    }

    public void writeLong(long l) {
        this.writeContinueIfRequired(8);
        this._ulrOutput.writeLong(l);
    }

    public void writeShort(int n) {
        this.writeContinueIfRequired(2);
        this._ulrOutput.writeShort(n);
    }
}

