/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record.common;

import ai2.org.apache.poi.hssf.record.RecordInputStream;
import ai2.org.apache.poi.ss.util.CellRangeAddress;
import ai2.org.apache.poi.util.LittleEndianOutput;

public final class FtrHeader {
    private short recordType;
    private short grbitFrt;
    private CellRangeAddress associatedRange;

    public FtrHeader() {
        this.associatedRange = new CellRangeAddress(0, 0, 0, 0);
    }

    public FtrHeader(RecordInputStream recordInputStream) {
        this.recordType = recordInputStream.readShort();
        this.grbitFrt = recordInputStream.readShort();
        this.associatedRange = new CellRangeAddress(recordInputStream);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" [FUTURE HEADER]\n");
        stringBuffer.append("   Type " + this.recordType);
        stringBuffer.append("   Flags " + this.grbitFrt);
        stringBuffer.append(" [/FUTURE HEADER]\n");
        return stringBuffer.toString();
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this.recordType);
        littleEndianOutput.writeShort(this.grbitFrt);
        this.associatedRange.serialize(littleEndianOutput);
    }

    public static int getDataSize() {
        return 12;
    }

    public short getRecordType() {
        return this.recordType;
    }

    public void setRecordType(short s) {
        this.recordType = s;
    }

    public short getGrbitFrt() {
        return this.grbitFrt;
    }

    public void setGrbitFrt(short s) {
        this.grbitFrt = s;
    }

    public CellRangeAddress getAssociatedRange() {
        return this.associatedRange;
    }

    public void setAssociatedRange(CellRangeAddress cellRangeAddress) {
        this.associatedRange = cellRangeAddress;
    }

    public Object clone() {
        FtrHeader ftrHeader = new FtrHeader();
        ftrHeader.recordType = this.recordType;
        ftrHeader.grbitFrt = this.grbitFrt;
        ftrHeader.associatedRange = this.associatedRange.copy();
        return ftrHeader;
    }
}

