/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record.common;

import ai2.org.apache.poi.util.HexDump;
import ai2.org.apache.poi.util.LittleEndianInput;
import ai2.org.apache.poi.util.LittleEndianOutput;

public final class ExtendedColor {
    public static final int TYPE_AUTO = 0;
    public static final int TYPE_INDEXED = 1;
    public static final int TYPE_RGB = 2;
    public static final int TYPE_THEMED = 3;
    public static final int TYPE_UNSET = 4;
    public static final int THEME_DARK_1 = 0;
    public static final int THEME_LIGHT_1 = 1;
    public static final int THEME_DARK_2 = 2;
    public static final int THEME_LIGHT_2 = 3;
    public static final int THEME_ACCENT_1 = 4;
    public static final int THEME_ACCENT_2 = 5;
    public static final int THEME_ACCENT_3 = 6;
    public static final int THEME_ACCENT_4 = 7;
    public static final int THEME_ACCENT_5 = 8;
    public static final int THEME_ACCENT_6 = 9;
    public static final int THEME_HYPERLINK = 10;
    public static final int THEME_FOLLOWED_HYPERLINK = 11;
    private int type;
    private int colorIndex;
    private byte[] rgba;
    private int themeIndex;
    private double tint;

    public ExtendedColor() {
        this.type = 1;
        this.colorIndex = 0;
        this.tint = 0.0;
    }

    public ExtendedColor(LittleEndianInput littleEndianInput) {
        this.type = littleEndianInput.readInt();
        if (this.type == 1) {
            this.colorIndex = littleEndianInput.readInt();
        } else if (this.type == 2) {
            this.rgba = new byte[4];
            littleEndianInput.readFully(this.rgba);
        } else if (this.type == 3) {
            this.themeIndex = littleEndianInput.readInt();
        } else {
            littleEndianInput.readInt();
        }
        this.tint = littleEndianInput.readDouble();
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getColorIndex() {
        return this.colorIndex;
    }

    public void setColorIndex(int n) {
        this.colorIndex = n;
    }

    public byte[] getRGBA() {
        return this.rgba;
    }

    public void setRGBA(byte[] byArray) {
        this.rgba = byArray;
    }

    public int getThemeIndex() {
        return this.themeIndex;
    }

    public void setThemeIndex(int n) {
        this.themeIndex = n;
    }

    public double getTint() {
        return this.tint;
    }

    public void setTint(double d) {
        if (d < -1.0 || d > 1.0) {
            throw new IllegalArgumentException("Tint/Shade must be between -1 and +1");
        }
        this.tint = d;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("    [Extended Color]\n");
        stringBuffer.append("          .type  = ").append(this.type).append("\n");
        stringBuffer.append("          .tint  = ").append(this.tint).append("\n");
        stringBuffer.append("          .c_idx = ").append(this.colorIndex).append("\n");
        stringBuffer.append("          .rgba  = ").append(HexDump.toHex(this.rgba)).append("\n");
        stringBuffer.append("          .t_idx = ").append(this.themeIndex).append("\n");
        stringBuffer.append("    [/Extended Color]\n");
        return stringBuffer.toString();
    }

    public Object clone() {
        ExtendedColor extendedColor = new ExtendedColor();
        extendedColor.type = this.type;
        extendedColor.tint = this.tint;
        if (this.type == 1) {
            extendedColor.colorIndex = this.colorIndex;
        } else if (this.type == 2) {
            extendedColor.rgba = new byte[4];
            System.arraycopy(this.rgba, 0, extendedColor.rgba, 0, 4);
        } else if (this.type == 3) {
            extendedColor.themeIndex = this.themeIndex;
        }
        return extendedColor;
    }

    public int getDataLength() {
        return 16;
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeInt(this.type);
        if (this.type == 1) {
            littleEndianOutput.writeInt(this.colorIndex);
        } else if (this.type == 2) {
            littleEndianOutput.write(this.rgba);
        } else if (this.type == 3) {
            littleEndianOutput.writeInt(this.themeIndex);
        } else {
            littleEndianOutput.writeInt(0);
        }
        littleEndianOutput.writeDouble(this.tint);
    }
}

