/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record.chart;

import ai2.org.apache.poi.hssf.record.RecordInputStream;
import ai2.org.apache.poi.hssf.record.StandardRecord;
import ai2.org.apache.poi.util.LittleEndianOutput;
import java.util.Arrays;

public final class SeriesListRecord
extends StandardRecord {
    public static final short sid = 4118;
    private short[] field_1_seriesNumbers;

    public SeriesListRecord(short[] sArray) {
        this.field_1_seriesNumbers = sArray;
    }

    public SeriesListRecord(RecordInputStream recordInputStream) {
        int n = recordInputStream.readUShort();
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = recordInputStream.readShort();
        }
        this.field_1_seriesNumbers = sArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[SERIESLIST]\n");
        stringBuffer.append("    .seriesNumbers= ").append(" (").append(Arrays.toString(this.getSeriesNumbers())).append(" )");
        stringBuffer.append("\n");
        stringBuffer.append("[/SERIESLIST]\n");
        return stringBuffer.toString();
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        int n = this.field_1_seriesNumbers.length;
        littleEndianOutput.writeShort(n);
        for (int i = 0; i < n; ++i) {
            littleEndianOutput.writeShort(this.field_1_seriesNumbers[i]);
        }
    }

    protected int getDataSize() {
        return this.field_1_seriesNumbers.length * 2 + 2;
    }

    public short getSid() {
        return 4118;
    }

    public Object clone() {
        return new SeriesListRecord((short[])this.field_1_seriesNumbers.clone());
    }

    public short[] getSeriesNumbers() {
        return this.field_1_seriesNumbers;
    }
}

