/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record.chart;

import ai2.org.apache.poi.hssf.record.RecordInputStream;
import ai2.org.apache.poi.hssf.record.StandardRecord;
import ai2.org.apache.poi.util.HexDump;
import ai2.org.apache.poi.util.LittleEndianInput;
import ai2.org.apache.poi.util.LittleEndianOutput;

public final class ChartFRTInfoRecord
extends StandardRecord {
    public static final short sid = 2128;
    private short rt;
    private short grbitFrt;
    private byte verOriginator;
    private byte verWriter;
    private CFRTID[] rgCFRTID;

    public ChartFRTInfoRecord(RecordInputStream recordInputStream) {
        this.rt = recordInputStream.readShort();
        this.grbitFrt = recordInputStream.readShort();
        this.verOriginator = recordInputStream.readByte();
        this.verWriter = recordInputStream.readByte();
        int n = recordInputStream.readShort();
        this.rgCFRTID = new CFRTID[n];
        for (int i = 0; i < n; ++i) {
            this.rgCFRTID[i] = new CFRTID(recordInputStream);
        }
    }

    protected int getDataSize() {
        return 8 + this.rgCFRTID.length * 4;
    }

    public short getSid() {
        return 2128;
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this.rt);
        littleEndianOutput.writeShort(this.grbitFrt);
        littleEndianOutput.writeByte(this.verOriginator);
        littleEndianOutput.writeByte(this.verWriter);
        int n = this.rgCFRTID.length;
        littleEndianOutput.writeShort(n);
        for (int i = 0; i < n; ++i) {
            this.rgCFRTID[i].serialize(littleEndianOutput);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[CHARTFRTINFO]\n");
        stringBuffer.append("    .rt           =").append(HexDump.shortToHex(this.rt)).append('\n');
        stringBuffer.append("    .grbitFrt     =").append(HexDump.shortToHex(this.grbitFrt)).append('\n');
        stringBuffer.append("    .verOriginator=").append(HexDump.byteToHex(this.verOriginator)).append('\n');
        stringBuffer.append("    .verWriter    =").append(HexDump.byteToHex(this.verOriginator)).append('\n');
        stringBuffer.append("    .nCFRTIDs     =").append(HexDump.shortToHex(this.rgCFRTID.length)).append('\n');
        stringBuffer.append("[/CHARTFRTINFO]\n");
        return stringBuffer.toString();
    }

    private static final class CFRTID {
        public static final int ENCODED_SIZE = 4;
        private int rtFirst;
        private int rtLast;

        public CFRTID(LittleEndianInput littleEndianInput) {
            this.rtFirst = littleEndianInput.readShort();
            this.rtLast = littleEndianInput.readShort();
        }

        public void serialize(LittleEndianOutput littleEndianOutput) {
            littleEndianOutput.writeShort(this.rtFirst);
            littleEndianOutput.writeShort(this.rtLast);
        }
    }
}

