/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record.chart;

import ai2.org.apache.poi.hssf.record.RecordInputStream;
import ai2.org.apache.poi.hssf.record.StandardRecord;
import ai2.org.apache.poi.util.HexDump;
import ai2.org.apache.poi.util.LittleEndianOutput;

public final class ChartEndObjectRecord
extends StandardRecord {
    public static final short sid = 2133;
    private short rt;
    private short grbitFrt;
    private short iObjectKind;
    private byte[] reserved;

    public ChartEndObjectRecord(RecordInputStream recordInputStream) {
        this.rt = recordInputStream.readShort();
        this.grbitFrt = recordInputStream.readShort();
        this.iObjectKind = recordInputStream.readShort();
        this.reserved = new byte[6];
        if (recordInputStream.available() != 0) {
            recordInputStream.readFully(this.reserved);
        }
    }

    protected int getDataSize() {
        return 12;
    }

    public short getSid() {
        return 2133;
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this.rt);
        littleEndianOutput.writeShort(this.grbitFrt);
        littleEndianOutput.writeShort(this.iObjectKind);
        littleEndianOutput.write(this.reserved);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ENDOBJECT]\n");
        stringBuffer.append("    .rt         =").append(HexDump.shortToHex(this.rt)).append('\n');
        stringBuffer.append("    .grbitFrt   =").append(HexDump.shortToHex(this.grbitFrt)).append('\n');
        stringBuffer.append("    .iObjectKind=").append(HexDump.shortToHex(this.iObjectKind)).append('\n');
        stringBuffer.append("    .reserved   =").append(HexDump.toHex(this.reserved)).append('\n');
        stringBuffer.append("[/ENDOBJECT]\n");
        return stringBuffer.toString();
    }
}

