/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hssf.record.chart;

import ai2.org.apache.poi.hssf.record.RecordInputStream;
import ai2.org.apache.poi.hssf.record.StandardRecord;
import ai2.org.apache.poi.util.HexDump;
import ai2.org.apache.poi.util.LittleEndianOutput;

public final class CatLabRecord
extends StandardRecord {
    public static final short sid = 2134;
    private short rt;
    private short grbitFrt;
    private short wOffset;
    private short at;
    private short grbit;
    private Short unused;

    public CatLabRecord(RecordInputStream recordInputStream) {
        this.rt = recordInputStream.readShort();
        this.grbitFrt = recordInputStream.readShort();
        this.wOffset = recordInputStream.readShort();
        this.at = recordInputStream.readShort();
        this.grbit = recordInputStream.readShort();
        this.unused = recordInputStream.available() == 0 ? null : Short.valueOf(recordInputStream.readShort());
    }

    protected int getDataSize() {
        return 10 + (this.unused == null ? 0 : 2);
    }

    public short getSid() {
        return 2134;
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this.rt);
        littleEndianOutput.writeShort(this.grbitFrt);
        littleEndianOutput.writeShort(this.wOffset);
        littleEndianOutput.writeShort(this.at);
        littleEndianOutput.writeShort(this.grbit);
        if (this.unused != null) {
            littleEndianOutput.writeShort(this.unused.shortValue());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[CATLAB]\n");
        stringBuffer.append("    .rt      =").append(HexDump.shortToHex(this.rt)).append('\n');
        stringBuffer.append("    .grbitFrt=").append(HexDump.shortToHex(this.grbitFrt)).append('\n');
        stringBuffer.append("    .wOffset =").append(HexDump.shortToHex(this.wOffset)).append('\n');
        stringBuffer.append("    .at      =").append(HexDump.shortToHex(this.at)).append('\n');
        stringBuffer.append("    .grbit   =").append(HexDump.shortToHex(this.grbit)).append('\n');
        if (this.unused != null) {
            stringBuffer.append("    .unused  =").append(HexDump.shortToHex(this.unused.shortValue())).append('\n');
        }
        stringBuffer.append("[/CATLAB]\n");
        return stringBuffer.toString();
    }
}

